/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.RetrieverEngine;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.impl.DocumentTypeSchemaWsdlParser;
import org.netbeans.modules.xml.retriever.impl.ResourceRetriever;
import org.netbeans.modules.xml.retriever.impl.ResourceRetrieverFactory;
import org.netbeans.modules.xml.retriever.impl.RetrieverEngineImpl;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetrieverTask {
    private File saveFile;
    private String baseAddress;
    private String sourceToBeGot;
    private RetrieveEntry rent;
    private RetrieverEngineImpl retEngine = null;

    public RetrieverTask(RetrieveEntry retrieveEntry, RetrieverEngine retrieverEngine) {
        this.retEngine = (RetrieverEngineImpl)retrieverEngine;
        this.sourceToBeGot = retrieveEntry.getCurrentAddress();
        this.baseAddress = retrieveEntry.getBaseAddress();
        this.saveFile = retrieveEntry.getSaveFile();
        this.rent = retrieveEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, File> goGetIt() throws IOException, URISyntaxException {
        Class<RetrieverTask> clazz = RetrieverTask.class;
        synchronized (RetrieverTask.class) {
            Object object;
            Object object2;
            Object object3;
            String string;
            File file;
            if (this.saveFile != null && this.saveFile.isFile() && this.saveFile.length() != 0L) {
                throw new IOException("File already exists");
            }
            ResourceRetriever resourceRetriever = ResourceRetrieverFactory.getResourceRetriever(this.baseAddress, this.sourceToBeGot);
            if (resourceRetriever == null) {
                throw new RuntimeException("No Retriever for this Resource address :" + this.sourceToBeGot);
            }
            if (this.isAlreadyDownloadedInThisSession(resourceRetriever.getEffectiveAddress(this.baseAddress, this.sourceToBeGot))) {
                String string2 = NbBundle.getMessage(RetrieverTask.class, (String)"EXCEPTION_CYCLIC_REFERENCE_INDICATOR");
                throw new IOException(string2);
            }
            HashMap<String, InputStream> hashMap = resourceRetriever.retrieveDocument(this.baseAddress, this.sourceToBeGot);
            if (hashMap == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            String string3 = hashMap.keySet().iterator().next();
            InputStream inputStream = hashMap.get(string3);
            this.rent.setEffectiveAddress(string3);
            if (this.saveFile == null) {
                this.saveFile = this.guessSaveFile(this.rent);
            }
            if (this.saveFile == null) {
                throw new IOException("Could not determine the save file.");
            }
            this.checkForCycle(this.saveFile, resourceRetriever.getStreamLength(), inputStream);
            if (this.retEngine.isSave2SingleFolder() && !this.retEngine.getFileOverwrite()) {
                int n = 0;
                file = this.saveFile;
                string = this.saveFile.getName();
                while (file.isFile()) {
                    file = new File(this.retEngine.getCurrentSaveRootFile() + File.separator + "new" + n++ + string);
                }
                this.saveFile = file;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 1024);
            file = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.saveFile));
            this.saveFile.getParentFile().mkdirs();
            string = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.saveFile.getParentFile()));
            file = FileUtil.createData((FileObject)string, (String)this.saveFile.getName());
            FileLock fileLock = file.lock();
            try {
                object3 = file.getOutputStream(fileLock);
                object2 = new BufferedOutputStream((OutputStream)object3, 1024);
                object = new byte[1024];
                int n = 0;
                while ((n = bufferedInputStream.read((byte[])object)) != -1) {
                    ((BufferedOutputStream)object2).write((byte[])object, 0, n);
                }
                ((FilterOutputStream)object2).close();
                bufferedInputStream.close();
            }
            finally {
                fileLock.releaseLock();
            }
            object3 = new HashMap();
            object2 = null;
            try {
                object2 = new DocumentTypeSchemaWsdlParser().getFileExtensionByParsing(this.saveFile);
                if (object2 != null && !file.getNameExt().endsWith("." + (String)object2)) {
                    File file2;
                    object = file.getNameExt();
                    if (file.getNameExt().endsWith("_" + (String)object2)) {
                        object = ((String)object).substring(0, ((String)object).length() - ("_" + (String)object2).length());
                    }
                    if ((file2 = new File(this.saveFile.getParent() + File.separator + (String)object + "." + (String)object2)).isFile() && this.retEngine.getFileOverwrite()) {
                        file2.delete();
                    }
                    FileObject fileObject = FileUtil.copyFile((FileObject)file, (FileObject)file.getParent(), (String)object, (String)object2);
                    file.delete();
                    file = fileObject;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((HashMap)object3).put(string3, FileUtil.toFile((FileObject)file));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return object3;
        }
    }

    private File guessSaveFile(RetrieveEntry retrieveEntry) throws URISyntaxException, IOException {
        if (retrieveEntry.getSaveFile() != null) {
            return retrieveEntry.getSaveFile();
        }
        URI uRI = new URI(retrieveEntry.getEffectiveAddress());
        String string = retrieveEntry.getEffectiveAddress();
        String string2 = null;
        int n = string.lastIndexOf(47);
        string2 = n != -1 ? string.substring(n + 1) : string;
        if (this.retEngine.isSave2SingleFolder()) {
            string2 = this.convertAllSpecialChars(string2);
            return new File(this.retEngine.getCurrentSaveRootFile() + File.separator + string2);
        }
        File file = null;
        if (uRI.isAbsolute()) {
            URI uRI2;
            file = "http".equalsIgnoreCase(uRI.getScheme()) || "https".equalsIgnoreCase(uRI.getScheme()) ? this.getSaveFileForURL(uRI) : ((uRI2 = new URI(retrieveEntry.getCurrentAddress())).isAbsolute() ? new File(new URI(this.retEngine.getFixedSaveRootFolder().toURI().toString() + "/" + string2)) : (retrieveEntry.getLocalBaseFile() == null ? new File(new URI(this.retEngine.getFixedSaveRootFolder().toURI().toString() + "/" + uRI2.toString())) : new File(new URI(retrieveEntry.getLocalBaseFile().getParentFile().toURI().toString() + "/" + uRI2.toString()))));
        } else {
            File file2 = new File(new URI(retrieveEntry.getLocalBaseFile().getParentFile().toURI().normalize().toString() + "/" + retrieveEntry.getCurrentAddress())).getCanonicalFile();
            File file3 = this.getModifiedParentFile(retrieveEntry.getLocalBaseFile(), file2);
            file = retrieveEntry.getLocalBaseFile() != file3 ? new File(new URI(file3.getParentFile().toURI().toString() + "/" + retrieveEntry.getCurrentAddress())) : file2;
        }
        return file;
    }

    private File getModifiedParentFile(File file, File file2) {
        String string;
        File file3 = file;
        String string2 = file2.toURI().toString();
        if (string2.startsWith(string = this.retEngine.getFixedSaveRootFolder().toURI().toString())) {
            return file3;
        }
        int n = Utilities.countPushdownFolders(file2.toURI(), this.retEngine.getFixedSaveRootFolder().toURI());
        this.retEngine.pushDownRoot(n);
        file3 = this.retEngine.getNewFileForOld(file, n);
        return file3;
    }

    private File getSaveFileForURL(URI uRI) {
        String string;
        String string2 = this.retEngine.getFixedSaveRootFolder().toURI().toString();
        String string3 = uRI.getSchemeSpecificPart().replace(':', '_');
        if ((string3 = string3.replace('?', '.')).contains(".") && !(string = string3.substring(string3.lastIndexOf(46), string3.length())).equals(string.toLowerCase())) {
            string3 = string3.substring(0, string3.lastIndexOf(46)) + string.toLowerCase();
        }
        string3 = this.convertAllSpecialChars(string3);
        string3 = string2 + "/" + string3;
        try {
            return new File(new URI(string3).normalize());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String convertAllSpecialChars(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '/' || c == '.' || c == '_' || c == ' ' || c == '-') continue;
            stringBuffer.setCharAt(i, '_');
        }
        return stringBuffer.toString();
    }

    private void checkForCycle(File file, long l, InputStream inputStream) throws IOException {
        String string = NbBundle.getMessage(RetrieverTask.class, (String)"EXCEPTION_CYCLIC_REFERENCE_INDICATOR");
        if (file.isFile()) {
            if (this.isAlreadyDownloadedInThisSession(file) || file.length() == l && !this.retEngine.getFileOverwrite()) {
                inputStream.close();
                throw new IOException(string + " : " + file);
            }
            if (this.retEngine.getFileOverwrite()) {
                return;
            }
            inputStream.close();
            throw new IOException(string + " : " + file);
        }
        if (file.isDirectory()) {
            inputStream.close();
            String string2 = NbBundle.getMessage(RetrieverTask.class, (String)"EXCEPTION_DIRECTORY_ALREADY_EXISTS");
            throw new IOException(string2 + " : " + file.getCanonicalPath());
        }
    }

    private boolean isAlreadyDownloadedInThisSession(File file) {
        for (RetrieveEntry retrieveEntry : this.retEngine.getRetrievedList()) {
            if (!retrieveEntry.getSaveFile().equals(file)) continue;
            return true;
        }
        return false;
    }

    private boolean isAlreadyDownloadedInThisSession(String string) {
        for (RetrieveEntry retrieveEntry : this.retEngine.getRetrievedList()) {
            if (!retrieveEntry.getEffectiveAddress().equals(string)) continue;
            return true;
        }
        return false;
    }
}

