/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.debugger.jpda.projects.MainProjectManager;
import org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.project.ActionProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixActionProvider
extends ActionsProviderSupport {
    private JPDADebugger debugger;
    private SourcePathProviderImpl sp;
    private Listener listener;
    private boolean isFixCommandSupported;
    private static final RequestProcessor hotFixRP = new RequestProcessor("Java Debugger HotFix", 1);

    public FixActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.sp = (SourcePathProviderImpl)((Object)contextProvider.lookupFirst(null, SourcePathProvider.class));
        this.listener = new Listener();
        MainProjectManager.getDefault().addPropertyChangeListener(this.listener);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this.listener);
        ClassesToReload.getInstance().addPropertyChangeListener(this.listener);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-java", (PropertyChangeListener)this.listener);
        this.setEnabled(ActionsManager.ACTION_FIX, this.shouldBeEnabled());
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this.listener);
        ClassesToReload.getInstance().removePropertyChangeListener(this.listener);
        MainProjectManager.getDefault().removePropertyChangeListener(this.listener);
        EditorContextDispatcher.getDefault().removePropertyChangeListener((PropertyChangeListener)this.listener);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_FIX);
    }

    public void doAction(Object object) {
        if (!this.isFixCommandSupported) {
            Map<String, FileObject> map = ClassesToReload.getInstance().popClassesToReload(this.debugger, this.sp.getSourceRootsFO());
            FixActionProvider.reloadClasses(this.debugger, map);
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        FixActionProvider.this.invokeAction();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify((Throwable)invocationTargetException);
            }
        } else {
            this.invokeAction();
        }
    }

    private void invokeAction() {
        ((ActionProvider)this.getCurrentProject().getLookup().lookup(ActionProvider.class)).invokeAction("debug.fix", this.getLookup());
    }

    private Project getCurrentProject() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return MainProjectManager.getDefault().getMainProject();
        }
        DataObject dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class);
        if (dataObject == null || !dataObject.isValid()) {
            return MainProjectManager.getDefault().getMainProject();
        }
        return FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
    }

    private boolean shouldBeEnabled() {
        ActionProvider actionProvider;
        if (!this.debugger.canFixClasses()) {
            return false;
        }
        this.isFixCommandSupported = false;
        Project project = this.getCurrentProject();
        if (project != null && (actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class)) != null) {
            int n;
            String[] stringArray = actionProvider.getSupportedActions();
            int n2 = stringArray.length;
            for (n = 0; n < n2 && !"debug.fix".equals(stringArray[n]); ++n) {
            }
            boolean bl = this.isFixCommandSupported = n < n2 && actionProvider.isActionEnabled("debug.fix", this.getLookup());
        }
        if (!this.isFixCommandSupported) {
            return ClassesToReload.getInstance().hasClassesToReload(this.debugger, this.sp.getSourceRootsFO());
        }
        return true;
    }

    private Lookup getLookup() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        int n = nodeArray.length;
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        for (int i = 0; i < n; ++i) {
            DataObject dataObject = (DataObject)nodeArray[i].getCookie(DataObject.class);
            if (dataObject == null || !dataObject.isValid()) continue;
            arrayList.add(dataObject);
        }
        return Lookups.fixed((Object[])arrayList.toArray(new DataObject[arrayList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reloadClasses(final JPDADebugger jPDADebugger, Map<String, FileObject> map) {
        final HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        for (String string : map.keySet()) {
            FileObject fileObject = map.get(string);
            InputStream inputStream = null;
            try {
                inputStream = fileObject.getInputStream();
                long l = fileObject.getSize();
                byte[] byArray = new byte[(int)l];
                inputStream.read(byArray);
                hashMap.put(string, byArray);
                System.out.println(" " + string);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        if (hashMap.size() == 0) {
            return;
        }
        hotFixRP.post(new Runnable(){

            public void run() {
                String string = null;
                try {
                    jPDADebugger.fixClasses(hashMap);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    string = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixUnsupported", (Object)unsupportedOperationException.getLocalizedMessage());
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    string = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixMismatch", (Object)noClassDefFoundError.getLocalizedMessage());
                }
                catch (VerifyError verifyError) {
                    string = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixVerifierProblems", (Object)verifyError.getLocalizedMessage());
                }
                catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                    string = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixUnsupportedVersion", (Object)unsupportedClassVersionError.getLocalizedMessage());
                }
                catch (ClassFormatError classFormatError) {
                    string = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixNotValid", (Object)classFormatError.getLocalizedMessage());
                }
                catch (ClassCircularityError classCircularityError) {
                    string = NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixCircularity", (Object)classCircularityError.getLocalizedMessage());
                }
                catch (RuntimeException runtimeException) {
                    if ("com.sun.jdi.VMDisconnectedException".equals(runtimeException.getClass().getName())) {
                        return;
                    }
                    throw runtimeException;
                }
                if (string != null) {
                    FixActionProvider.notifyError(string);
                } else {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(SourcePathProviderImpl.class, (String)"MSG_FixSuccess"));
                }
            }
        });
    }

    static void notifyError(String string) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
        StatusDisplayer.getDefault().setStatusText(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassesToReload {
        private static ClassesToReload instance;
        private Map<JPDADebugger, Map<FileObject, Map<String, FileObject>>> classesByDebugger = new WeakHashMap<JPDADebugger, Map<FileObject, Map<String, FileObject>>>();
        private PropertyChangeSupport pch = new PropertyChangeSupport(this);

        private ClassesToReload() {
        }

        public static synchronized ClassesToReload getInstance() {
            if (instance == null) {
                instance = new ClassesToReload();
            }
            return instance;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pch.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pch.removePropertyChangeListener(propertyChangeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addClassToReload(JPDADebugger jPDADebugger, FileObject fileObject, String string, FileObject fileObject2) {
            ClassesToReload classesToReload = this;
            synchronized (classesToReload) {
                Map<String, FileObject> map;
                Map<FileObject, Map<String, FileObject>> map2 = this.classesByDebugger.get(jPDADebugger);
                if (map2 == null) {
                    map2 = new HashMap<FileObject, Map<String, FileObject>>();
                    this.classesByDebugger.put(jPDADebugger, map2);
                }
                if ((map = map2.get(fileObject)) == null) {
                    map = new HashMap<String, FileObject>();
                    map2.put(fileObject, map);
                }
                map.put(string, fileObject2);
            }
            this.pch.firePropertyChange("classesToReload", null, string);
        }

        public synchronized boolean hasClassesToReload(JPDADebugger jPDADebugger, Set<FileObject> set) {
            Map<FileObject, Map<String, FileObject>> map = this.classesByDebugger.get(jPDADebugger);
            if (map != null) {
                for (FileObject fileObject : map.keySet()) {
                    if (!set.contains(fileObject)) continue;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, FileObject> popClassesToReload(JPDADebugger jPDADebugger, Set<FileObject> set) {
            HashMap<String, FileObject> hashMap = new HashMap<String, FileObject>();
            ClassesToReload classesToReload = this;
            synchronized (classesToReload) {
                Map<FileObject, Map<String, FileObject>> map = this.classesByDebugger.get(jPDADebugger);
                if (map != null) {
                    HashSet<FileObject> hashSet = new HashSet<FileObject>(map.keySet());
                    for (FileObject fileObject : hashSet) {
                        if (!set.contains(fileObject)) continue;
                        hashMap.putAll(map.remove(fileObject));
                    }
                }
            }
            if (hashMap.size() > 0) {
                this.pch.firePropertyChange("classesToReload", null, null);
            }
            return hashMap;
        }
    }

    private class Listener
    implements PropertyChangeListener,
    DebuggerManagerListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = FixActionProvider.this.shouldBeEnabled();
            FixActionProvider.this.setEnabled(ActionsManager.ACTION_FIX, bl);
            if (FixActionProvider.this.debugger.getState() == 4) {
                FixActionProvider.this.destroy();
            }
        }

        public void sessionRemoved(Session session) {
        }

        public void breakpointAdded(Breakpoint breakpoint) {
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
        }

        public Breakpoint[] initBreakpoints() {
            return new Breakpoint[0];
        }

        public void initWatches() {
        }

        public void sessionAdded(Session session) {
        }

        public void watchAdded(Watch watch) {
        }

        public void watchRemoved(Watch watch) {
        }

        public void engineAdded(DebuggerEngine debuggerEngine) {
        }

        public void engineRemoved(DebuggerEngine debuggerEngine) {
        }
    }
}

