/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.properties;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.PresenterEvent;
import org.netbeans.modules.vmd.api.properties.DesignEventFilterResolver;
import org.netbeans.modules.vmd.api.properties.DesignPropertyDescriptor;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.api.properties.PropertiesPresenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertiesPresenter
extends PropertiesPresenter {
    private static final String NULL_DEFAULT = "Null DefaultPropertyEditorSupport";
    private List<DesignPropertyDescriptor> descriptors = new ArrayList<DesignPropertyDescriptor>();
    private List<String> categories = new ArrayList<String>();
    private String category;
    private DesignEventFilterResolver designEventFilterResolver;

    public DefaultPropertiesPresenter() {
    }

    public DefaultPropertiesPresenter(DesignEventFilterResolver designEventFilterResolver) {
        this();
        this.designEventFilterResolver = designEventFilterResolver;
    }

    public DefaultPropertiesPresenter addProperty(String string, String string2, DesignPropertyEditor designPropertyEditor, String ... stringArray) {
        if (stringArray.length < 1) {
            throw new IllegalArgumentException();
        }
        if (designPropertyEditor == null) {
            throw new IllegalArgumentException(NULL_DEFAULT);
        }
        this.descriptors.add(DesignPropertyDescriptor.create(string, string2, this.category, designPropertyEditor, designPropertyEditor.getClass(), stringArray));
        return this;
    }

    public DefaultPropertiesPresenter addProperty(String string, DesignPropertyEditor designPropertyEditor, String ... stringArray) {
        if (stringArray.length < 1) {
            throw new IllegalArgumentException();
        }
        if (designPropertyEditor == null) {
            throw new IllegalArgumentException(NULL_DEFAULT);
        }
        this.descriptors.add(DesignPropertyDescriptor.create(string, string, this.category, designPropertyEditor, designPropertyEditor.getClass(), stringArray));
        return this;
    }

    public DefaultPropertiesPresenter addPropertiesCategory(String string) {
        assert (string != null) : " Group category cant be null";
        this.category = string;
        if (!this.categories.contains(string)) {
            this.categories.add(string);
        }
        return this;
    }

    @Override
    public List<DesignPropertyDescriptor> getDesignPropertyDescriptors() {
        return this.descriptors;
    }

    @Override
    public List<String> getPropertiesCategories() {
        return this.categories;
    }

    protected void notifyAttached(DesignComponent designComponent) {
        for (DesignPropertyDescriptor designPropertyDescriptor : this.getDesignPropertyDescriptors()) {
            if (designPropertyDescriptor.getPropertyEditor() != null) {
                designPropertyDescriptor.getPropertyEditor().init(designComponent);
            }
            designPropertyDescriptor.init(designComponent);
        }
    }

    protected void notifyDetached(final DesignComponent designComponent) {
        for (final DesignPropertyDescriptor designPropertyDescriptor : this.descriptors) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    designPropertyDescriptor.getPropertyEditor().cleanUp(designComponent);
                }
            });
        }
        this.descriptors = null;
        this.categories = null;
        this.category = null;
        this.designEventFilterResolver = null;
    }

    protected DesignEventFilter getEventFilter() {
        if (this.designEventFilterResolver != null) {
            return this.designEventFilterResolver.getEventFilter(this.getComponent());
        }
        return null;
    }

    protected void designChanged(DesignEvent designEvent) {
        for (DesignPropertyDescriptor designPropertyDescriptor : this.getDesignPropertyDescriptors()) {
            DesignPropertyEditor designPropertyEditor = designPropertyDescriptor.getPropertyEditor();
            if (designPropertyDescriptor.getPropertyEditor() == null) continue;
            designPropertyEditor.notifyDesignChanged(designEvent);
        }
    }

    protected void presenterChanged(PresenterEvent presenterEvent) {
    }
}

