/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DesignDocumentAwareness;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.DesignListener;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.api.properties.DesignPropertyDescriptor;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.api.properties.GroupPropertyEditor;
import org.netbeans.modules.vmd.api.properties.PropertiesPresenter;
import org.netbeans.modules.vmd.properties.AdvancedPropertySupport;
import org.netbeans.modules.vmd.properties.DefaultPropertySupport;
import org.netbeans.modules.vmd.properties.PrimitivePropertySupport;
import org.netbeans.modules.vmd.properties.PropertiesNode;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.WeakSet;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesNodesManager
implements DesignDocumentAwareness,
DesignListener,
ActiveDocumentSupport.Listener,
ActiveViewSupport.Listener {
    private static final WeakHashMap<DataEditorView, PropertiesNodesManager> INSTANCES = new WeakHashMap();
    private static Comparator<DesignPropertyDescriptor> compareByDisplayName = new Comparator<DesignPropertyDescriptor>(){

        @Override
        public int compare(DesignPropertyDescriptor designPropertyDescriptor, DesignPropertyDescriptor designPropertyDescriptor2) {
            return designPropertyDescriptor.getPropertyDisplayName().compareTo(designPropertyDescriptor2.getPropertyDisplayName());
        }
    };
    private WeakHashMap<DataEditorView, InstanceContent> icMap;
    private Collection<InstanceContent> ics;
    private WeakHashMap<InstanceContent, WeakSet<Node>> nodesToRemoveMap;
    private DataEditorView view;
    private DesignDocument document;
    private WeakHashMap<DesignComponent, WeakSet<DefaultPropertySupport>> propertySupportMap;
    private WeakHashMap<DesignComponent, Sheet> sheetMap;
    private WeakHashMap<DesignComponent, PropertiesNode> nodesMap;

    public static synchronized PropertiesNodesManager getInstance(DataEditorView dataEditorView) {
        if (INSTANCES.get(dataEditorView) == null) {
            PropertiesNodesManager propertiesNodesManager = new PropertiesNodesManager(dataEditorView);
            INSTANCES.put(dataEditorView, propertiesNodesManager);
        }
        return INSTANCES.get(dataEditorView);
    }

    private PropertiesNodesManager(DataEditorView dataEditorView) {
        dataEditorView.getContext().addDesignDocumentAwareness((DesignDocumentAwareness)this);
        this.nodesToRemoveMap = new WeakHashMap();
        this.view = dataEditorView;
        this.icMap = new WeakHashMap();
        this.ics = new HashSet<InstanceContent>();
        this.propertySupportMap = new WeakHashMap();
        this.sheetMap = new WeakHashMap();
        this.nodesMap = new WeakHashMap();
    }

    public void setDesignDocument(DesignDocument designDocument) {
        if (designDocument != null) {
            this.document = designDocument;
            designDocument.getListenerManager().addDesignListener((DesignListener)this, new DesignEventFilter(new DesignEventFilter[0]).setGlobal(true));
            ActiveDocumentSupport.getDefault().addActiveDocumentListener((ActiveDocumentSupport.Listener)this);
            ActiveViewSupport.getDefault().addActiveViewListener((ActiveViewSupport.Listener)this);
        } else if (this.document != null) {
            ActiveDocumentSupport.getDefault().removeActiveDocumentListener((ActiveDocumentSupport.Listener)this);
            ActiveViewSupport.getDefault().removeActiveViewListener((ActiveViewSupport.Listener)this);
            this.document.getListenerManager().removeDesignListener((DesignListener)this);
            this.document.getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    DesignComponent designComponent = PropertiesNodesManager.this.document.getRootComponent();
                    for (DesignComponent designComponent2 : designComponent.getComponents()) {
                        PropertiesNodesManager.this.cleanUpAll(designComponent2);
                    }
                }
            });
            this.document = null;
            this.view = null;
            this.propertySupportMap = null;
            this.sheetMap = null;
            this.nodesMap = null;
        }
    }

    private void cleanUpAll(DesignComponent designComponent) {
        for (final DesignComponent designComponent2 : designComponent.getComponents()) {
            Collection collection = designComponent2.getPresenters(PropertiesPresenter.class);
            for (PropertiesPresenter propertiesPresenter : collection) {
                for (final DesignPropertyDescriptor designPropertyDescriptor : propertiesPresenter.getDesignPropertyDescriptors()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            designPropertyDescriptor.getPropertyEditor().cleanUp(designComponent2);
                        }
                    });
                }
            }
            this.cleanUpAll(designComponent2);
        }
    }

    public void designChanged(DesignEvent designEvent) {
        WeakSet weakSet = new WeakSet(this.document.getSelectedComponents());
        if (designEvent.isSelectionChanged()) {
            this.repaintPropertiesWindow((Collection<DesignComponent>)weakSet);
        }
        if (designEvent.isStructureChanged()) {
            SwingUtilities.invokeLater(new Runnable((Collection)weakSet){
                final /* synthetic */ Collection val$selectedComponents;
                {
                    this.val$selectedComponents = collection;
                }

                public void run() {
                    PropertiesNodesManager.this.updatePropertyEditorsValues(this.val$selectedComponents);
                    PropertiesNodesManager.this.updateSheet(this.val$selectedComponents);
                }
            });
        }
    }

    public void activeDocumentChanged(DesignDocument designDocument, DesignDocument designDocument2) {
        if (this.document == null) {
            return;
        }
        if (designDocument2 == null) {
            this.document.getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    PropertiesNodesManager.this.repaintPropertiesWindow(Collections.EMPTY_LIST);
                }
            });
        }
        if (this.document != designDocument2) {
            return;
        }
        this.document.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                PropertiesNodesManager.this.repaintPropertiesWindow(PropertiesNodesManager.this.document.getSelectedComponents());
            }
        });
    }

    public void activeComponentsChanged(Collection<DesignComponent> collection) {
    }

    public void activeViewChanged(DataEditorView dataEditorView, DataEditorView dataEditorView2) {
        if (this.document == null) {
            return;
        }
        if (dataEditorView2 != null && this.view.getContext() == dataEditorView2.getContext() && dataEditorView2.getKind() == DataEditorView.Kind.MODEL) {
            this.document.getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    PropertiesNodesManager.this.repaintPropertiesWindow(PropertiesNodesManager.this.document.getSelectedComponents());
                }
            });
        } else if (dataEditorView != null && dataEditorView.getKind() == DataEditorView.Kind.MODEL) {
            this.document.getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    PropertiesNodesManager.this.repaintPropertiesWindow(Collections.EMPTY_SET);
                }
            });
        }
    }

    public void add(InstanceContent instanceContent) {
        assert (instanceContent != null);
        this.ics.add(instanceContent);
    }

    public void add(DataEditorView dataEditorView, InstanceContent instanceContent) {
        assert (instanceContent != null);
        this.icMap.put(dataEditorView, instanceContent);
    }

    private void changeLookup(Collection<DesignComponent> collection) {
        Object object;
        if (collection == null) {
            return;
        }
        HashSet<InstanceContent> hashSet = new HashSet<InstanceContent>();
        hashSet.addAll(this.ics);
        if (this.icMap.get(this.view) != null) {
            hashSet.add(this.icMap.get(this.view));
        }
        for (InstanceContent instanceContent : hashSet) {
            object = this.nodesToRemoveMap.get(instanceContent);
            if (object == null) {
                object = new WeakSet();
                this.nodesToRemoveMap.put(instanceContent, (WeakSet<Node>)object);
            }
            instanceContent.set((Collection)Collections.EMPTY_SET, (InstanceContent.Convertor)new PropertiesNodeConverter());
            object.clear();
        }
        if (collection.isEmpty()) {
            for (InstanceContent instanceContent : hashSet) {
                instanceContent.set(Collections.singleton(Node.EMPTY), (InstanceContent.Convertor)new PropertiesNodeConverter());
            }
        }
        for (InstanceContent instanceContent : hashSet) {
            object = (Set)this.nodesToRemoveMap.get(instanceContent);
            for (DesignComponent designComponent : collection) {
                PropertiesNode propertiesNode = this.nodesMap.get(designComponent);
                if (propertiesNode == null) {
                    propertiesNode = new PropertiesNode(this.view, designComponent);
                    this.nodesMap.put(designComponent, propertiesNode);
                }
                object.add(propertiesNode);
            }
            if (object == null || object.isEmpty()) continue;
            instanceContent.set((Collection)object, (InstanceContent.Convertor)new PropertiesNodeConverter());
        }
    }

    public synchronized Sheet getSheet(DesignComponent designComponent) {
        assert (designComponent != null);
        if (this.sheetMap == null) {
            return null;
        }
        if (this.sheetMap.get(designComponent) == null) {
            this.sheetMap.put(designComponent, this.createSheet(designComponent));
        }
        return this.sheetMap.get(designComponent);
    }

    public Sheet createSheet(final DesignComponent designComponent) {
        final Sheet sheet = new Sheet();
        designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                ArrayList<DesignPropertyDescriptor> arrayList = new ArrayList<DesignPropertyDescriptor>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (PropertiesPresenter object : designComponent.getPresenters(PropertiesPresenter.class)) {
                    arrayList.addAll(object.getDesignPropertyDescriptors());
                    arrayList2.addAll(object.getPropertiesCategories());
                }
                if (arrayList != null) {
                    Collections.sort(arrayList, compareByDisplayName);
                }
                PropertiesNodesManager.this.createCategoriesSet(sheet, arrayList2);
                for (DesignPropertyDescriptor designPropertyDescriptor : arrayList) {
                    DefaultPropertySupport defaultPropertySupport;
                    DesignPropertyEditor designPropertyEditor = designPropertyDescriptor.getPropertyEditor();
                    if (designPropertyEditor instanceof GroupPropertyEditor && designPropertyDescriptor.getPropertyNames().size() == 0) {
                        throw new IllegalStateException("To use AdvancedPropertyEditorSupport you need to specific at least one propertyName");
                    }
                    if (designPropertyEditor instanceof GroupPropertyEditor) {
                        defaultPropertySupport = new AdvancedPropertySupport(designPropertyDescriptor, designPropertyDescriptor.getPropertyEditorType());
                        PropertiesNodesManager.this.addPropertySupport(designComponent, defaultPropertySupport);
                    } else if (designPropertyDescriptor.getPropertyNames().size() <= 1) {
                        defaultPropertySupport = new PrimitivePropertySupport(designPropertyDescriptor, designPropertyDescriptor.getPropertyEditorType());
                        PropertiesNodesManager.this.addPropertySupport(designComponent, defaultPropertySupport);
                    } else {
                        throw new IllegalArgumentException();
                    }
                    if (designPropertyEditor != null && designPropertyEditor.canEditAsText() != null) {
                        defaultPropertySupport.setValue("canEditAsText", designPropertyEditor.canEditAsText());
                    }
                    defaultPropertySupport.setValue("changeImmediate", false);
                    sheet.get(designPropertyDescriptor.getPropertyCategory()).put((Node.Property)defaultPropertySupport);
                }
            }
        });
        return sheet;
    }

    public void updateSheet(Collection<DesignComponent> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        for (DesignComponent designComponent : collection) {
            Sheet sheet = this.sheetMap.get(designComponent);
            if (sheet == null) continue;
            for (Node.PropertySet propertySet : sheet.toArray()) {
                for (Node.Property property : propertySet.getProperties()) {
                    if (!(property instanceof DefaultPropertySupport)) continue;
                    ((DefaultPropertySupport)property).update();
                }
            }
        }
    }

    private void addPropertySupport(DesignComponent designComponent, DefaultPropertySupport defaultPropertySupport) {
        WeakSet weakSet = this.propertySupportMap.get(designComponent);
        if (weakSet == null) {
            weakSet = new WeakSet();
            this.propertySupportMap.put(designComponent, (WeakSet<DefaultPropertySupport>)weakSet);
        }
        weakSet.add((Object)defaultPropertySupport);
    }

    private void updatePropertyEditorsValues(Collection<DesignComponent> collection) {
        if (collection == null) {
            return;
        }
        HashSet<InstanceContent> hashSet = new HashSet<InstanceContent>();
        hashSet.addAll(this.ics);
        if (this.icMap.get(this.view) != null) {
            hashSet.add(this.icMap.get(this.view));
        }
        for (InstanceContent instanceContent : hashSet) {
            WeakSet<Node> weakSet = this.nodesToRemoveMap.get(instanceContent);
            if (weakSet == null) continue;
            for (Node node : weakSet) {
                PropertiesNode propertiesNode = (PropertiesNode)node;
                propertiesNode.updateNode(this.getSheet(propertiesNode.getComponent()));
            }
        }
    }

    private void repaintPropertiesWindow(final Collection<DesignComponent> collection) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (PropertiesNodesManager.this.view != null) {
                    PropertiesNodesManager.this.changeLookup(collection);
                    PropertiesNodesManager.this.updateSheet(collection);
                }
            }
        });
    }

    private synchronized void createCategoriesSet(Sheet sheet, List<String> list) {
        for (String string : list) {
            sheet.put(this.createPropertiesSet(string));
        }
    }

    private synchronized Sheet.Set createPropertiesSet(String string) {
        Sheet.Set set = new Sheet.Set();
        set.setName(string);
        set.setDisplayName(string);
        return set;
    }

    private class PropertiesNodeConverter
    implements InstanceContent.Convertor {
        private PropertiesNodeConverter() {
        }

        public Object convert(Object object) {
            return object;
        }

        public Class type(Object object) {
            return object.getClass();
        }

        public String id(Object object) {
            return object.toString();
        }

        public String displayName(Object object) {
            return object.toString();
        }
    }
}

