/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelAccess;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModel<T extends Component<T>>
implements Model<T>,
UndoableEditListener {
    private PropertyChangeSupport pcs;
    protected ModelUndoableEditSupport ues;
    private Model.State status;
    private boolean inSync;
    private boolean inUndoRedo;
    private EventListenerList componentListeners;
    private Semaphore transactionSemaphore;
    private Transaction transaction;
    private ModelSource source;
    private UndoableEditListener[] savedUndoableEditListeners;

    public AbstractModel(ModelSource modelSource) {
        this.source = modelSource;
        this.pcs = new PropertyChangeSupport(this);
        this.ues = new ModelUndoableEditSupport();
        this.componentListeners = new EventListenerList();
        this.transactionSemaphore = new Semaphore(1, true);
        this.status = Model.State.VALID;
    }

    public abstract ModelAccess getAccess();

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        assert (this.transaction != null);
        this.transaction.addPropertyChangeEvent(propertyChangeEvent);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.ues.removeUndoableEditListener(undoableEditListener);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.ues.addUndoableEditListener(undoableEditListener);
    }

    @Override
    public synchronized void addUndoableRefactorListener(UndoableEditListener undoableEditListener) {
        this.savedUndoableEditListeners = this.ues.getUndoableEditListeners();
        if (this.savedUndoableEditListeners != null) {
            for (UndoableEditListener undoableEditListener2 : this.savedUndoableEditListeners) {
                if (!(undoableEditListener2 instanceof UndoManager)) continue;
                ((UndoManager)undoableEditListener2).discardAllEdits();
            }
        }
        this.ues = new ModelUndoableEditSupport();
        this.ues.addUndoableEditListener(undoableEditListener);
    }

    @Override
    public synchronized void removeUndoableRefactorListener(UndoableEditListener undoableEditListener) {
        this.ues.removeUndoableEditListener(undoableEditListener);
        if (this.savedUndoableEditListeners != null) {
            this.ues = new ModelUndoableEditSupport();
            for (UndoableEditListener undoableEditListener2 : this.savedUndoableEditListeners) {
                this.ues.addUndoableEditListener(undoableEditListener2);
            }
            this.savedUndoableEditListeners = null;
        }
    }

    protected CompoundEdit createModelUndoableEdit() {
        return new ModelUndoableEdit();
    }

    @Override
    public boolean inSync() {
        return this.inSync;
    }

    protected void setInSync(boolean bl) {
        this.inSync = bl;
    }

    public boolean inUndoRedo() {
        return this.inUndoRedo;
    }

    protected void setInUndoRedo(boolean bl) {
        this.inUndoRedo = bl;
    }

    @Override
    public Model.State getState() {
        return this.status;
    }

    protected void setState(Model.State state) {
        if (state == this.status) {
            return;
        }
        Model.State state2 = this.status;
        this.status = state;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "state", (Object)state2, (Object)this.status);
        if (this.isIntransaction()) {
            this.firePropertyChangeEvent(propertyChangeEvent);
        } else {
            this.pcs.firePropertyChange(propertyChangeEvent);
        }
    }

    protected boolean needsSync() {
        return true;
    }

    protected void transactionStarted() {
    }

    protected void transactionCompleted() {
    }

    protected void syncStarted() {
    }

    protected void syncCompleted() {
    }

    private void prepareSync() {
        if (this.needsSync()) {
            this.getAccess().prepareSync();
        }
    }

    @Override
    public synchronized void sync() throws IOException {
        if (this.needsSync()) {
            this.syncStarted();
            boolean bl = false;
            boolean bl2 = false;
            try {
                this.startTransaction(true, false);
                bl = true;
                this.setState(this.getAccess().sync());
                this.endTransaction();
                bl2 = true;
            }
            catch (IOException iOException) {
                this.setState(Model.State.NOT_WELL_FORMED);
                this.endTransaction(false);
                throw iOException;
            }
            finally {
                if (bl && this.isIntransaction()) {
                    try {
                        this.endTransaction(true);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Sync cleanup error.", exception);
                    }
                }
                if (!bl2 && this.getState() != Model.State.NOT_WELL_FORMED) {
                    this.setState(Model.State.NOT_SYNCED);
                    this.refresh();
                }
                this.setInSync(false);
                this.syncCompleted();
            }
        }
    }

    protected void refresh() {
        this.setState(Model.State.VALID);
    }

    @Override
    public void removeComponentListener(ComponentListener componentListener) {
        this.componentListeners.remove(ComponentListener.class, componentListener);
    }

    @Override
    public void addComponentListener(ComponentListener componentListener) {
        this.componentListeners.add(ComponentListener.class, componentListener);
    }

    public void fireComponentChangedEvent(ComponentEvent componentEvent) {
        assert (this.transaction != null);
        this.transaction.addComponentEvent(componentEvent);
    }

    @Override
    public boolean isIntransaction() {
        return this.transaction != null;
    }

    @Override
    public synchronized void endTransaction() {
        this.endTransaction(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void endTransaction(boolean bl) {
        if (this.transaction == null) {
            return;
        }
        this.validateWrite();
        try {
            if (!bl) {
                this.transaction.fireEvents();
            }
            if (!this.inSync() && this.transaction.hasEvents() || this.transaction.hasEventsAfterFiring()) {
                this.getAccess().flush();
            }
            if (!this.inUndoRedo()) {
                this.ues.endUpdate();
            }
        }
        finally {
            this.transaction = null;
            this.setInSync(false);
            this.setInUndoRedo(false);
            this.transactionSemaphore.release();
            this.transactionCompleted();
        }
    }

    @Override
    public boolean startTransaction() {
        return this.startTransaction(false, false);
    }

    private synchronized boolean startTransaction(boolean bl, boolean bl2) {
        if (this.transaction != null && this.transaction.currentThreadIsTransactionThread()) {
            throw new IllegalStateException("Current thread has already started a transaction");
        }
        if (!bl && !this.getModelSource().isEditable()) {
            throw new IllegalArgumentException("Model source is read-only.");
        }
        this.transactionSemaphore.acquireUninterruptibly();
        assert (this.transaction == null);
        if (!bl && this.getState() == Model.State.NOT_WELL_FORMED) {
            this.transactionSemaphore.release();
            return false;
        }
        this.transaction = new Transaction();
        this.transactionStarted();
        this.setInSync(bl);
        this.setInUndoRedo(bl2);
        if (!bl2) {
            this.ues.beginUpdate();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollbackTransaction() {
        if (this.transaction == null) {
            return;
        }
        this.validateWrite();
        try {
            if (this.inSync() || this.inUndoRedo()) {
                throw new IllegalArgumentException("Should never call rollback during sync or undo/redo.");
            }
            this.ues.abortUpdate();
        }
        finally {
            this.transaction = null;
            this.setInSync(false);
            this.setInUndoRedo(false);
            this.transactionSemaphore.release();
            this.transactionCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void finishTransaction() {
        if (this.transaction == null) {
            return;
        }
        this.validateWrite();
        try {
            if (this.inSync() || this.inUndoRedo()) {
                throw new IllegalArgumentException("Should never call rollback during sync or undo/redo.");
            }
        }
        finally {
            this.transaction = null;
            this.setInSync(false);
            this.setInUndoRedo(false);
            this.transactionSemaphore.release();
            this.transactionCompleted();
        }
    }

    public synchronized void validateWrite() {
        if (this.transaction == null || !this.transaction.currentThreadIsTransactionThread()) {
            throw new IllegalStateException("attempted model write without invoking startTransaction");
        }
    }

    public boolean startedFiringEvents() {
        return this.transaction != null && this.transaction.eventsAddedAfterFiring != null;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.ues.postEdit(undoableEditEvent.getEdit());
    }

    @Override
    public ModelSource getModelSource() {
        return this.source;
    }

    EventListenerList getComponentListenerList() {
        return this.componentListeners;
    }

    public boolean isAutoSyncActive() {
        return this.getAccess().isAutoSync();
    }

    public void setAutoSyncActive(boolean bl) {
        this.getAccess().setAutoSync(bl);
    }

    void runAutoSync() {
        this.prepareSync();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    AbstractModel.this.sync();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    protected class ModelUndoableEdit
    extends CompoundEdit {
        static final long serialVersionUID = 1L;

        protected ModelUndoableEdit() {
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (!this.isInProgress()) {
                return false;
            }
            UndoableEdit undoableEdit2 = this.lastEdit();
            if (undoableEdit2 == null) {
                return super.addEdit(undoableEdit);
            }
            if (!undoableEdit2.addEdit(undoableEdit)) {
                return super.addEdit(undoableEdit);
            }
            return true;
        }

        public void redo() throws CannotRedoException {
            boolean bl = false;
            boolean bl2 = true;
            try {
                AbstractModel.this.startTransaction(true, true);
                bl = true;
                AbstractModel.this.getAccess().prepareForUndoRedo();
                super.redo();
                AbstractModel.this.getAccess().finishUndoRedo();
                AbstractModel.this.endTransaction();
                bl2 = false;
            }
            catch (CannotRedoException cannotRedoException) {
                bl2 = false;
                throw cannotRedoException;
            }
            finally {
                if (AbstractModel.this.isIntransaction() && bl) {
                    try {
                        AbstractModel.this.endTransaction(true);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Redo error", exception);
                    }
                }
                if (bl2) {
                    AbstractModel.this.setState(Model.State.NOT_SYNCED);
                    AbstractModel.this.refresh();
                }
            }
        }

        public void undo() throws CannotUndoException {
            boolean bl = false;
            boolean bl2 = true;
            try {
                AbstractModel.this.startTransaction(true, true);
                bl = true;
                AbstractModel.this.getAccess().prepareForUndoRedo();
                super.undo();
                AbstractModel.this.getAccess().finishUndoRedo();
                AbstractModel.this.endTransaction();
                bl2 = false;
            }
            catch (CannotUndoException cannotUndoException) {
                bl2 = false;
                throw cannotUndoException;
            }
            finally {
                if (bl && AbstractModel.this.isIntransaction()) {
                    try {
                        AbstractModel.this.endTransaction(true);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Undo error", exception);
                    }
                }
                if (bl2) {
                    AbstractModel.this.setState(Model.State.NOT_SYNCED);
                    AbstractModel.this.refresh();
                }
            }
        }

        public void justUndo() {
            super.end();
            boolean bl = AbstractModel.this.inUndoRedo;
            AbstractModel.this.inUndoRedo = true;
            AbstractModel.this.getAccess().prepareForUndoRedo();
            super.undo();
            AbstractModel.this.getAccess().finishUndoRedo();
            AbstractModel.this.inUndoRedo = bl;
        }
    }

    private class Transaction {
        private final List<PropertyChangeEvent> propertyChangeEvents = new ArrayList<PropertyChangeEvent>();
        private final List<ComponentEvent> componentListenerEvents = new ArrayList<ComponentEvent>();
        private final Thread transactionThread = Thread.currentThread();
        private boolean eventAdded = false;
        private Boolean eventsAddedAfterFiring = null;
        private boolean hasEvents = false;

        public void addPropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
            this.propertyChangeEvents.add(propertyChangeEvent);
            if (this.eventsAddedAfterFiring == null || !AbstractModel.this.inUndoRedo) {
                this.eventAdded = true;
            }
            if (this.eventsAddedAfterFiring != null) {
                this.eventsAddedAfterFiring = Boolean.TRUE;
            }
            this.hasEvents = true;
        }

        public void addComponentEvent(ComponentEvent componentEvent) {
            this.componentListenerEvents.add(componentEvent);
            if (this.eventsAddedAfterFiring == null || !AbstractModel.this.inUndoRedo) {
                this.eventAdded = true;
            }
            if (this.eventsAddedAfterFiring != null) {
                this.eventsAddedAfterFiring = Boolean.TRUE;
            }
            this.hasEvents = true;
        }

        public boolean currentThreadIsTransactionThread() {
            return Thread.currentThread().equals(this.transactionThread);
        }

        public void fireEvents() {
            if (this.eventsAddedAfterFiring == null) {
                this.eventsAddedAfterFiring = Boolean.FALSE;
            }
            while (this.eventAdded) {
                this.eventAdded = false;
                this.fireCompleteEventSet();
            }
        }

        private void fireCompleteEventSet() {
            ArrayList<PropertyChangeEvent> arrayList = new ArrayList<PropertyChangeEvent>(this.propertyChangeEvents);
            this.propertyChangeEvents.clear();
            for (PropertyChangeEvent serializable2 : arrayList) {
                AbstractModel.this.pcs.firePropertyChange(serializable2);
            }
            ArrayList<ComponentEvent> arrayList2 = new ArrayList<ComponentEvent>(this.componentListenerEvents);
            this.componentListenerEvents.clear();
            HashMap<Object, Set<ComponentEvent.EventType>> hashMap = new HashMap<Object, Set<ComponentEvent.EventType>>();
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                Set<ComponentEvent.EventType> set;
                ComponentEvent componentEvent = (ComponentEvent)iterator.next();
                Object object = componentEvent.getSource();
                if (hashMap.keySet().contains(object)) {
                    set = (Set)hashMap.get(object);
                    if (set.contains((Object)componentEvent.getEventType())) continue;
                    set.add(componentEvent.getEventType());
                } else {
                    set = new HashSet();
                    set.add(componentEvent.getEventType());
                    hashMap.put(componentEvent.getSource(), set);
                }
                for (Set set2 : set = (ComponentListener[])AbstractModel.this.componentListeners.getListeners(ComponentListener.class)) {
                    componentEvent.getEventType().fireEvent(componentEvent, (ComponentListener)((Object)set2));
                }
            }
        }

        public boolean hasEvents() {
            return this.hasEvents;
        }

        public boolean hasEventsAfterFiring() {
            return this.eventsAddedAfterFiring != null && this.eventsAddedAfterFiring != false;
        }
    }

    protected class ModelUndoableEditSupport
    extends UndoableEditSupport {
        protected ModelUndoableEditSupport() {
        }

        protected CompoundEdit createCompoundEdit() {
            return AbstractModel.this.createModelUndoableEdit();
        }

        protected void abortUpdate() {
            ModelUndoableEdit modelUndoableEdit = (ModelUndoableEdit)this.compoundEdit;
            modelUndoableEdit.justUndo();
            this.compoundEdit = this.createCompoundEdit();
            this.updateLevel = 0;
        }
    }
}

