/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyVetoException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorContent;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;

public class NavigatorPanelUI
extends JPanel
implements ExplorerManager.Provider {
    private NavigatorContent content = new NavigatorContent();
    private BeanTreeView navigatorPane;
    private ExplorerManager explorerManager = new ExplorerManager();
    private boolean isBusy = false;

    public NavigatorPanelUI() {
        this.initComponents();
        this.navigatorPane = new BeanTreeView();
        this.navigatorPane.setRootVisible(false);
        this.navigatorPane.setDropTarget(false);
        this.navigatorPane.setDragSource(false);
        this.add((Component)this.navigatorPane, "Center");
        this.explorerManager.setRootContext(this.content.getRoot());
        this.navigatorPane.expandAll();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    void setBusyState(boolean bl) {
        Cursor cursor = this.isBusy ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
        this.navigatorPane.setCursor(cursor);
    }

    void newContentReady() {
        this.explorerManager.setRootContext(this.content.getRoot());
        if (SwingUtilities.isEventDispatchThread()) {
            this.navigatorPane.expandAll();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NavigatorPanelUI.this.navigatorPane.expandAll();
                }
            });
        }
    }

    NavigatorContent getContent() {
        return this.content;
    }

    void selectNode(Node node) {
        try {
            this.explorerManager.setSelectedNodes(new Node[]{node});
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        this.navigatorPane.requestFocusInWindow();
        return bl;
    }
}

