/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.nodes;

import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.tomcat5.AuthorizationException;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.TomcatModule;
import org.netbeans.modules.tomcat5.nodes.TomcatWebModule;
import org.netbeans.modules.tomcat5.nodes.TomcatWebModuleNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatWebModuleChildrenFactory
extends ChildFactory<TomcatWebModule> {
    private static final TomcatWebModule MODULE_WAITING_MARK = new TomcatWebModule(null, null, false);
    private static final Logger LOGGER = Logger.getLogger(TomcatWebModuleChildrenFactory.class.getName());
    private final Lookup lookup;

    public TomcatWebModuleChildrenFactory(Lookup lookup) {
        this.lookup = lookup;
    }

    public void updateKeys() {
        this.refresh(false);
    }

    protected Node createNodeForKey(TomcatWebModule tomcatWebModule) {
        if (tomcatWebModule == MODULE_WAITING_MARK) {
            return this.createWaitNode();
        }
        TomcatWebModuleNode tomcatWebModuleNode = new TomcatWebModuleNode(tomcatWebModule);
        tomcatWebModule.setRepresentedNode((Node)tomcatWebModuleNode);
        return tomcatWebModuleNode;
    }

    protected boolean createKeys(List<TomcatWebModule> list) {
        DeploymentManager deploymentManager = (DeploymentManager)this.lookup.lookup(DeploymentManager.class);
        Target target = (Target)this.lookup.lookup(Target.class);
        TreeSet<TomcatWebModule> treeSet = new TreeSet<TomcatWebModule>(TomcatWebModule.TOMCAT_WEB_MODULE_COMPARATOR);
        if (deploymentManager instanceof TomcatManager && target != null) {
            TomcatManager tomcatManager = (TomcatManager)deploymentManager;
            if (tomcatManager.isSuspended() || !tomcatManager.isRunning(true)) {
                return true;
            }
            try {
                int n;
                TargetModuleID[] targetModuleIDArray = deploymentManager.getRunningModules(ModuleType.WAR, new Target[]{target});
                for (n = 0; n < targetModuleIDArray.length; ++n) {
                    treeSet.add(new TomcatWebModule(deploymentManager, (TomcatModule)targetModuleIDArray[n], true));
                }
                targetModuleIDArray = deploymentManager.getNonRunningModules(ModuleType.WAR, new Target[]{target});
                for (n = 0; n < targetModuleIDArray.length; ++n) {
                    treeSet.add(new TomcatWebModule(deploymentManager, (TomcatModule)targetModuleIDArray[n], false));
                }
            }
            catch (Exception exception) {
                if (exception.getCause() instanceof AuthorizationException) {
                    String string = NbBundle.getMessage(TomcatWebModuleChildrenFactory.class, (String)"MSG_AuthorizationFailed");
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
                LOGGER.log(Level.INFO, null, exception);
            }
        }
        list.addAll(treeSet);
        return true;
    }
}

