/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui;

import java.awt.Component;
import java.awt.Label;
import java.beans.DesignMode;
import java.beans.beancontext.BeanContextChildComponentProxy;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Properties;
import org.openide.awt.ToolbarPool;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggerManagerListener
extends DebuggerManagerAdapter {
    private static final String PROPERTY_CLOSED_TC = "closedTopComponents";
    private List<DebuggerEngine> openedGroups = new LinkedList<DebuggerEngine>();
    private Map<DebuggerEngine, List<? extends Component>> openedComponents = new HashMap<DebuggerEngine, List<? extends Component>>();
    private Set<Reference<Component>> componentsInitiallyOpened = new HashSet<Reference<Component>>();
    private static final List<Component> OPENED_COMPONENTS = new LinkedList<Component>();

    public synchronized void engineAdded(DebuggerEngine debuggerEngine) {
        if (this.openedComponents.containsKey(debuggerEngine) || this.openedGroups.contains(debuggerEngine)) {
            return;
        }
        final List list = debuggerEngine.lookup(null, BeanContextChildComponentProxy.class);
        if (list != null && !list.isEmpty()) {
            final ArrayList<Label> arrayList = new ArrayList<Label>(list.size());
            arrayList.add(new Label("EMPTY"));
            if (this.openedComponents.isEmpty() && this.openedGroups.isEmpty()) {
                this.fillOpenedDebuggerComponents(this.componentsInitiallyOpened);
            }
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ArrayList<Component> arrayList2 = new ArrayList<Component>(list.size());
                    try {
                        for (BeanContextChildComponentProxy beanContextChildComponentProxy : list) {
                            boolean bl;
                            Component component;
                            block20: {
                                try {
                                    component = beanContextChildComponentProxy.getComponent();
                                    if (component == null) {
                                    }
                                    break block20;
                                }
                                catch (Exception exception) {
                                    Exceptions.printStackTrace((Throwable)exception);
                                }
                                continue;
                            }
                            arrayList2.add(component);
                            boolean bl2 = bl = beanContextChildComponentProxy instanceof DesignMode ? ((DesignMode)((Object)beanContextChildComponentProxy)).isDesignTime() : true;
                            if (component instanceof TopComponent) {
                                boolean bl3;
                                TopComponent topComponent = (TopComponent)component;
                                boolean bl4 = Properties.getDefault().getProperties(DebuggerManagerListener.class.getName()).getProperties(DebuggerManagerListener.PROPERTY_CLOSED_TC).getBoolean(topComponent.getName(), false);
                                boolean bl5 = bl3 = !Properties.getDefault().getProperties(DebuggerManagerListener.class.getName()).getProperties(DebuggerManagerListener.PROPERTY_CLOSED_TC).getBoolean(topComponent.getName(), true);
                                if ((!bl || bl4) && (bl || !bl3)) continue;
                                topComponent.open();
                                continue;
                            }
                            if (!bl) continue;
                            component.setVisible(true);
                        }
                        DebuggerManagerListener.setupToolbar();
                    }
                    finally {
                        Object object = DebuggerManagerListener.this;
                        synchronized (object) {
                            arrayList.clear();
                            arrayList.addAll(arrayList2);
                            ((Object)((Object)DebuggerManagerListener.this)).notifyAll();
                        }
                        object = OPENED_COMPONENTS;
                        synchronized (object) {
                            OPENED_COMPONENTS.addAll(arrayList2);
                        }
                    }
                }
            });
            this.openedComponents.put(debuggerEngine, arrayList);
        } else {
            if (this.openedGroups.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup("debugger");
                        if (topComponentGroup != null) {
                            topComponentGroup.open();
                        }
                        DebuggerManagerListener.setupToolbar();
                    }
                });
            }
            this.openedGroups.add(debuggerEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillOpenedDebuggerComponents(Set<Reference<Component>> set) {
        TopComponent.Registry registry;
        TopComponent.Registry registry2 = registry = TopComponent.getRegistry();
        synchronized (registry2) {
            for (TopComponent topComponent : registry.getOpened()) {
                set.add(new WeakReference<TopComponent>(topComponent));
            }
        }
    }

    private static final void setupToolbar() {
        if (ToolbarPool.getDefault().getConfiguration().equals("Standard")) {
            ToolbarPool.getDefault().setConfiguration("Debugging");
        }
    }

    private static final void closeToolbar() {
        if (ToolbarPool.getDefault().getConfiguration().equals("Debugging")) {
            ToolbarPool.getDefault().setConfiguration("Standard");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void engineRemoved(DebuggerEngine debuggerEngine) {
        List<? extends Component> list = this.openedComponents.remove(debuggerEngine);
        if (list != null) {
            if (list.size() == 1 && list.get(0) instanceof Label) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ArrayList<? extends Component> arrayList = new ArrayList<Component>();
            for (List<? extends Component> list22 : this.openedComponents.values()) {
                arrayList.addAll(list22);
            }
            final ArrayList<? extends Component> arrayList2 = new ArrayList<Component>(list);
            arrayList2.removeAll(arrayList);
            for (Reference<Component> reference : this.componentsInitiallyOpened) {
                arrayList2.remove(reference.get());
            }
            if (!arrayList2.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        for (Component component : arrayList2) {
                            if (component instanceof TopComponent) {
                                TopComponent topComponent = (TopComponent)component;
                                boolean bl = topComponent.isOpened();
                                Properties.getDefault().getProperties(DebuggerManagerListener.class.getName()).getProperties(DebuggerManagerListener.PROPERTY_CLOSED_TC).setBoolean(topComponent.getName(), !bl);
                                if (!bl) continue;
                                topComponent.close();
                                continue;
                            }
                            component.setVisible(false);
                        }
                    }
                });
            }
            List<Component> list2 = OPENED_COMPONENTS;
            synchronized (list2) {
                OPENED_COMPONENTS.removeAll(arrayList2);
            }
        }
        this.openedGroups.remove(debuggerEngine);
        if (this.openedGroups.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup("debugger");
                    if (topComponentGroup != null) {
                        topComponentGroup.close();
                    }
                }
            });
        }
        if (this.openedComponents.isEmpty() && this.openedGroups.isEmpty()) {
            this.componentsInitiallyOpened.clear();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DebuggerManagerListener.closeToolbar();
                }
            });
        }
    }

    static void closeDebuggerUI() {
        if (SwingUtilities.isEventDispatchThread()) {
            DebuggerManagerListener.doCloseDebuggerUI();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DebuggerManagerListener.doCloseDebuggerUI();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCloseDebuggerUI() {
        TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup("debugger");
        if (topComponentGroup != null) {
            topComponentGroup.close();
        }
        List<Component> list = OPENED_COMPONENTS;
        synchronized (list) {
            for (Component component : OPENED_COMPONENTS) {
                if (component instanceof TopComponent) {
                    ((TopComponent)component).close();
                    continue;
                }
                component.setVisible(false);
            }
            OPENED_COMPONENTS.clear();
        }
        if (ToolbarPool.getDefault().getConfiguration().equals("Debugging")) {
            ToolbarPool.getDefault().setConfiguration("Standard");
        }
    }
}

