/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class BreakpointsTableModel
implements TableModel,
Constants {
    private Map breakpointsBeingEnabled = new HashMap();
    private RequestProcessor rp;
    private Collection modelListeners = new ArrayList();

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (string.equals("BreakpointEnabled")) {
            if (object instanceof Breakpoint) {
                return ((Breakpoint)object).isEnabled();
            }
            if (object instanceof String) {
                String string2 = (String)object;
                Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
                Boolean bl = null;
                for (int i = 0; i < breakpointArray.length; ++i) {
                    if (!breakpointArray[i].getGroupName().equals(string2)) continue;
                    if (bl == null) {
                        bl = breakpointArray[i].isEnabled();
                        continue;
                    }
                    if (bl.booleanValue() == breakpointArray[i].isEnabled()) continue;
                    return null;
                }
                return bl;
            }
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        if (object instanceof Breakpoint) {
            if (string.equals("BreakpointEnabled")) {
                Map map = this.breakpointsBeingEnabled;
                synchronized (map) {
                    return this.breakpointsBeingEnabled.containsKey(object);
                    {
                    }
                }
            }
        } else if (object instanceof String) {
            return false;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        if (string.equals("BreakpointEnabled")) {
            if (object instanceof Breakpoint) {
                Map map = this.breakpointsBeingEnabled;
                synchronized (map) {
                    this.breakpointsBeingEnabled.put(object, ((Breakpoint)object).isEnabled());
                    if (this.rp == null) {
                        this.rp = new RequestProcessor("Enable Breakpoints RP", 1);
                    }
                }
                this.rp.post((Runnable)new BreakpointEnabler((Breakpoint)object, (Boolean)object2));
                return;
            }
            if (object instanceof String) {
                String string2 = (String)object;
                Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
                ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
                for (int i = 0; i < breakpointArray.length; ++i) {
                    if (!breakpointArray[i].getGroupName().equals(string2)) continue;
                    arrayList.add(breakpointArray[i]);
                }
                if (arrayList.size() > 0) {
                    Map map = this.breakpointsBeingEnabled;
                    synchronized (map) {
                        for (Breakpoint breakpoint : arrayList) {
                            this.breakpointsBeingEnabled.put(breakpoint, breakpoint.isEnabled());
                        }
                        if (this.rp == null) {
                            this.rp = new RequestProcessor("Enable Breakpoints RP", 1);
                        }
                        for (Breakpoint breakpoint : arrayList) {
                            this.rp.post((Runnable)new BreakpointEnabler(breakpoint, (Boolean)object2));
                        }
                    }
                }
                return;
            }
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.add(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection collection = this.modelListeners;
        synchronized (collection) {
            this.modelListeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireModelEvent(ModelEvent modelEvent) {
        ArrayList arrayList;
        Collection collection = this.modelListeners;
        synchronized (collection) {
            arrayList = new ArrayList(this.modelListeners);
        }
        for (ModelListener modelListener : arrayList) {
            modelListener.modelChanged(modelEvent);
        }
    }

    private class BreakpointEnabler
    implements Runnable {
        private Breakpoint bp;
        private boolean enable;

        public BreakpointEnabler(Breakpoint breakpoint, boolean bl) {
            this.bp = breakpoint;
            this.enable = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.enable) {
                this.bp.enable();
            } else {
                this.bp.disable();
            }
            Object object = BreakpointsTableModel.this.breakpointsBeingEnabled;
            synchronized (object) {
                BreakpointsTableModel.this.breakpointsBeingEnabled.remove(this.bp);
            }
            BreakpointsTableModel.this.fireModelEvent((ModelEvent)new ModelEvent.TableValueChanged((Object)BreakpointsTableModel.this, (Object)this.bp, "BreakpointEnabled"));
            object = this.bp.getGroupName();
            if (object != null) {
                BreakpointsTableModel.this.fireModelEvent((ModelEvent)new ModelEvent.TableValueChanged((Object)BreakpointsTableModel.this, object, "BreakpointEnabled"));
            }
        }
    }
}

