/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipException;
import org.netbeans.jemmy.Bundle;

public class BundleManager {
    private Hashtable bundles = new Hashtable();

    public BundleManager() {
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Bundle addBundle(Bundle bundle, String string) {
        if (this.getBundle(string) != null) {
            return null;
        }
        this.bundles.put(string, bundle);
        return bundle;
    }

    public Bundle removeBundle(String string) {
        Bundle bundle = this.getBundle(string);
        this.bundles.remove(string);
        return bundle;
    }

    public Bundle getBundle(String string) {
        return (Bundle)this.bundles.get(string);
    }

    public Bundle loadBundleFromFile(String string, String string2) throws IOException, FileNotFoundException {
        if (this.getBundle(string2) != null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.loadFromFile(string);
        return this.addBundle(bundle, string2);
    }

    public Bundle load() throws IOException, FileNotFoundException {
        if (System.getProperty("jemmy.resources") != null && !System.getProperty("jemmy.resources").equals("")) {
            return this.loadBundleFromFile(System.getProperty("jemmy.resources"), "");
        }
        return null;
    }

    public Bundle loadBundleFromJar(String string, String string2, String string3) throws IOException, FileNotFoundException {
        if (this.getBundle(string3) != null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.loadFromJar(string, string2);
        return this.addBundle(bundle, string3);
    }

    public Bundle loadBundleFromZip(String string, String string2, String string3) throws IOException, FileNotFoundException, ZipException {
        if (this.getBundle(string3) != null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.loadFromZip(string, string2);
        return this.addBundle(bundle, string3);
    }

    public void print(PrintWriter printWriter) {
        Enumeration enumeration = this.bundles.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            printWriter.println("\"" + string + "\" bundle contents");
            Bundle bundle = this.getBundle(string);
            bundle.print(printWriter);
        }
    }

    public void print(PrintStream printStream) {
        this.print(new PrintWriter(printStream));
    }

    public String getResource(String string, String string2) {
        Bundle bundle = this.getBundle(string);
        if (bundle != null) {
            return bundle.getResource(string2);
        }
        return null;
    }

    public String getResource(String string) {
        Enumeration enumeration = this.bundles.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = ((Bundle)enumeration.nextElement()).getResource(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public int calculateResources(String string) {
        Enumeration enumeration = this.bundles.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            if (((Bundle)enumeration.nextElement()).getResource(string) == null) continue;
            ++n;
        }
        return n;
    }

    public BundleManager cloneThis() {
        BundleManager bundleManager = new BundleManager();
        Enumeration enumeration = this.bundles.keys();
        Enumeration enumeration2 = this.bundles.elements();
        while (enumeration.hasMoreElements()) {
            bundleManager.bundles.put(enumeration.nextElement(), enumeration2.nextElement());
        }
        return bundleManager;
    }
}

