/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Vector;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waiter;

public class EventTool
implements Timeoutable,
Outputable {
    private static final long WAIT_EVENT_TIMEOUT = 60000L;
    private static final long WAIT_NO_EVENT_TIMEOUT = 180000L;
    private static final long EVENT_CHECKING_DELTA = 10L;
    private static ListenerSet listenerSet;
    private static long currentEventMask;
    private TestOut output;
    private Timeouts timeouts;

    public EventTool() {
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
    }

    public static long getLastEventTime(long l) {
        return listenerSet.getLastEventTime(l);
    }

    public static AWTEvent getLastEvent(long l) {
        return listenerSet.getLastEvent(l);
    }

    public static long getLastEventTime() {
        return EventTool.getLastEventTime(listenerSet.getTheWholeMask());
    }

    public static AWTEvent getLastEvent() {
        return EventTool.getLastEvent(listenerSet.getTheWholeMask());
    }

    public static void addListeners(long l) {
        EventTool.removeListeners();
        listenerSet.addListeners(l);
        currentEventMask = l;
    }

    public static void addListeners() {
        EventTool.addListeners(listenerSet.getTheWholeMask());
    }

    public static void removeListeners() {
        listenerSet.removeListeners();
    }

    public static long getCurrentEventMask() {
        return currentEventMask;
    }

    public static long getTheWholeEventMask() {
        return listenerSet.getTheWholeMask();
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public AWTEvent waitEvent(long l) {
        return this.waitEvent(l, this.timeouts.getTimeout("EventTool.WaitEventTimeout"), this.output.createErrorOutput());
    }

    public AWTEvent waitEvent() {
        return this.waitEvent(listenerSet.getTheWholeMask());
    }

    public boolean checkNoEvent(long l, long l2) {
        return this.checkNoEvent(l, l2, this.output);
    }

    public boolean checkNoEvent(long l) {
        return this.checkNoEvent(listenerSet.getTheWholeMask(), l);
    }

    public void waitNoEvent(long l, long l2) {
        NoEventWaiter noEventWaiter = new NoEventWaiter(l, l2);
        noEventWaiter.setTimeouts(this.timeouts.cloneThis());
        noEventWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.timeouts.getTimeout("EventTool.WaitNoEventTimeout"));
        noEventWaiter.getTimeouts().setTimeout("Waiter.TimeDelta", this.timeouts.getTimeout("EventTool.EventCheckingDelta"));
        try {
            noEventWaiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            this.output.printStackTrace(interruptedException);
        }
    }

    public void waitNoEvent(long l) {
        ListenerSet listenerSet = EventTool.listenerSet;
        if (listenerSet != null) {
            this.waitNoEvent(listenerSet.getTheWholeMask(), l);
        }
    }

    private AWTEvent waitEvent(long l, long l2, TestOut testOut) {
        EventWaiter eventWaiter = new EventWaiter(l);
        eventWaiter.setTimeouts(this.timeouts.cloneThis());
        eventWaiter.setOutput(testOut);
        eventWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", l2);
        eventWaiter.getTimeouts().setTimeout("Waiter.TimeDelta", this.timeouts.getTimeout("EventTool.EventCheckingDelta"));
        try {
            return (AWTEvent)eventWaiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            this.output.printStackTrace(interruptedException);
            return null;
        }
    }

    private boolean checkNoEvent(long l, long l2, TestOut testOut) {
        try {
            AWTEvent aWTEvent = this.waitEvent(l, l2, TestOut.getNullOutput());
            testOut.printLine("AWT event was produced during waiting: ");
            testOut.printLine(aWTEvent.getClass().getName());
            return false;
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            return true;
        }
    }

    static {
        currentEventMask = 0L;
        Timeouts.initDefault("EventTool.WaitEventTimeout", 60000L);
        Timeouts.initDefault("EventTool.WaitNoEventTimeout", 180000L);
        Timeouts.initDefault("EventTool.EventCheckingDelta", 10L);
        listenerSet = new ListenerSet();
        if (System.getProperty("jemmy.event_listening") == null || !System.getProperty("jemmy.event_listening").equals("no")) {
            listenerSet.addListeners();
        }
    }

    private class NoEventWaiter
    extends Waiter {
        long eventMask;
        long waitTime;

        public NoEventWaiter(long l, long l2) {
            this.eventMask = l;
            this.waitTime = l2;
        }

        public Object actionProduced(Object object) {
            return EventTool.this.checkNoEvent(this.eventMask, this.waitTime, TestOut.getNullOutput()) ? "Reached!" : null;
        }

        public String getDescription() {
            return "No event under " + Long.toString(this.eventMask, 2) + " event mask during " + Long.toString(this.waitTime) + " milliseconds";
        }
    }

    private class EventWaiter
    extends Waiter {
        long eventMask;
        long startTime;

        public EventWaiter(long l) {
            this.eventMask = l;
            this.startTime = EventTool.getLastEventTime(l);
        }

        public Object actionProduced(Object object) {
            EventType eventType = listenerSet.getLastEventType(this.eventMask);
            if (eventType != null && eventType.getTime() > this.startTime) {
                return eventType.getEvent();
            }
            return null;
        }

        public String getDescription() {
            return "Last event under " + Long.toString(this.eventMask, 2) + " event mask";
        }
    }

    private static class ListenerSet {
        private Vector eventTypes = new Vector();
        private long theWholeMask;

        public ListenerSet() {
            try {
                Class<?> clazz = Class.forName("java.awt.AWTEvent");
                Field[] fieldArray = clazz.getFields();
                this.theWholeMask = 0L;
                for (int i = 0; i < fieldArray.length; ++i) {
                    if ((fieldArray[i].getModifiers() & 9) == 0 || !fieldArray[i].getType().equals(Long.TYPE) || !fieldArray[i].getName().endsWith("_EVENT_MASK")) continue;
                    long l = (Long)fieldArray[i].get(null);
                    this.eventTypes.add(new EventType(l));
                    this.theWholeMask |= l;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                JemmyProperties.getCurrentOutput().printStackTrace(classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                JemmyProperties.getCurrentOutput().printStackTrace(illegalAccessException);
            }
        }

        public void addListeners(long l) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            for (int i = 0; i < this.eventTypes.size(); ++i) {
                EventType eventType = (EventType)this.eventTypes.get(i);
                if ((eventType.getEventMask() & l) == 0L) continue;
                toolkit.addAWTEventListener(eventType, eventType.getEventMask());
            }
        }

        public void addListeners() {
            this.addListeners(this.getTheWholeMask());
        }

        public void removeListeners() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            for (int i = 0; i < this.eventTypes.size(); ++i) {
                toolkit.removeAWTEventListener((EventType)this.eventTypes.get(i));
            }
        }

        public long getTheWholeMask() {
            return this.theWholeMask;
        }

        public long getLastEventTime(long l) {
            EventType eventType = this.getLastEventType(l);
            return eventType == null ? -1L : eventType.getTime();
        }

        public AWTEvent getLastEvent(long l) {
            EventType eventType = this.getLastEventType(l);
            return eventType == null ? null : eventType.getEvent();
        }

        private EventType getLastEventType(long l) {
            long l2 = -1L;
            EventType eventType = null;
            for (int i = 0; i < this.eventTypes.size(); ++i) {
                EventType eventType2 = (EventType)this.eventTypes.get(i);
                if ((l & eventType2.getEventMask()) == 0L || eventType2.getTime() <= l2) continue;
                eventType = eventType2;
                l2 = eventType.getTime();
            }
            return eventType;
        }
    }

    private static class EventType
    implements AWTEventListener {
        long eventMask;
        long eventTime;
        private Reference eventRef;

        public EventType(long l) {
            this.eventMask = l;
            this.eventRef = new WeakReference<Object>(null);
            this.eventTime = -1L;
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            this.eventRef = new WeakReference<AWTEvent>(aWTEvent);
            this.eventTime = System.currentTimeMillis();
        }

        public AWTEvent getEvent() {
            return (AWTEvent)this.eventRef.get();
        }

        public long getTime() {
            return this.eventTime;
        }

        public long getEventMask() {
            return this.eventMask;
        }
    }
}

