/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;

public class QueueTool
implements Outputable,
Timeoutable {
    private static final long WAIT_QUEUE_EMPTY_TIMEOUT = 180000L;
    private static final long QUEUE_CHECKING_DELTA = 10L;
    private static final long LOCK_TIMEOUT = 180000L;
    private static final long MAXIMUM_LOCKING_TIME = 180000L;
    private static final long INVOCATION_TIMEOUT = 180000L;
    private static JemmyQueue jemmyQueue = null;
    private TestOut output;
    private Timeouts timeouts;
    private Locker locker = new Locker();
    private Waiter lockWaiter = new Waiter(new Waitable(){

        public Object actionProduced(Object object) {
            return QueueTool.this.locker.isLocked() ? "" : null;
        }

        public String getDescription() {
            return "Event queue to be locked";
        }
    });

    public QueueTool() {
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
    }

    public static EventQueue getQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    public static boolean isDispatchThread() {
        QueueTool.getQueue();
        return EventQueue.isDispatchThread();
    }

    public static boolean checkEmpty() {
        return QueueTool.getQueue().peekEvent() == null;
    }

    public static void processEvent(AWTEvent aWTEvent) {
        if ((JemmyProperties.getCurrentDispatchingModel() & JemmyProperties.SHORTCUT_MODEL_MASK) != 0) {
            QueueTool.installQueue();
        }
        if ((JemmyProperties.getCurrentDispatchingModel() & JemmyProperties.SHORTCUT_MODEL_MASK) != 0 && QueueTool.isDispatchThread()) {
            QueueTool.shortcutEvent(aWTEvent);
        } else {
            QueueTool.postEvent(aWTEvent);
        }
    }

    public static void postEvent(AWTEvent aWTEvent) {
        QueueTool.getQueue().postEvent(aWTEvent);
    }

    public static void shortcutEvent(AWTEvent aWTEvent) {
        QueueTool.installQueue();
        jemmyQueue.shortcutEvent(aWTEvent);
    }

    public static void installQueue() {
        if (jemmyQueue == null) {
            jemmyQueue = new JemmyQueue();
        }
        jemmyQueue.install();
    }

    public static void uninstallQueue() {
        if (jemmyQueue != null) {
            jemmyQueue.uninstall();
        }
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        this.lockWaiter.setTimeouts(this.getTimeouts().cloneThis());
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        this.lockWaiter.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void waitEmpty() {
        Waiter waiter = new Waiter(new Waitable(){

            public Object actionProduced(Object object) {
                if (QueueTool.checkEmpty()) {
                    return "Empty";
                }
                return null;
            }

            public String getDescription() {
                return "Wait event queue empty";
            }
        });
        waiter.setTimeouts(this.timeouts.cloneThis());
        waiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.timeouts.getTimeout("QueueTool.WaitQueueEmptyTimeout"));
        waiter.setOutput(this.output);
        try {
            waiter.waitAction(null);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            final AWTEvent aWTEvent = QueueTool.getQueue().peekEvent();
            String string = aWTEvent == null ? "null" : (String)this.invokeSmoothly(new QueueAction("event.toString()"){

                public Object launch() {
                    return aWTEvent.toString();
                }
            });
            this.getOutput().printErrLine("Event at the top of stack: " + string);
            throw timeoutExpiredException;
        }
        catch (InterruptedException interruptedException) {
            this.output.printStackTrace(interruptedException);
        }
    }

    public void waitEmpty(long l) {
        StayingEmptyWaiter stayingEmptyWaiter = new StayingEmptyWaiter(l);
        stayingEmptyWaiter.setTimeouts(this.timeouts.cloneThis());
        stayingEmptyWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.timeouts.getTimeout("QueueTool.WaitQueueEmptyTimeout"));
        stayingEmptyWaiter.setOutput(this.output);
        try {
            stayingEmptyWaiter.waitAction(null);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            final AWTEvent aWTEvent = QueueTool.getQueue().peekEvent();
            String string = aWTEvent == null ? "null" : (String)this.invokeSmoothly(new QueueAction("event.toString()"){

                public Object launch() {
                    return aWTEvent.toString();
                }
            });
            this.getOutput().printErrLine("Event at the top of stack: " + string);
            throw timeoutExpiredException;
        }
        catch (InterruptedException interruptedException) {
            this.output.printStackTrace(interruptedException);
        }
    }

    public void invoke(QueueAction queueAction) {
        this.output.printTrace("Invoking \"" + queueAction.getDescription() + "\" action through event queue");
        EventQueue.invokeLater(queueAction);
    }

    public QueueAction invoke(Runnable runnable) {
        RunnableRunnable runnableRunnable = new RunnableRunnable(runnable);
        this.invoke(runnableRunnable);
        return runnableRunnable;
    }

    public QueueAction invoke(Action action, Object object) {
        ActionRunnable actionRunnable = new ActionRunnable(action, object);
        this.invoke(actionRunnable);
        return actionRunnable;
    }

    public Object invokeSmoothly(QueueAction queueAction) {
        QueueTool.getQueue();
        if (!EventQueue.isDispatchThread()) {
            return this.invokeAndWait(queueAction);
        }
        try {
            return queueAction.launch();
        }
        catch (Exception exception) {
            throw new JemmyException("Exception in " + queueAction.getDescription(), exception);
        }
    }

    public void invokeSmoothly(Runnable runnable) {
        QueueTool.getQueue();
        if (!EventQueue.isDispatchThread()) {
            this.invokeAndWait(runnable);
        } else {
            runnable.run();
        }
    }

    public Object invokeSmoothly(Action action, Object object) {
        QueueTool.getQueue();
        if (!EventQueue.isDispatchThread()) {
            return this.invokeAndWait(action, object);
        }
        return action.launch(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeAndWait(QueueAction queueAction) {
        class JemmyInvocationLock {
            JemmyInvocationLock() {
            }
        }
        JemmyInvocationLock jemmyInvocationLock = new JemmyInvocationLock();
        InvocationEvent invocationEvent = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), (Runnable)queueAction, jemmyInvocationLock, true);
        try {
            JemmyInvocationLock jemmyInvocationLock2 = jemmyInvocationLock;
            synchronized (jemmyInvocationLock2) {
                QueueTool.getQueue().postEvent(invocationEvent);
                jemmyInvocationLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("InterruptedException during " + queueAction.getDescription() + " execution", interruptedException);
        }
        if (queueAction.getException() != null) {
            throw new JemmyException("Exception in " + queueAction.getDescription(), queueAction.getException());
        }
        if (invocationEvent.getException() != null) {
            throw new JemmyException("Exception in " + queueAction.getDescription(), invocationEvent.getException());
        }
        return queueAction.getResult();
    }

    public void invokeAndWait(Runnable runnable) {
        this.invokeAndWait(new RunnableRunnable(runnable));
    }

    public Object invokeAndWait(Action action, Object object) {
        return this.invokeAndWait(new ActionRunnable(action, object));
    }

    public void lock() {
        this.output.printTrace("Locking queue.");
        this.invoke(this.locker);
        try {
            this.lockWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.timeouts.getTimeout("QueueTool.LockTimeout"));
            this.lockWaiter.getTimeouts().setTimeout("Waiter.TimeDelta", this.timeouts.getTimeout("QueueTool.QueueCheckingDelta"));
            this.lockWaiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            this.output.printStackTrace(interruptedException);
        }
    }

    public void unlock() {
        this.output.printTrace("Unlocking queue.");
        this.locker.setLocked(false);
    }

    public void lock(long l) {
        this.output.printTrace("Locking queue for " + Long.toString(l) + " milliseconds");
        this.lock();
        this.invoke(new UnlockPostponer(l));
    }

    public boolean wasLockingExpired() {
        return this.locker.expired;
    }

    static {
        Timeouts.initDefault("QueueTool.WaitQueueEmptyTimeout", 180000L);
        Timeouts.initDefault("QueueTool.QueueCheckingDelta", 10L);
        Timeouts.initDefault("QueueTool.LockTimeout", 180000L);
        Timeouts.initDefault("QueueTool.InvocationTimeout", 180000L);
        Timeouts.initDefault("QueueTool.MaximumLockingTime", 180000L);
    }

    private class UnlockPostponer
    implements Runnable {
        long time;

        public UnlockPostponer(long l) {
            this.time = l;
        }

        public void run() {
            new Timeout("", this.time).sleep();
            QueueTool.this.unlock();
        }
    }

    private class Locker
    extends QueueAction {
        boolean locked;
        long wholeTime;
        long deltaTime;
        boolean expired;

        public Locker() {
            super("Event queue locking");
            this.locked = false;
        }

        public Object launch() {
            this.wholeTime = QueueTool.this.timeouts.getTimeout("QueueTool.MaximumLockingTime");
            this.deltaTime = QueueTool.this.timeouts.getTimeout("QueueTool.QueueCheckingDelta");
            this.setLocked(true);
            this.expired = false;
            long l = System.currentTimeMillis();
            while (this.isLocked()) {
                try {
                    Thread.sleep(this.deltaTime);
                }
                catch (InterruptedException interruptedException) {
                    QueueTool.this.getOutput().printStackTrace(interruptedException);
                }
                if (System.currentTimeMillis() - l <= this.wholeTime) continue;
                QueueTool.this.getOutput().printLine("Locking has been expired!");
                this.expired = true;
                break;
            }
            return null;
        }

        public void setLocked(boolean bl) {
            this.locked = bl;
        }

        public boolean isLocked() {
            return this.locked;
        }
    }

    private class RunnableRunnable
    extends QueueAction {
        Runnable action;

        public RunnableRunnable(Runnable runnable) {
            super("Runnable");
            this.action = runnable;
        }

        public Object launch() throws Exception {
            this.action.run();
            return null;
        }
    }

    private class ActionRunnable
    extends QueueAction {
        Action action;
        Object param;

        public ActionRunnable(Action action, Object object) {
            super(action.getDescription());
            this.action = action;
            this.param = object;
        }

        public Object launch() throws Exception {
            return this.action.launch(this.param);
        }
    }

    private class StayingEmptyWaiter
    extends Waiter {
        long emptyTime;

        public StayingEmptyWaiter(long l) {
            this.emptyTime = l;
        }

        public Object actionProduced(Object object) {
            try {
                EventWaiter eventWaiter = new EventWaiter(this.emptyTime);
                EventQueue.invokeAndWait(eventWaiter);
                if (eventWaiter.empty && this.timeFromStart() <= super.getTimeouts().getTimeout("Waiter.WaitingTime")) {
                    return "Reached";
                }
            }
            catch (InterruptedException interruptedException) {
                QueueTool.this.output.printStackTrace(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                QueueTool.this.output.printStackTrace(invocationTargetException);
            }
            return null;
        }

        public String getDescription() {
            return "Wait event queue staying empty for " + Long.toString(this.emptyTime);
        }
    }

    private class EventWaiter
    implements Runnable {
        boolean empty = true;
        long emptyTime;

        public EventWaiter(long l) {
            this.emptyTime = l;
        }

        public void run() {
            long l = System.currentTimeMillis();
            while ((this.empty = QueueTool.checkEmpty()) && System.currentTimeMillis() - l < this.emptyTime) {
                QueueTool.this.timeouts.sleep("QueueTool.QueueCheckingDelta");
            }
        }
    }

    private static class JemmyQueue
    extends EventQueue {
        private boolean installed = false;

        private JemmyQueue() {
        }

        public void shortcutEvent(AWTEvent aWTEvent) {
            super.dispatchEvent(aWTEvent);
        }

        protected void dispatchEvent(AWTEvent aWTEvent) {
            try {
                super.dispatchEvent(aWTEvent);
            }
            catch (Exception exception) {
                JemmyProperties.getCurrentOutput().printStackTrace(exception);
            }
        }

        public synchronized void install() {
            if (!this.installed) {
                QueueTool.getQueue().push(this);
                this.installed = true;
            }
        }

        public synchronized void uninstall() {
            if (this.installed) {
                this.pop();
                this.installed = false;
            }
        }
    }

    public static abstract class QueueAction
    implements Runnable {
        private boolean finished;
        private Exception exception;
        private Object result;
        private String description;

        public QueueAction(String string) {
            this.description = string;
            this.finished = false;
            this.exception = null;
            this.result = null;
        }

        public abstract Object launch() throws Exception;

        public final void run() {
            this.finished = false;
            this.exception = null;
            this.result = null;
            try {
                this.result = this.launch();
            }
            catch (Exception exception) {
                this.exception = exception;
            }
            this.finished = true;
        }

        public String getDescription() {
            return this.description;
        }

        public Object getResult() {
            return this.result;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean getFinished() {
            return this.finished;
        }
    }
}

