/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.TimeoutExpiredException;

public class Timeout {
    private String name;
    private long value;
    private long startTime;

    public Timeout(String string, long l) {
        this.name = string;
        this.value = l;
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.value;
    }

    public void sleep() {
        if (this.getValue() > 0L) {
            try {
                Thread.currentThread();
                Thread.sleep(this.getValue());
            }
            catch (InterruptedException interruptedException) {
                throw new JemmyException("Sleep " + this.getName() + " was interrupted!", interruptedException);
            }
        }
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.startTime > this.getValue();
    }

    public void check() {
        if (this.expired()) {
            throw new TimeoutExpiredException(this.getName() + " timeout expired!");
        }
    }
}

