/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers;

import org.netbeans.jemmy.EventDispatcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.input.KeyEventDriver;
import org.netbeans.jemmy.drivers.input.KeyRobotDriver;
import org.netbeans.jemmy.drivers.input.MouseEventDriver;
import org.netbeans.jemmy.drivers.input.MouseRobotDriver;

public class InputDriverInstaller {
    Timeout robotAutoDelay;
    boolean useEventDrivers;
    boolean smooth = false;

    public InputDriverInstaller(boolean bl, Timeout timeout) {
        this.robotAutoDelay = timeout;
        this.useEventDrivers = bl;
    }

    public InputDriverInstaller(boolean bl) {
        this(bl, JemmyProperties.getCurrentTimeouts().create("EventDispatcher.RobotAutoDelay"));
    }

    public InputDriverInstaller(boolean bl, boolean bl2) {
        this(bl);
        this.smooth = bl2;
    }

    public InputDriverInstaller(Timeout timeout) {
        this(true, timeout);
    }

    public InputDriverInstaller() {
        this(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void install() {
        if (this.useEventDrivers) {
            KeyEventDriver keyEventDriver = new KeyEventDriver();
            MouseEventDriver mouseEventDriver = new MouseEventDriver();
            DriverManager.removeDriver("drivers.key", keyEventDriver.getSupported());
            DriverManager.removeDriver("drivers.mouse", mouseEventDriver.getSupported());
            DriverManager.setDriver("drivers.key", keyEventDriver);
            DriverManager.setDriver("drivers.mouse", mouseEventDriver);
            try {
                String[] stringArray = new String[]{"org.netbeans.jemmy.operators.ButtonOperator", "org.netbeans.jemmy.operators.CheckboxOperator", "org.netbeans.jemmy.operators.ChoiceOperator", "org.netbeans.jemmy.operators.LabelOperator", "org.netbeans.jemmy.operators.ListOperator", "org.netbeans.jemmy.operators.ScrollPaneOperator", "org.netbeans.jemmy.operators.ScrollbarOperator", "org.netbeans.jemmy.operators.TextAreaOperator", "org.netbeans.jemmy.operators.TextComponentOperator", "org.netbeans.jemmy.operators.TextFieldOperator"};
                KeyRobotDriver keyRobotDriver = new KeyRobotDriver(this.robotAutoDelay, stringArray);
                MouseRobotDriver mouseRobotDriver = new MouseRobotDriver(this.robotAutoDelay, stringArray);
                DriverManager.removeDriver("drivers.key", keyRobotDriver.getSupported());
                DriverManager.removeDriver("drivers.mouse", mouseRobotDriver.getSupported());
                DriverManager.setDriver("drivers.key", keyRobotDriver);
                DriverManager.setDriver("drivers.mouse", mouseRobotDriver);
                return;
            }
            catch (JemmyException jemmyException) {
                if (jemmyException.getInnerException() instanceof ClassNotFoundException) return;
                throw jemmyException;
            }
        } else {
            KeyRobotDriver keyRobotDriver = new KeyRobotDriver(this.robotAutoDelay);
            MouseRobotDriver mouseRobotDriver = new MouseRobotDriver(this.robotAutoDelay, this.smooth);
            DriverManager.removeDriver("drivers.key", keyRobotDriver.getSupported());
            DriverManager.removeDriver("drivers.mouse", mouseRobotDriver.getSupported());
            DriverManager.setDriver("drivers.key", keyRobotDriver);
            DriverManager.setDriver("drivers.mouse", mouseRobotDriver);
        }
    }

    static {
        Class clazz = EventDispatcher.class;
    }
}

