/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.scrolling;

import java.awt.Point;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ComponentOperator;

public abstract class AbstractScrollDriver
extends LightSupportiveDriver
implements ScrollDriver {
    public static final int ADJUST_CLICK_COUNT = 10;

    public AbstractScrollDriver(String[] stringArray) {
        super(stringArray);
    }

    public void scroll(ComponentOperator componentOperator, ScrollAdjuster scrollAdjuster) {
        if (this.canJump(componentOperator)) {
            this.doJumps(componentOperator, scrollAdjuster);
        }
        if (this.canDragAndDrop(componentOperator)) {
            this.doDragAndDrop(componentOperator, scrollAdjuster);
        }
        if (this.canPushAndWait(componentOperator)) {
            this.doPushAndWait(componentOperator, scrollAdjuster);
        }
        for (int i = 0; i < 10; ++i) {
            this.doSteps(componentOperator, scrollAdjuster);
        }
    }

    protected abstract void step(ComponentOperator var1, ScrollAdjuster var2);

    protected abstract void jump(ComponentOperator var1, ScrollAdjuster var2);

    protected abstract void startPushAndWait(ComponentOperator var1, int var2, int var3);

    protected abstract void stopPushAndWait(ComponentOperator var1, int var2, int var3);

    protected abstract Point startDragging(ComponentOperator var1);

    protected abstract void drop(ComponentOperator var1, Point var2);

    protected abstract void drag(ComponentOperator var1, Point var2);

    protected abstract Timeout getScrollDeltaTimeout(ComponentOperator var1);

    protected abstract boolean canDragAndDrop(ComponentOperator var1);

    protected abstract boolean canJump(ComponentOperator var1);

    protected abstract boolean canPushAndWait(ComponentOperator var1);

    protected abstract int getDragAndDropStepLength(ComponentOperator var1);

    protected void doDragAndDrop(ComponentOperator componentOperator, ScrollAdjuster scrollAdjuster) {
        int n = scrollAdjuster.getScrollDirection();
        if (n != 0) {
            Point point = this.startDragging(componentOperator);
            while (scrollAdjuster.getScrollDirection() == n) {
                point = this.increasePoint(componentOperator, point, scrollAdjuster, n);
                this.drag(componentOperator, point);
            }
            this.drop(componentOperator, point);
        }
    }

    protected void doJumps(ComponentOperator componentOperator, ScrollAdjuster scrollAdjuster) {
        int n = scrollAdjuster.getScrollDirection();
        if (n != 0) {
            while (scrollAdjuster.getScrollDirection() == n) {
                this.jump(componentOperator, scrollAdjuster);
            }
        }
    }

    protected void doPushAndWait(ComponentOperator componentOperator, ScrollAdjuster scrollAdjuster) {
        int n = scrollAdjuster.getScrollDirection();
        int n2 = scrollAdjuster.getScrollOrientation();
        if (n != 0) {
            Timeout timeout = this.getScrollDeltaTimeout(componentOperator);
            this.startPushAndWait(componentOperator, n, n2);
            while (scrollAdjuster.getScrollDirection() == n) {
                timeout.sleep();
            }
            this.stopPushAndWait(componentOperator, n, n2);
        }
    }

    protected void doSteps(ComponentOperator componentOperator, ScrollAdjuster scrollAdjuster) {
        int n = scrollAdjuster.getScrollDirection();
        if (n != 0) {
            while (scrollAdjuster.getScrollDirection() == n) {
                this.step(componentOperator, scrollAdjuster);
            }
        }
    }

    private Point increasePoint(ComponentOperator componentOperator, Point point, ScrollAdjuster scrollAdjuster, int n) {
        return scrollAdjuster.getScrollOrientation() == 0 ? new Point(point.x + (n == 1 ? 1 : -1) * this.getDragAndDropStepLength(componentOperator), point.y) : new Point(point.x, point.y + (n == 1 ? 1 : -1) * this.getDragAndDropStepLength(componentOperator));
    }
}

