/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.text;

import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.TextDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.TextComponentOperator;

public abstract class TextAPIDriver
extends LightSupportiveDriver
implements TextDriver {
    public TextAPIDriver(String[] stringArray) {
        super(stringArray);
    }

    public void changeCaretPosition(ComponentOperator componentOperator, int n) {
        this.checkSupported(componentOperator);
        if (componentOperator instanceof TextComponentOperator) {
            ((TextComponentOperator)componentOperator).setCaretPosition(n);
        } else {
            ((JTextComponentOperator)componentOperator).setCaretPosition(n);
        }
    }

    public void selectText(ComponentOperator componentOperator, int n, int n2) {
        int n3;
        this.checkSupported(componentOperator);
        int n4 = n < n2 ? n : n2;
        int n5 = n3 = n > n2 ? n : n2;
        if (componentOperator instanceof TextComponentOperator) {
            TextComponentOperator textComponentOperator = (TextComponentOperator)componentOperator;
            textComponentOperator.setSelectionStart(n4);
            textComponentOperator.setSelectionEnd(n3);
        } else {
            JTextComponentOperator jTextComponentOperator = (JTextComponentOperator)componentOperator;
            jTextComponentOperator.setSelectionStart(n4);
            jTextComponentOperator.setSelectionEnd(n3);
        }
    }

    public void clearText(ComponentOperator componentOperator) {
        if (componentOperator instanceof TextComponentOperator) {
            ((TextComponentOperator)componentOperator).setText("");
        } else {
            ((JTextComponentOperator)componentOperator).setText("");
        }
    }

    public void typeText(ComponentOperator componentOperator, String string, int n) {
        this.checkSupported(componentOperator);
        String string2 = this.getText(componentOperator);
        int n2 = n;
        if (this.getSelectionStart(componentOperator) == n2 || this.getSelectionEnd(componentOperator) == n2) {
            if (this.getSelectionEnd(componentOperator) == n2) {
                n2 -= this.getSelectionEnd(componentOperator) - this.getSelectionStart(componentOperator);
            }
            string2 = string2.substring(0, this.getSelectionStart(componentOperator)) + string2.substring(this.getSelectionEnd(componentOperator));
        }
        this.changeText(componentOperator, string2.substring(0, n2) + string + string2.substring(n2));
    }

    public void changeText(ComponentOperator componentOperator, String string) {
        this.checkSupported(componentOperator);
        if (componentOperator instanceof TextComponentOperator) {
            ((TextComponentOperator)componentOperator).setText(string);
        } else {
            ((JTextComponentOperator)componentOperator).setText(string);
        }
    }

    public void enterText(ComponentOperator componentOperator, String string) {
        this.changeText(componentOperator, string);
        DriverManager.getKeyDriver(componentOperator).pushKey(componentOperator, 10, 0, new Timeout("", 0L));
    }

    public abstract String getText(ComponentOperator var1);

    public abstract int getCaretPosition(ComponentOperator var1);

    public abstract int getSelectionStart(ComponentOperator var1);

    public abstract int getSelectionEnd(ComponentOperator var1);
}

