/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.image;

import java.awt.Point;
import java.awt.image.BufferedImage;
import org.netbeans.jemmy.image.ImageFinder;

public class RoughImageFinder
implements ImageFinder {
    double roughness = 0.0;
    int bigWidth;
    int bigHeight;
    int[][] bigPixels;

    public RoughImageFinder(BufferedImage bufferedImage, double d) {
        this.roughness = d;
        this.bigWidth = bufferedImage.getWidth();
        this.bigHeight = bufferedImage.getHeight();
        this.bigPixels = new int[this.bigWidth][this.bigHeight];
        for (int i = 0; i < this.bigWidth; ++i) {
            for (int j = 0; j < this.bigHeight; ++j) {
                this.bigPixels[i][j] = bufferedImage.getRGB(i, j);
            }
        }
    }

    public Point findImage(BufferedImage bufferedImage, int n) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int[][] nArray = new int[n2][n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                nArray[i][j] = bufferedImage.getRGB(i, j);
            }
        }
        double d = (double)(n2 * n3) * this.roughness;
        int n4 = 0;
        for (int i = 0; i <= this.bigWidth - n2; ++i) {
            for (int j = 0; j <= this.bigHeight - n3; ++j) {
                int n5 = 0;
                for (int k = 0; k < n2; ++k) {
                    for (int i2 = 0; !(i2 >= n3 || nArray[k][i2] != this.bigPixels[i + k][j + i2] && (double)(++n5) > d); ++i2) {
                    }
                    if ((double)n5 > d) break;
                }
                if (!((double)n5 <= d)) continue;
                if (n4 == n) {
                    return new Point(i, j);
                }
                ++n4;
            }
        }
        return null;
    }
}

