/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.ButtonDriver;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class ButtonOperator
extends ComponentOperator
implements Timeoutable,
Outputable {
    public static final String TEXT_DPROP = "Label";
    private static final long PUSH_BUTTON_TIMEOUT = 0L;
    private Timeouts timeouts;
    private TestOut output;
    ButtonDriver driver = DriverManager.getButtonDriver(this.getClass());
    static /* synthetic */ Class class$java$awt$Button;

    public ButtonOperator(Button button) {
        super(button);
    }

    public ButtonOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((Button)containerOperator.waitSubComponent(new ButtonFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public ButtonOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public ButtonOperator(ContainerOperator containerOperator, String string, int n) {
        this((Button)ButtonOperator.waitComponent(containerOperator, (ComponentChooser)new ButtonByLabelFinder(string, containerOperator.getComparator()), n));
        this.copyEnvironment(containerOperator);
    }

    public ButtonOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public ButtonOperator(ContainerOperator containerOperator, int n) {
        this((Button)ButtonOperator.waitComponent(containerOperator, (ComponentChooser)new ButtonFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public ButtonOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static Button findButton(Container container, ComponentChooser componentChooser, int n) {
        return (Button)ButtonOperator.findComponent(container, new ButtonFinder(componentChooser), n);
    }

    public static Button findButton(Container container, ComponentChooser componentChooser) {
        return ButtonOperator.findButton(container, componentChooser, 0);
    }

    public static Button findButton(Container container, String string, boolean bl, boolean bl2, int n) {
        return ButtonOperator.findButton(container, new ButtonByLabelFinder(string, new Operator.DefaultStringComparator(bl, bl2)), n);
    }

    public static Button findButton(Container container, String string, boolean bl, boolean bl2) {
        return ButtonOperator.findButton(container, string, bl, bl2, 0);
    }

    public static Button waitButton(Container container, ComponentChooser componentChooser, int n) {
        return (Button)ButtonOperator.waitComponent(container, (ComponentChooser)new ButtonFinder(componentChooser), n);
    }

    public static Button waitButton(Container container, ComponentChooser componentChooser) {
        return ButtonOperator.waitButton(container, componentChooser, 0);
    }

    public static Button waitButton(Container container, String string, boolean bl, boolean bl2, int n) {
        return ButtonOperator.waitButton(container, new ButtonByLabelFinder(string, new Operator.DefaultStringComparator(bl, bl2)), n);
    }

    public static Button waitButton(Container container, String string, boolean bl, boolean bl2) {
        return ButtonOperator.waitButton(container, string, bl, bl2, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (ButtonDriver)DriverManager.getDriver("drivers.button", this.getClass(), operator.getProperties());
    }

    public void push() {
        this.output.printLine("Push button\n    :" + this.toStringSource());
        this.output.printGolden("Push button");
        this.driver.push(this);
    }

    public void pushNoBlock() {
        this.produceNoBlocking(new Operator.NoBlockingAction("Button pushing"){

            public Object doAction(Object object) {
                ButtonOperator.this.push();
                return null;
            }
        });
    }

    public void press() {
        this.output.printLine("Press button\n    :" + this.toStringSource());
        this.output.printGolden("Press button");
        this.driver.press(this);
    }

    public void release() {
        this.output.printLine("Release button\n    :" + this.toStringSource());
        this.output.printGolden("Release button");
        this.driver.press(this);
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        if (((Button)this.getSource()).getLabel() != null) {
            hashtable.put(TEXT_DPROP, ((Button)this.getSource()).getLabel());
        }
        return hashtable;
    }

    public void addActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("addActionListener"){

            public void map() {
                ((Button)ButtonOperator.this.getSource()).addActionListener(actionListener);
            }
        });
    }

    public String getActionCommand() {
        return (String)this.runMapping(new Operator.MapAction("getActionCommand"){

            public Object map() {
                return ((Button)ButtonOperator.this.getSource()).getActionCommand();
            }
        });
    }

    public String getLabel() {
        return (String)this.runMapping(new Operator.MapAction("getLabel"){

            public Object map() {
                return ((Button)ButtonOperator.this.getSource()).getLabel();
            }
        });
    }

    public void removeActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("removeActionListener"){

            public void map() {
                ((Button)ButtonOperator.this.getSource()).removeActionListener(actionListener);
            }
        });
    }

    public void setActionCommand(final String string) {
        this.runMapping(new Operator.MapVoidAction("setActionCommand"){

            public void map() {
                ((Button)ButtonOperator.this.getSource()).setActionCommand(string);
            }
        });
    }

    public void setLabel(final String string) {
        this.runMapping(new Operator.MapVoidAction("setLabel"){

            public void map() {
                ((Button)ButtonOperator.this.getSource()).setLabel(string);
            }
        });
    }

    static {
        Timeouts.initDefault("ButtonOperator.PushButtonTimeout", 0L);
    }

    public static class ButtonFinder
    extends Operator.Finder {
        public ButtonFinder(ComponentChooser componentChooser) {
            super(class$java$awt$Button == null ? (class$java$awt$Button = ButtonOperator.class$("java.awt.Button")) : class$java$awt$Button, componentChooser);
        }

        public ButtonFinder() {
            super(class$java$awt$Button == null ? (class$java$awt$Button = ButtonOperator.class$("java.awt.Button")) : class$java$awt$Button);
        }
    }

    public static class ButtonByLabelFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public ButtonByLabelFinder(String string, Operator.StringComparator stringComparator) {
            this.label = string;
            this.comparator = stringComparator;
        }

        public ButtonByLabelFinder(String string) {
            this(string, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof Button && ((Button)component).getLabel() != null) {
                return this.comparator.equals(((Button)component).getLabel(), this.label);
            }
            return false;
        }

        public String getDescription() {
            return "Button with label \"" + this.label + "\"";
        }
    }
}

