/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyInputException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.MultiSelListDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JScrollPaneOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JListOperator
extends JComponentOperator
implements Outputable {
    public static final String ITEM_PREFIX_DPROP = "Item";
    public static final String SELECTED_ITEM_PREFIX_DPROP = "SelectedItem";
    private TestOut output;
    private MultiSelListDriver driver = DriverManager.getMultiSelListDriver(this.getClass());
    static /* synthetic */ Class class$javax$swing$JList;

    public JListOperator(JList jList) {
        super(jList);
    }

    public JListOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((JList)containerOperator.waitSubComponent(new JListFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public JListOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public JListOperator(ContainerOperator containerOperator, String string, int n, int n2) {
        this((JList)JListOperator.waitComponent(containerOperator, (ComponentChooser)new JListByItemFinder(string, n, containerOperator.getComparator()), n2));
        this.copyEnvironment(containerOperator);
    }

    public JListOperator(ContainerOperator containerOperator, String string, int n) {
        this(containerOperator, string, -1, n);
    }

    public JListOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public JListOperator(ContainerOperator containerOperator, int n) {
        this((JList)JListOperator.waitComponent(containerOperator, (ComponentChooser)new JListFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public JListOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static JList findJList(Container container, ComponentChooser componentChooser, int n) {
        return (JList)JListOperator.findComponent(container, new JListFinder(componentChooser), n);
    }

    public static JList findJList(Container container, ComponentChooser componentChooser) {
        return JListOperator.findJList(container, componentChooser, 0);
    }

    public static JList findJList(Container container, String string, boolean bl, boolean bl2, int n, int n2) {
        return JListOperator.findJList(container, new JListByItemFinder(string, n, new Operator.DefaultStringComparator(bl, bl2)), n2);
    }

    public static JList findJList(Container container, String string, boolean bl, boolean bl2, int n) {
        return JListOperator.findJList(container, string, bl, bl2, n, 0);
    }

    public static JList waitJList(Container container, ComponentChooser componentChooser, int n) {
        return (JList)JListOperator.waitComponent(container, (ComponentChooser)new JListFinder(componentChooser), n);
    }

    public static JList waitJList(Container container, ComponentChooser componentChooser) {
        return JListOperator.waitJList(container, componentChooser, 0);
    }

    public static JList waitJList(Container container, String string, boolean bl, boolean bl2, int n, int n2) {
        return JListOperator.waitJList(container, new JListByItemFinder(string, n, new Operator.DefaultStringComparator(bl, bl2)), n2);
    }

    public static JList waitJList(Container container, String string, boolean bl, boolean bl2, int n) {
        return JListOperator.waitJList(container, string, bl, bl2, n, 0);
    }

    public void setOutput(TestOut testOut) {
        super.setOutput(testOut.createErrorOutput());
        this.output = testOut;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (MultiSelListDriver)DriverManager.getDriver("drivers.multisellist", this.getClass(), operator.getProperties());
    }

    public Point getClickPoint(int n) {
        Rectangle rectangle = this.getCellBounds(n, n);
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public Component getRenderedComponent(int n, boolean bl, boolean bl2) {
        return this.getCellRenderer().getListCellRendererComponent((JList)this.getSource(), this.getModel().getElementAt(n), n, bl, bl2);
    }

    public Component getRenderedComponent(int n) {
        return this.getRenderedComponent(n, this.isSelectedIndex(n), false);
    }

    public int findItemIndex(ListItemChooser listItemChooser, int n) {
        ListModel listModel = this.getModel();
        int n2 = 0;
        for (int i = 0; i < listModel.getSize(); ++i) {
            if (!listItemChooser.checkItem(this, i)) continue;
            if (n2 == n) {
                return i;
            }
            ++n2;
        }
        return -1;
    }

    public int findItemIndex(ListItemChooser listItemChooser) {
        return this.findItemIndex(listItemChooser, 0);
    }

    public int findItemIndex(String string, Operator.StringComparator stringComparator, int n) {
        return this.findItemIndex(new BySubStringListItemChooser(string, stringComparator), n);
    }

    public int findItemIndex(String string, boolean bl, boolean bl2, int n) {
        return this.findItemIndex(string, new Operator.DefaultStringComparator(bl, bl2), n);
    }

    public int findItemIndex(String string, int n) {
        return this.findItemIndex(string, this.getComparator(), n);
    }

    public int findItemIndex(String string, Operator.StringComparator stringComparator) {
        return this.findItemIndex(string, stringComparator, 0);
    }

    public int findItemIndex(String string, boolean bl, boolean bl2) {
        return this.findItemIndex(string, bl, bl2, 0);
    }

    public int findItemIndex(String string) {
        return this.findItemIndex(string, 0);
    }

    public int findItemIndex(ComponentChooser componentChooser, int n) {
        return this.findItemIndex(new ByRenderedComponentListItemChooser(componentChooser), n);
    }

    public int findItemIndex(ComponentChooser componentChooser) {
        return this.findItemIndex(componentChooser, 0);
    }

    public Object clickOnItem(final int n, final int n2) {
        this.output.printLine("Click " + Integer.toString(n2) + " times on JList\n    : " + this.toStringSource());
        this.output.printGolden("Click " + Integer.toString(n2) + " times on JList");
        this.checkIndex(n);
        try {
            this.scrollToItem(n);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            this.output.printStackTrace(timeoutExpiredException);
        }
        if (((JList)this.getSource()).getModel().getSize() <= n) {
            this.output.printErrLine("JList " + this.toStringSource() + " does not contain " + Integer.toString(n) + "'th item");
            return null;
        }
        if (((JList)this.getSource()).getAutoscrolls()) {
            ((JList)this.getSource()).ensureIndexIsVisible(n);
        }
        return this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

            public Object launch() {
                Rectangle rectangle = JListOperator.this.getCellBounds(n, n);
                if (rectangle == null) {
                    JListOperator.this.output.printErrLine("Impossible to determine click point for " + Integer.toString(n) + "'th item");
                    return null;
                }
                Point point = new Point((int)(rectangle.getX() + rectangle.getWidth() / 2.0), (int)(rectangle.getY() + rectangle.getHeight() / 2.0));
                Object e = JListOperator.this.getModel().getElementAt(n);
                JListOperator.this.clickMouse(point.x, point.y, n2);
                return e;
            }
        });
    }

    public Object clickOnItem(final String string, final Operator.StringComparator stringComparator, final int n) {
        this.scrollToItem(this.findItemIndex(string, stringComparator, 0));
        return this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

            public Object launch() {
                int n2 = JListOperator.this.findItemIndex(string, stringComparator, 0);
                if (n2 != -1) {
                    return JListOperator.this.clickOnItem(n2, n);
                }
                throw new NoSuchItemException(string);
            }
        });
    }

    public Object clickOnItem(String string, boolean bl, boolean bl2, int n) {
        return this.clickOnItem(string, new Operator.DefaultStringComparator(bl, bl2), n);
    }

    public Object clickOnItem(String string, int n) {
        return this.clickOnItem(string, this.getComparator(), n);
    }

    public Object clickOnItem(String string, Operator.StringComparator stringComparator) {
        return this.clickOnItem(string, stringComparator, 1);
    }

    public Object clickOnItem(String string, boolean bl, boolean bl2) {
        return this.clickOnItem(string, bl, bl2, 1);
    }

    public Object clickOnItem(String string) {
        return this.clickOnItem(string, 0);
    }

    public void scrollToItem(int n) {
        this.output.printTrace("Scroll JList to " + Integer.toString(n) + "'th item\n    : " + this.toStringSource());
        this.output.printGolden("Scroll JList to " + Integer.toString(n) + "'th item");
        this.checkIndex(n);
        this.makeComponentVisible();
        JScrollPane jScrollPane = (JScrollPane)this.getContainer(new JScrollPaneOperator.JScrollPaneFinder(ComponentSearcher.getTrueChooser("JScrollPane")));
        if (jScrollPane == null) {
            return;
        }
        JScrollPaneOperator jScrollPaneOperator = new JScrollPaneOperator(jScrollPane);
        jScrollPaneOperator.copyEnvironment(this);
        jScrollPaneOperator.setVisualizer(new EmptyVisualizer());
        Rectangle rectangle = this.getCellBounds(n, n);
        jScrollPaneOperator.scrollToComponentRectangle(this.getSource(), (int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
    }

    public void scrollToItem(String string, Operator.StringComparator stringComparator) {
        this.scrollToItem(this.findItemIndex(string, stringComparator));
    }

    public void scrollToItem(String string, boolean bl, boolean bl2) {
        this.scrollToItem(this.findItemIndex(string, bl, bl2));
    }

    public void selectItem(int n) {
        this.checkIndex(n);
        this.driver.selectItem(this, n);
        if (this.getVerification()) {
            this.waitItemSelection(n, true);
        }
    }

    public void selectItem(final String string) {
        this.scrollToItem(this.findItemIndex(string));
        this.getQueueTool().invokeSmoothly(new QueueTool.QueueAction("Path selecting"){

            public Object launch() {
                JListOperator.this.driver.selectItem(JListOperator.this, JListOperator.this.findItemIndex(string));
                return null;
            }
        });
    }

    public void selectItems(int[] nArray) {
        this.checkIndices(nArray);
        this.driver.selectItems(this, nArray);
        if (this.getVerification()) {
            this.waitItemsSelection(nArray, true);
        }
    }

    public void selectItem(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = this.findItemIndex(stringArray[i]);
        }
        this.selectItems(nArray);
    }

    public void waitItemsSelection(final int[] nArray, final boolean bl) {
        this.getOutput().printLine("Wait items to be " + (bl ? "" : "un") + "selected in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait items to be " + (bl ? "" : "un") + "selected");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                int[] nArray2 = JListOperator.this.getSelectedIndices();
                for (int i = 0; i < nArray2.length; ++i) {
                    if (nArray2[i] == nArray[i]) continue;
                    return false;
                }
                return true;
            }

            public String getDescription() {
                return "Item has been " + (bl ? "" : "un") + "selected";
            }
        });
    }

    public void waitItemSelection(int n, boolean bl) {
        this.waitItemsSelection(new int[]{n}, bl);
    }

    public void waitItem(String string, int n) {
        this.getOutput().printLine("Wait \"" + string + "\" at the " + Integer.toString(n) + " position in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + string + "\" at the " + Integer.toString(n) + " position");
        this.waitState(new JListByItemFinder(string, n, this.getComparator()));
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        Object[] objectArray = new String[((JList)this.getSource()).getModel().getSize()];
        for (int i = 0; i < ((JList)this.getSource()).getModel().getSize(); ++i) {
            objectArray[i] = ((JList)this.getSource()).getModel().getElementAt(i).toString();
        }
        int[] nArray = ((JList)this.getSource()).getSelectedIndices();
        Object[] objectArray2 = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray2[i] = objectArray[nArray[i]];
        }
        this.addToDump(hashtable, ITEM_PREFIX_DPROP, objectArray);
        this.addToDump(hashtable, SELECTED_ITEM_PREFIX_DPROP, objectArray2);
        return hashtable;
    }

    public void addListSelectionListener(final ListSelectionListener listSelectionListener) {
        this.runMapping(new Operator.MapVoidAction("addListSelectionListener"){

            public void map() {
                ((JList)JListOperator.this.getSource()).addListSelectionListener(listSelectionListener);
            }
        });
    }

    public void addSelectionInterval(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("addSelectionInterval"){

            public void map() {
                ((JList)JListOperator.this.getSource()).addSelectionInterval(n, n2);
            }
        });
    }

    public void clearSelection() {
        this.runMapping(new Operator.MapVoidAction("clearSelection"){

            public void map() {
                ((JList)JListOperator.this.getSource()).clearSelection();
            }
        });
    }

    public void ensureIndexIsVisible(final int n) {
        this.runMapping(new Operator.MapVoidAction("ensureIndexIsVisible"){

            public void map() {
                ((JList)JListOperator.this.getSource()).ensureIndexIsVisible(n);
            }
        });
    }

    public int getAnchorSelectionIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getAnchorSelectionIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getAnchorSelectionIndex();
            }
        });
    }

    public Rectangle getCellBounds(final int n, final int n2) {
        return (Rectangle)this.runMapping(new Operator.MapAction("getCellBounds"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getCellBounds(n, n2);
            }
        });
    }

    public ListCellRenderer getCellRenderer() {
        return (ListCellRenderer)this.runMapping(new Operator.MapAction("getCellRenderer"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getCellRenderer();
            }
        });
    }

    public int getFirstVisibleIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getFirstVisibleIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getFirstVisibleIndex();
            }
        });
    }

    public int getFixedCellHeight() {
        return this.runMapping(new Operator.MapIntegerAction("getFixedCellHeight"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getFixedCellHeight();
            }
        });
    }

    public int getFixedCellWidth() {
        return this.runMapping(new Operator.MapIntegerAction("getFixedCellWidth"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getFixedCellWidth();
            }
        });
    }

    public int getLastVisibleIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getLastVisibleIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getLastVisibleIndex();
            }
        });
    }

    public int getLeadSelectionIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getLeadSelectionIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getLeadSelectionIndex();
            }
        });
    }

    public int getMaxSelectionIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getMaxSelectionIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getMaxSelectionIndex();
            }
        });
    }

    public int getMinSelectionIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getMinSelectionIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getMinSelectionIndex();
            }
        });
    }

    public ListModel getModel() {
        return (ListModel)this.runMapping(new Operator.MapAction("getModel"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getModel();
            }
        });
    }

    public Dimension getPreferredScrollableViewportSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getPreferredScrollableViewportSize"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getPreferredScrollableViewportSize();
            }
        });
    }

    public Object getPrototypeCellValue() {
        return this.runMapping(new Operator.MapAction("getPrototypeCellValue"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getPrototypeCellValue();
            }
        });
    }

    public int getScrollableBlockIncrement(final Rectangle rectangle, final int n, final int n2) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableBlockIncrement"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getScrollableBlockIncrement(rectangle, n, n2);
            }
        });
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportHeight"){

            public boolean map() {
                return ((JList)JListOperator.this.getSource()).getScrollableTracksViewportHeight();
            }
        });
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportWidth"){

            public boolean map() {
                return ((JList)JListOperator.this.getSource()).getScrollableTracksViewportWidth();
            }
        });
    }

    public int getScrollableUnitIncrement(final Rectangle rectangle, final int n, final int n2) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableUnitIncrement"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getScrollableUnitIncrement(rectangle, n, n2);
            }
        });
    }

    public int getSelectedIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getSelectedIndex();
            }
        });
    }

    public int[] getSelectedIndices() {
        return (int[])this.runMapping(new Operator.MapAction("getSelectedIndices"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getSelectedIndices();
            }
        });
    }

    public Object getSelectedValue() {
        return this.runMapping(new Operator.MapAction("getSelectedValue"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getSelectedValue();
            }
        });
    }

    public Object[] getSelectedValues() {
        return (Object[])this.runMapping(new Operator.MapAction("getSelectedValues"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getSelectedValues();
            }
        });
    }

    public Color getSelectionBackground() {
        return (Color)this.runMapping(new Operator.MapAction("getSelectionBackground"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getSelectionBackground();
            }
        });
    }

    public Color getSelectionForeground() {
        return (Color)this.runMapping(new Operator.MapAction("getSelectionForeground"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getSelectionForeground();
            }
        });
    }

    public int getSelectionMode() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectionMode"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getSelectionMode();
            }
        });
    }

    public ListSelectionModel getSelectionModel() {
        return (ListSelectionModel)this.runMapping(new Operator.MapAction("getSelectionModel"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getSelectionModel();
            }
        });
    }

    public ListUI getUI() {
        return (ListUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).getUI();
            }
        });
    }

    public boolean getValueIsAdjusting() {
        return this.runMapping(new Operator.MapBooleanAction("getValueIsAdjusting"){

            public boolean map() {
                return ((JList)JListOperator.this.getSource()).getValueIsAdjusting();
            }
        });
    }

    public int getVisibleRowCount() {
        return this.runMapping(new Operator.MapIntegerAction("getVisibleRowCount"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).getVisibleRowCount();
            }
        });
    }

    public Point indexToLocation(final int n) {
        return (Point)this.runMapping(new Operator.MapAction("indexToLocation"){

            public Object map() {
                return ((JList)JListOperator.this.getSource()).indexToLocation(n);
            }
        });
    }

    public boolean isSelectedIndex(final int n) {
        return this.runMapping(new Operator.MapBooleanAction("isSelectedIndex"){

            public boolean map() {
                return ((JList)JListOperator.this.getSource()).isSelectedIndex(n);
            }
        });
    }

    public boolean isSelectionEmpty() {
        return this.runMapping(new Operator.MapBooleanAction("isSelectionEmpty"){

            public boolean map() {
                return ((JList)JListOperator.this.getSource()).isSelectionEmpty();
            }
        });
    }

    public int locationToIndex(final Point point) {
        return this.runMapping(new Operator.MapIntegerAction("locationToIndex"){

            public int map() {
                return ((JList)JListOperator.this.getSource()).locationToIndex(point);
            }
        });
    }

    public void removeListSelectionListener(final ListSelectionListener listSelectionListener) {
        this.runMapping(new Operator.MapVoidAction("removeListSelectionListener"){

            public void map() {
                ((JList)JListOperator.this.getSource()).removeListSelectionListener(listSelectionListener);
            }
        });
    }

    public void removeSelectionInterval(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("removeSelectionInterval"){

            public void map() {
                ((JList)JListOperator.this.getSource()).removeSelectionInterval(n, n2);
            }
        });
    }

    public void setCellRenderer(final ListCellRenderer listCellRenderer) {
        this.runMapping(new Operator.MapVoidAction("setCellRenderer"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setCellRenderer(listCellRenderer);
            }
        });
    }

    public void setFixedCellHeight(final int n) {
        this.runMapping(new Operator.MapVoidAction("setFixedCellHeight"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setFixedCellHeight(n);
            }
        });
    }

    public void setFixedCellWidth(final int n) {
        this.runMapping(new Operator.MapVoidAction("setFixedCellWidth"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setFixedCellWidth(n);
            }
        });
    }

    public void setListData(final Vector vector) {
        this.runMapping(new Operator.MapVoidAction("setListData"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setListData(vector);
            }
        });
    }

    public void setListData(final Object[] objectArray) {
        this.runMapping(new Operator.MapVoidAction("setListData"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setListData(objectArray);
            }
        });
    }

    public void setModel(final ListModel listModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setModel(listModel);
            }
        });
    }

    public void setPrototypeCellValue(final Object object) {
        this.runMapping(new Operator.MapVoidAction("setPrototypeCellValue"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setPrototypeCellValue(object);
            }
        });
    }

    public void setSelectedIndex(final int n) {
        this.runMapping(new Operator.MapVoidAction("setSelectedIndex"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectedIndex(n);
            }
        });
    }

    public void setSelectedIndices(final int[] nArray) {
        this.runMapping(new Operator.MapVoidAction("setSelectedIndices"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectedIndices(nArray);
            }
        });
    }

    public void setSelectedValue(final Object object, final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setSelectedValue"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectedValue(object, bl);
            }
        });
    }

    public void setSelectionBackground(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setSelectionBackground"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectionBackground(color);
            }
        });
    }

    public void setSelectionForeground(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setSelectionForeground"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectionForeground(color);
            }
        });
    }

    public void setSelectionInterval(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("setSelectionInterval"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectionInterval(n, n2);
            }
        });
    }

    public void setSelectionMode(final int n) {
        this.runMapping(new Operator.MapVoidAction("setSelectionMode"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectionMode(n);
            }
        });
    }

    public void setSelectionModel(final ListSelectionModel listSelectionModel) {
        this.runMapping(new Operator.MapVoidAction("setSelectionModel"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setSelectionModel(listSelectionModel);
            }
        });
    }

    public void setUI(final ListUI listUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setUI(listUI);
            }
        });
    }

    public void setValueIsAdjusting(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setValueIsAdjusting"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setValueIsAdjusting(bl);
            }
        });
    }

    public void setVisibleRowCount(final int n) {
        this.runMapping(new Operator.MapVoidAction("setVisibleRowCount"){

            public void map() {
                ((JList)JListOperator.this.getSource()).setVisibleRowCount(n);
            }
        });
    }

    private void checkIndex(int n) {
        if (n < 0 || n >= this.getModel().getSize()) {
            throw new NoSuchItemException(n);
        }
    }

    private void checkIndices(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.checkIndex(nArray[i]);
        }
    }

    public static class JListFinder
    extends Operator.Finder {
        public JListFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JList == null ? (class$javax$swing$JList = JListOperator.class$("javax.swing.JList")) : class$javax$swing$JList, componentChooser);
        }

        public JListFinder() {
            super(class$javax$swing$JList == null ? (class$javax$swing$JList = JListOperator.class$("javax.swing.JList")) : class$javax$swing$JList);
        }
    }

    public static class JListByItemFinder
    implements ComponentChooser {
        String label;
        int itemIndex;
        Operator.StringComparator comparator;

        public JListByItemFinder(String string, int n, Operator.StringComparator stringComparator) {
            this.label = string;
            this.itemIndex = n;
            this.comparator = stringComparator;
        }

        public JListByItemFinder(String string, int n) {
            this(string, n, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof JList) {
                if (this.label == null) {
                    return true;
                }
                if (((JList)component).getModel().getSize() > this.itemIndex) {
                    int n = this.itemIndex;
                    if (n == -1 && (n = ((JList)component).getSelectedIndex()) == -1) {
                        return false;
                    }
                    return this.comparator.equals(((JList)component).getModel().getElementAt(n).toString(), this.label);
                }
            }
            return false;
        }

        public String getDescription() {
            return "JList with text \"" + this.label + "\" in " + new Integer(this.itemIndex).toString() + "'th item";
        }
    }

    private class ByRenderedComponentListItemChooser
    implements ListItemChooser {
        ComponentChooser chooser;

        public ByRenderedComponentListItemChooser(ComponentChooser componentChooser) {
            this.chooser = componentChooser;
        }

        public boolean checkItem(JListOperator jListOperator, int n) {
            return this.chooser.checkComponent(jListOperator.getRenderedComponent(n));
        }

        public String getDescription() {
            return this.chooser.getDescription();
        }
    }

    private class BySubStringListItemChooser
    implements ListItemChooser {
        String subString;
        Operator.StringComparator comparator;

        public BySubStringListItemChooser(String string, Operator.StringComparator stringComparator) {
            this.subString = string;
            this.comparator = stringComparator;
        }

        public boolean checkItem(JListOperator jListOperator, int n) {
            return this.comparator.equals(jListOperator.getModel().getElementAt(n).toString(), this.subString);
        }

        public String getDescription() {
            return "Item containing \"" + this.subString + "\" string";
        }
    }

    public class NoSuchItemException
    extends JemmyInputException {
        public NoSuchItemException(String string) {
            super("No such item as \"" + string + "\"", JListOperator.this.getSource());
        }

        public NoSuchItemException(int n) {
            super("List does not contain " + n + "'th item", JListOperator.this.getSource());
        }
    }

    public static interface ListItemChooser {
        public boolean checkItem(JListOperator var1, int var2);

        public String getDescription();
    }
}

