/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyInputException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JInternalFrameOperator;
import org.netbeans.jemmy.operators.JScrollPaneOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.WindowOperator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class DefaultVisualizer
implements Operator.ComponentVisualizer,
Cloneable {
    private boolean window = true;
    private boolean internalFrame = true;
    private boolean scroll = false;
    private boolean switchTab = false;
    private boolean modal = false;

    public void checkForModal(boolean bl) {
        this.modal = bl;
    }

    public void activateWindow(boolean bl) {
        this.window = bl;
    }

    public void activateInternalFrame(boolean bl) {
        this.internalFrame = bl;
    }

    public void scroll(boolean bl) {
        this.scroll = bl;
    }

    public void switchTab(boolean bl) {
        this.switchTab = bl;
    }

    protected boolean isWindowActive(WindowOperator windowOperator) {
        return windowOperator.isFocused() && windowOperator.isActive();
    }

    protected void makeWindowActive(WindowOperator windowOperator) {
        windowOperator.activate();
    }

    protected void activate(WindowOperator windowOperator) {
        boolean bl = this.isWindowActive(windowOperator);
        windowOperator.toFront();
        if (!bl) {
            this.makeWindowActive(windowOperator);
        }
    }

    protected void initInternalFrame(JInternalFrameOperator jInternalFrameOperator) {
        if (!jInternalFrameOperator.isSelected()) {
            jInternalFrameOperator.activate();
        }
    }

    protected void scroll(JScrollPaneOperator jScrollPaneOperator, Component component) {
        if (!jScrollPaneOperator.checkInside(component)) {
            jScrollPaneOperator.scrollToComponent(component);
        }
    }

    protected void switchTab(JTabbedPaneOperator jTabbedPaneOperator, Component component) {
        int n = 0;
        for (int i = 0; i < jTabbedPaneOperator.getTabCount(); ++i) {
            if (component != jTabbedPaneOperator.getComponentAt(i)) continue;
            n = i;
            break;
        }
        if (jTabbedPaneOperator.getSelectedIndex() != n) {
            jTabbedPaneOperator.selectPage(n);
        }
    }

    public void makeVisible(ComponentOperator componentOperator) {
        try {
            Object object;
            if (this.modal && (object = JDialogOperator.getTopModalDialog()) != null && componentOperator.getWindow() != object) {
                throw new JemmyInputException("Component is not on top modal dialog.", componentOperator.getSource());
            }
            object = new WindowOperator(componentOperator.getWindow());
            if (this.window) {
                ((WindowOperator)object).copyEnvironment(componentOperator);
                ((Operator)object).setVisualizer(new EmptyVisualizer());
                this.activate((WindowOperator)object);
            }
            if (this.internalFrame && componentOperator instanceof JInternalFrameOperator) {
                this.initInternalFrame((JInternalFrameOperator)componentOperator);
            }
            Container[] containerArray = componentOperator.getContainers();
            for (int i = containerArray.length - 1; i >= 0; --i) {
                JComponentOperator jComponentOperator;
                if (this.internalFrame && containerArray[i] instanceof JInternalFrame) {
                    jComponentOperator = new JInternalFrameOperator((JInternalFrame)containerArray[i]);
                    jComponentOperator.copyEnvironment(componentOperator);
                    jComponentOperator.setVisualizer(new EmptyVisualizer());
                    this.initInternalFrame((JInternalFrameOperator)jComponentOperator);
                    continue;
                }
                if (this.scroll && containerArray[i] instanceof JScrollPane) {
                    jComponentOperator = new JScrollPaneOperator((JScrollPane)containerArray[i]);
                    jComponentOperator.copyEnvironment(componentOperator);
                    jComponentOperator.setVisualizer(new EmptyVisualizer());
                    this.scroll((JScrollPaneOperator)jComponentOperator, componentOperator.getSource());
                    continue;
                }
                if (!this.switchTab || !(containerArray[i] instanceof JTabbedPane)) continue;
                jComponentOperator = new JTabbedPaneOperator((JTabbedPane)containerArray[i]);
                ((JTabbedPaneOperator)jComponentOperator).copyEnvironment(componentOperator);
                jComponentOperator.setVisualizer(new EmptyVisualizer());
                this.switchTab((JTabbedPaneOperator)jComponentOperator, i == 0 ? componentOperator.getSource() : containerArray[i - 1]);
            }
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            JemmyProperties.getProperties().getOutput().printStackTrace(timeoutExpiredException);
        }
    }

    public DefaultVisualizer cloneThis() {
        try {
            return (DefaultVisualizer)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new JemmyException("Even impossible happens :)", cloneNotSupportedException);
        }
    }
}

