/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.input.MouseRobotDriver;
import org.netbeans.jemmy.operators.WindowOperator;
import org.netbeans.jemmy.util.DefaultVisualizer;

public class MouseVisualizer
extends DefaultVisualizer {
    private static final long BEFORE_CLICK = 100L;
    public static int TOP = 0;
    public static int BOTTOM = 1;
    public static int LEFT = 2;
    public static int RIGHT = 3;
    private int place = 0;
    private double pointLocation = 0.0;
    private int depth = 0;
    private boolean checkMouse = false;

    public MouseVisualizer() {
    }

    public MouseVisualizer(int n, double d, int n2, boolean bl) {
        this.place = n;
        this.pointLocation = d;
        this.depth = n2;
        this.checkMouse = bl;
    }

    protected boolean isWindowActive(WindowOperator windowOperator) {
        return super.isWindowActive(windowOperator) && (windowOperator.getSource() instanceof Frame || windowOperator.getSource() instanceof Dialog);
    }

    protected void makeWindowActive(WindowOperator windowOperator) {
        JemmyProperties.getCurrentTimeouts().create("MouseVisualiser.BeforeClickTimeout").sleep();
        super.makeWindowActive(windowOperator);
        if (!System.getProperty("java.version").startsWith("1.2")) {
            Point point = this.getClickPoint(windowOperator);
            new MouseRobotDriver(windowOperator.getTimeouts().create("EventDispatcher.RobotAutoDelay")).clickMouse(windowOperator, point.x, point.y, 1, windowOperator.getDefaultMouseButton(), 0, windowOperator.getTimeouts().create("ComponentOperator.MouseClickTimeout"));
        }
    }

    private Point getClickPoint(WindowOperator windowOperator) {
        int n;
        int n2;
        if (this.place == LEFT || this.place == RIGHT) {
            n2 = (int)((double)windowOperator.getHeight() * this.pointLocation - 1.0);
            n = this.place == RIGHT ? windowOperator.getWidth() - 1 - this.depth : this.depth;
        } else {
            n = (int)((double)windowOperator.getWidth() * this.pointLocation - 1.0);
            n2 = this.place == BOTTOM ? windowOperator.getHeight() - 1 - this.depth : this.depth;
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= windowOperator.getWidth()) {
            n = windowOperator.getWidth() - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= windowOperator.getHeight()) {
            n2 = windowOperator.getHeight() - 1;
        }
        return new Point(n, n2);
    }

    static {
        Timeouts.initDefault("MouseVisualiser.BeforeClickTimeout", 100L);
    }
}

