/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.netbeans.jemmy.JemmyException;

public class PNGDecoder {
    InputStream in;

    public PNGDecoder(InputStream inputStream) {
        this.in = inputStream;
    }

    byte read() throws IOException {
        byte by = (byte)this.in.read();
        return by;
    }

    int readInt() throws IOException {
        byte[] byArray = this.read(4);
        return ((byArray[0] & 0xFF) << 24) + ((byArray[1] & 0xFF) << 16) + ((byArray[2] & 0xFF) << 8) + (byArray[3] & 0xFF);
    }

    byte[] read(int n) throws IOException {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.read();
        }
        return byArray;
    }

    boolean compare(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    void checkEquality(byte[] byArray, byte[] byArray2) {
        if (!this.compare(byArray, byArray2)) {
            throw new JemmyException("Format error");
        }
    }

    public BufferedImage decode() throws IOException {
        int n;
        byte[] byArray = this.read(12);
        this.checkEquality(byArray, new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13});
        byte[] byArray2 = this.read(4);
        this.checkEquality(byArray2, "IHDR".getBytes());
        int n2 = this.readInt();
        int n3 = this.readInt();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        byte[] byArray3 = this.read(5);
        if (this.compare(byArray3, new byte[]{1, 0, 0, 0, 0})) {
            n = 0;
        } else if (this.compare(byArray3, new byte[]{8, 0, 0, 0, 0})) {
            n = 1;
        } else if (this.compare(byArray3, new byte[]{8, 2, 0, 0, 0})) {
            n = 2;
        } else {
            throw new JemmyException("Format error");
        }
        this.readInt();
        int n4 = this.readInt();
        byte[] byArray4 = this.read(4);
        this.checkEquality(byArray4, "IDAT".getBytes());
        byte[] byArray5 = this.read(n4);
        Inflater inflater = new Inflater();
        inflater.setInput(byArray5, 0, n4);
        try {
            switch (n) {
                case 0: {
                    int n5 = n2 / 8;
                    if (n2 % 8 != 0) {
                        ++n5;
                    }
                    byte[] byArray6 = new byte[n5];
                    for (int i = 0; i < n3; ++i) {
                        inflater.inflate(new byte[1]);
                        inflater.inflate(byArray6);
                        for (int j = 0; j < n5; ++j) {
                            byte by = byArray6[j];
                            for (int k = 0; k < 8 && j * 8 + k < n2; ++k) {
                                if ((by & 0x80) == 128) {
                                    bufferedImage.setRGB(j * 8 + k, i, Color.white.getRGB());
                                } else {
                                    bufferedImage.setRGB(j * 8 + k, i, Color.black.getRGB());
                                }
                                by = (byte)(by << 1);
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    byte[] byArray7 = new byte[n2];
                    for (int i = 0; i < n3; ++i) {
                        inflater.inflate(new byte[1]);
                        inflater.inflate(byArray7);
                        for (int j = 0; j < n2; ++j) {
                            byte by = byArray7[j];
                            bufferedImage.setRGB(j, i, (by << 16) + (by << 8) + by);
                        }
                    }
                    break;
                }
                case 2: {
                    byte[] byArray8 = new byte[n2 * 3];
                    for (int i = 0; i < n3; ++i) {
                        inflater.inflate(new byte[1]);
                        inflater.inflate(byArray8);
                        for (int j = 0; j < n2; ++j) {
                            bufferedImage.setRGB(j, i, ((byArray8[j * 3 + 0] & 0xFF) << 16) + ((byArray8[j * 3 + 1] & 0xFF) << 8) + (byArray8[j * 3 + 2] & 0xFF));
                        }
                    }
                    break;
                }
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new JemmyException("ZIP error", dataFormatException);
        }
        this.readInt();
        this.readInt();
        byte[] byArray9 = this.read(4);
        this.checkEquality(byArray9, "IEND".getBytes());
        this.readInt();
        this.in.close();
        return bufferedImage;
    }

    public static BufferedImage decode(String string) {
        try {
            return new PNGDecoder(new FileInputStream(string)).decode();
        }
        catch (IOException iOException) {
            throw new JemmyException("IOException during image reading", iOException);
        }
    }
}

