/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PNGEncoder {
    public static final byte BW_MODE = 0;
    public static final byte GREYSCALE_MODE = 1;
    public static final byte COLOR_MODE = 2;
    OutputStream out;
    CRC32 crc = new CRC32();
    byte mode;

    public PNGEncoder(OutputStream outputStream) {
        this(outputStream, 1);
    }

    public PNGEncoder(OutputStream outputStream, byte by) {
        this.out = outputStream;
        if (by < 0 || by > 2) {
            throw new IllegalArgumentException("Unknown color mode");
        }
        this.mode = by;
    }

    void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        this.write(byArray);
    }

    void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
        this.crc.update(byArray);
    }

    public void encode(BufferedImage bufferedImage) throws IOException {
        int n = bufferedImage.getWidth(null);
        int n2 = bufferedImage.getHeight(null);
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13};
        this.write(byArray);
        this.crc.reset();
        this.write("IHDR".getBytes());
        this.write(n);
        this.write(n2);
        byte[] byArray2 = null;
        switch (this.mode) {
            case 0: {
                byArray2 = new byte[]{1, 0, 0, 0, 0};
                break;
            }
            case 1: {
                byArray2 = new byte[]{8, 0, 0, 0, 0};
                break;
            }
            case 2: {
                byArray2 = new byte[]{8, 2, 0, 0, 0};
            }
        }
        this.write(byArray2);
        this.write((int)this.crc.getValue());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(65536);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(9)));
        switch (this.mode) {
            case 0: {
                int n3 = n % 8;
                int n4 = n / 8;
                for (int i = 0; i < n2; ++i) {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    bufferedOutputStream.write(0);
                    for (n8 = 0; n8 < n4; ++n8) {
                        n7 = 0;
                        for (int j = 0; j < 8; ++j) {
                            n6 = bufferedImage.getRGB(n8 * 8 + j, i);
                            n5 = n6 >> 16 & 0xFF;
                            n5 += n6 >> 8 & 0xFF;
                            n7 <<= 1;
                            if ((n5 += n6 & 0xFF) < 384) continue;
                            n7 |= 1;
                        }
                        bufferedOutputStream.write((byte)n7);
                    }
                    if (n3 <= 0) continue;
                    n7 = 0;
                    for (n8 = 0; n8 < n % 8; ++n8) {
                        n6 = bufferedImage.getRGB(n4 * 8 + n8, i);
                        n5 = n6 >> 16 & 0xFF;
                        n5 += n6 >> 8 & 0xFF;
                        n7 <<= 1;
                        if ((n5 += n6 & 0xFF) < 384) continue;
                        n7 |= 1;
                    }
                    bufferedOutputStream.write((byte)(n7 <<= 8 - n3));
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n2; ++i) {
                    bufferedOutputStream.write(0);
                    for (int j = 0; j < n; ++j) {
                        int n9 = bufferedImage.getRGB(j, i);
                        int n10 = n9 >> 16 & 0xFF;
                        n10 += n9 >> 8 & 0xFF;
                        bufferedOutputStream.write((byte)((n10 += n9 & 0xFF) / 3));
                    }
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    bufferedOutputStream.write(0);
                    for (int j = 0; j < n; ++j) {
                        int n11 = bufferedImage.getRGB(j, i);
                        bufferedOutputStream.write((byte)(n11 >> 16 & 0xFF));
                        bufferedOutputStream.write((byte)(n11 >> 8 & 0xFF));
                        bufferedOutputStream.write((byte)(n11 & 0xFF));
                    }
                }
                break;
            }
        }
        bufferedOutputStream.close();
        this.write(byteArrayOutputStream.size());
        this.crc.reset();
        this.write("IDAT".getBytes());
        this.write(byteArrayOutputStream.toByteArray());
        this.write((int)this.crc.getValue());
        this.write(0);
        this.crc.reset();
        this.write("IEND".getBytes());
        this.write((int)this.crc.getValue());
        this.out.close();
    }

    public static void captureScreen(Rectangle rectangle, String string) {
        PNGEncoder.captureScreen(rectangle, string, (byte)1);
    }

    public static void captureScreen(Rectangle rectangle, String string, byte by) {
        try {
            BufferedImage bufferedImage = new Robot().createScreenCapture(rectangle);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            PNGEncoder pNGEncoder = new PNGEncoder(bufferedOutputStream, by);
            pNGEncoder.encode(bufferedImage);
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void captureScreen(Component component, String string) {
        PNGEncoder.captureScreen(component, string, (byte)1);
    }

    public static void captureScreen(Component component, String string, byte by) {
        PNGEncoder.captureScreen(new Rectangle(component.getLocationOnScreen(), component.getSize()), string, by);
    }

    public static void captureScreen(String string) {
        PNGEncoder.captureScreen(string, (byte)1);
    }

    public static void captureScreen(String string, byte by) {
        PNGEncoder.captureScreen(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()), string, by);
    }
}

