/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;

public class PropChooser
implements ComponentChooser,
Outputable {
    protected String[] propNames;
    protected Object[][] params;
    protected Class[][] classes;
    protected Object[] results;
    private TestOut output;

    public PropChooser(String[] stringArray, Object[][] objectArray, Class[][] classArray, Object[] objectArray2) {
        this.propNames = stringArray;
        this.results = objectArray2;
        this.params = objectArray != null ? objectArray : new Object[stringArray.length][0];
        if (classArray != null) {
            this.classes = classArray;
        } else {
            this.classes = new Class[this.params.length][0];
            for (int i = 0; i < this.params.length; ++i) {
                Class[] classArray2 = new Class[this.params[i].length];
                for (int j = 0; j < this.params[i].length; ++j) {
                    classArray2[j] = this.params[i][j].getClass();
                }
                this.classes[i] = classArray2;
            }
        }
        this.setOutput(JemmyProperties.getCurrentOutput());
    }

    public PropChooser(String[] stringArray, Object[] objectArray) {
        this(stringArray, null, null, objectArray);
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public boolean checkComponent(Component component) {
        try {
            String string = null;
            ClassReference classReference = new ClassReference(component);
            for (int i = 0; i < this.propNames.length; ++i) {
                Object object;
                string = this.propNames[i];
                if (string == null) continue;
                if (this.isField(component, string, this.classes[i])) {
                    try {
                        object = classReference.getField(string);
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.output.printStackTrace(illegalStateException);
                        return false;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        this.output.printStackTrace(noSuchFieldException);
                        return false;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.output.printStackTrace(illegalAccessException);
                        return false;
                    }
                }
                try {
                    object = classReference.invokeMethod(string, this.params[i], this.classes[i]);
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.output.printStackTrace(invocationTargetException);
                    return false;
                }
                catch (IllegalStateException illegalStateException) {
                    this.output.printStackTrace(illegalStateException);
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.output.printStackTrace(noSuchMethodException);
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.output.printStackTrace(illegalAccessException);
                    return false;
                }
                if (this.checkProperty(object, this.results[i])) continue;
                return false;
            }
            return true;
        }
        catch (SecurityException securityException) {
            this.output.printStackTrace(securityException);
            return false;
        }
    }

    public String getDescription() {
        String string = "";
        for (int i = 0; i < this.propNames.length; ++i) {
            string = string + " " + this.propNames[i];
        }
        return "Component by properties array\n    :" + string;
    }

    protected boolean checkProperty(Object object, Object object2) {
        return object.equals(object2);
    }

    private boolean isField(Component component, String string, Class[] classArray) throws SecurityException {
        try {
            component.getClass().getField(string);
            component.getClass().getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return true;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
        return true;
    }
}

