/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.SessionId;

public class ConversionUtils {
    private ConversionUtils() {
    }

    private static SessionId toSessionId(Session session) {
        return session != null ? (SessionId)session.lookupFirst(null, SessionId.class) : null;
    }

    private static SessionId toSessionId(DebuggerEngine debuggerEngine) {
        return debuggerEngine != null ? (SessionId)debuggerEngine.lookupFirst(null, SessionId.class) : null;
    }

    private static DebugSession toDebugSession(DebuggerEngine debuggerEngine) {
        return debuggerEngine != null ? (DebugSession)debuggerEngine.lookupFirst(null, DebugSession.class) : null;
    }

    public static DebugSession toDebugSession(SessionId sessionId) {
        DebuggerEngine[] debuggerEngineArray;
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        DebugSession debugSession = ConversionUtils.toDebugSession(debuggerEngine);
        if (debugSession != null && sessionId.equals(debugSession.getSessionId())) {
            return debugSession;
        }
        for (DebuggerEngine debuggerEngine2 : debuggerEngineArray = DebuggerManager.getDebuggerManager().getDebuggerEngines()) {
            DebugSession debugSession2 = ConversionUtils.toDebugSession(debuggerEngine2);
            if (debugSession2 == null || !sessionId.equals(debugSession2.getSessionId())) continue;
            return debugSession2;
        }
        return null;
    }

    public static DebugSession toDebugSession(Session session) {
        return ConversionUtils.toDebugSession(session.getCurrentEngine());
    }

    private static Session toSession(DebuggerEngine debuggerEngine) {
        SessionId sessionId = ConversionUtils.toSessionId(debuggerEngine);
        return ConversionUtils.toSession(sessionId);
    }

    public static Session toSession(DebugSession debugSession) {
        return ConversionUtils.toSession(debugSession.getSessionId());
    }

    public static Session toSession(SessionId sessionId) {
        Session[] sessionArray;
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        DebugSession debugSession = ConversionUtils.toDebugSession(session);
        if (debugSession != null && sessionId.equals(debugSession.getSessionId())) {
            return session;
        }
        for (Session session2 : sessionArray = DebuggerManager.getDebuggerManager().getSessions()) {
            DebugSession debugSession2 = ConversionUtils.toDebugSession(session2);
            if (debugSession2 == null || !sessionId.equals(debugSession2.getSessionId())) continue;
            return session2;
        }
        return null;
    }
}

