/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.dbgp.ConnectionErrMessage;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.DebuggerOptions;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionProgress;
import org.netbeans.modules.php.dbgp.StartActionProviderImpl;
import org.netbeans.modules.php.project.api.PhpProjectUtils;
import org.netbeans.modules.php.project.spi.XDebugStarter;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggerImpl
implements XDebugStarter {
    static String ID = "netbeans-PHP-DBGP-DebugInfo";
    static String SESSION_ID = "netbeans-PHP-DBGP-Session";
    static String ENGINE_ID = SESSION_ID + "/" + "PHP-Engine";

    public void start(Project project, Callable<Cancellable> callable, FileObject fileObject, boolean bl) {
        assert (fileObject != null);
        SessionId sessionId = this.getSessionId(project);
        if (sessionId == null) {
            sessionId = new SessionId(fileObject);
            DebuggerOptions debuggerOptions = new DebuggerOptions();
            debuggerOptions.debugForFirstPageOnly = bl;
            this.debug(sessionId, debuggerOptions, callable);
            long l = System.currentTimeMillis();
            String string = sessionId.waitServerFile(true);
            if (string == null) {
                ConnectionErrMessage.showMe((int)(System.currentTimeMillis() - l) / 1000);
                return;
            }
        }
    }

    public void stop() {
        SessionProgress sessionProgress;
        Session session = this.getPhpSession();
        if (session != null && (sessionProgress = SessionProgress.forSession(session)) != null) {
            sessionProgress.cancel();
        }
    }

    public boolean isAlreadyRunning() {
        return this.getPhpSession() != null;
    }

    private Session getPhpSession() {
        Session[] sessionArray;
        for (Session session : sessionArray = DebuggerManager.getDebuggerManager().getSessions()) {
            Project project;
            SessionId sessionId = (SessionId)session.lookupFirst(null, SessionId.class);
            if (sessionId == null || (project = sessionId.getProject()) == null || !PhpProjectUtils.isPhpProject((Project)project)) continue;
            return session;
        }
        return null;
    }

    private SessionId getSessionId(Project project) {
        Session[] sessionArray;
        for (Session session : sessionArray = DebuggerManager.getDebuggerManager().getSessions()) {
            Project project2;
            SessionId sessionId = (SessionId)session.lookupFirst(null, SessionId.class);
            if (sessionId == null || !project.equals(project2 = sessionId.getProject())) continue;
            return sessionId;
        }
        return null;
    }

    public Semaphore debug(SessionId sessionId, DebuggerOptions debuggerOptions, Callable<Cancellable> callable) {
        DebugSession debugSession = new DebugSession(debuggerOptions);
        DebuggerInfo debuggerInfo = DebuggerInfo.create((String)ID, (Object[])new Object[]{sessionId, debugSession});
        DebuggerEngine[] debuggerEngineArray = DebuggerManager.getDebuggerManager().startDebugging(debuggerInfo);
        return StartActionProviderImpl.getInstance().start(debugSession, callable);
    }
}

