/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.io.IOException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.ConversionUtils;
import org.netbeans.modules.php.dbgp.DbgpEngineProvider;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.DebuggerOptions;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.models.ThreadsModel;
import org.netbeans.modules.php.dbgp.packets.StatusCommand;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartActionProviderImpl {
    private static final String LOCALHOST = "localhost";
    private static final int PORT_RANGE = 100;
    private static final int TIMEOUT = 60000;
    private static final String PORT_OCCUPIED = "MSG_PortOccupied";
    private AtomicReference<Future<Cancellable>> refForFutureCancel;
    private ServerThread myThread;
    private Set<DebugSession> mySessions = new HashSet<DebugSession>();
    private Map<Session, DebugSession> myCurrentSessions = new WeakHashMap<Session, DebugSession>();
    private static final StartActionProviderImpl INSTANCE = new StartActionProviderImpl();

    private StartActionProviderImpl() {
        this.refForFutureCancel = new AtomicReference<Object>(null);
    }

    public static StartActionProviderImpl getInstance() {
        return INSTANCE;
    }

    public synchronized Semaphore start(DebugSession debugSession) {
        return this.start(debugSession, null);
    }

    public synchronized Semaphore start(DebugSession debugSession, Callable<Cancellable> callable) {
        int n = debugSession.getOptions().getPort();
        this.myThread = new ServerThread(n, debugSession.getSessionId());
        RequestProcessor.getDefault().post((Runnable)this.myThread);
        if (callable != null) {
            this.refForFutureCancel.set(Executors.newSingleThreadExecutor().submit(callable));
        }
        return this.myThread.getSemaphore();
    }

    public synchronized DebugSession getSessionById(String string) {
        for (DebugSession debugSession : this.mySessions) {
            String string2;
            SessionId sessionId = debugSession.getSessionId();
            if (sessionId == null || !string.equals(string2 = sessionId.getId())) continue;
            return debugSession;
        }
        return null;
    }

    public synchronized DebugSession getCurrentSession(SessionId sessionId) {
        if (sessionId == null) {
            return null;
        }
        return ConversionUtils.toDebugSession(sessionId);
    }

    public synchronized Collection<DebugSession> getSessions(SessionId sessionId) {
        LinkedList<DebugSession> linkedList = new LinkedList<DebugSession>();
        for (DebugSession debugSession : this.mySessions) {
            if (!sessionId.equals(debugSession.getSessionId())) continue;
            linkedList.add(debugSession);
        }
        return linkedList;
    }

    public synchronized void stop(Session session) {
        Object object;
        Object object2;
        try {
            object2 = this.refForFutureCancel.get();
            Object object3 = object = object2 != null ? object2.get() : null;
            if (object != null) {
                object.cancel();
            }
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException);
        }
        this.refForFutureCancel = new AtomicReference<Object>(null);
        object2 = (SessionId)session.lookupFirst(null, SessionId.class);
        object = new ArrayList<DebugSession>(this.mySessions);
        Session[] sessionArray = object.iterator();
        while (sessionArray.hasNext()) {
            DebugSession debugSession = (DebugSession)sessionArray.next();
            if (debugSession.getSessionId() != object2) continue;
            debugSession.stop();
            this.mySessions.remove(debugSession);
        }
        sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        boolean bl = true;
        for (Session session2 : sessionArray) {
            if (session2.equals(session) || session2.lookupFirst(null, SessionId.class) == null) continue;
            bl = false;
        }
        if (bl) {
            this.myThread.stop();
        }
        this.stopEngines(session);
    }

    public synchronized void setCurrentSession(Session session, DebugSession debugSession) {
        this.myCurrentSessions.put(session, debugSession);
    }

    synchronized void attachDebugSession(Session session, DebugSession debugSession) {
        this.myCurrentSessions.put(session, debugSession);
        DebugSession.IDESessionBridge iDESessionBridge = debugSession.getBridge();
        if (iDESessionBridge != null) {
            iDESessionBridge.hideAnnotations();
            iDESessionBridge.setSuspended(false);
            ThreadsModel threadsModel = iDESessionBridge.getThreadsModel();
            if (threadsModel != null) {
                threadsModel.update();
            }
        }
    }

    synchronized void removeSession(DebugSession debugSession) {
        Collection<DebugSession> collection;
        SessionId sessionId = debugSession.getSessionId();
        this.mySessions.remove(debugSession);
        if (sessionId != null && (collection = this.getSessions(sessionId)).size() > 0) {
            DebugSession.IDESessionBridge iDESessionBridge = debugSession.getBridge();
            DebuggerEngine debuggerEngine = iDESessionBridge != null ? iDESessionBridge.getEngine() : null;
            Session session = debuggerEngine != null ? (Session)debuggerEngine.lookupFirst(null, Session.class) : null;
            DebugSession debugSession2 = collection.iterator().next();
            this.setCurrentSession(session, debugSession2);
            StatusCommand statusCommand = new StatusCommand(debugSession2.getTransactionId());
            debugSession2.sendCommandLater(statusCommand);
        }
    }

    private synchronized void setupCurrentSession(DebugSession debugSession) {
        this.mySessions.add(debugSession);
    }

    private void stopEngines(Session session) {
        String[] stringArray;
        for (String string : stringArray = session.getSupportedLanguages()) {
            DebuggerEngine debuggerEngine = session.getEngineForLanguage(string);
            ((DbgpEngineProvider)((Object)debuggerEngine.lookupFirst(null, DebuggerEngineProvider.class))).getDestructor().killEngine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findFreePort() {
        int n;
        for (int i = n = DebuggerOptions.getGlobalInstance().getPort(); i < n + 100; ++i) {
            Object var7_6;
            Socket socket = null;
            try {
                socket = new Socket(LOCALHOST, i);
            }
            catch (ConnectException connectException) {
                int n2 = i;
                var7_6 = null;
                this.closeTestSocket(socket);
                return n2;
            }
            catch (IOException iOException) {
                try {
                    var7_6 = null;
                    this.closeTestSocket(socket);
                    continue;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    this.closeTestSocket(socket);
                    throw throwable;
                }
            }
            var7_6 = null;
            this.closeTestSocket(socket);
            continue;
        }
        return -1;
    }

    private void closeTestSocket(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ServerThread
    implements Runnable {
        private Semaphore accepting;
        private int myPort;
        private ServerSocket myServer;
        private AtomicBoolean isStopped;
        private SessionId sessionId;

        ServerThread(int n, SessionId sessionId) {
            this.sessionId = sessionId;
            this.myPort = n;
            this.isStopped = new AtomicBoolean(false);
            this.accepting = new Semaphore(1);
            this.setAcceptingState(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!this.createServer()) {
                return;
            }
            Socket socket = null;
            while (!this.isStopped()) {
                Session[] sessionArray;
                block11: {
                    if (socket == null) {
                        try {
                            try {
                                this.setAcceptingState(true);
                                socket = this.myServer.accept();
                            }
                            catch (SocketException socketException) {
                                this.log(socketException);
                                sessionArray = null;
                                this.setAcceptingState(false);
                                break block11;
                            }
                            catch (SocketTimeoutException socketTimeoutException) {
                                this.log(socketTimeoutException);
                                sessionArray = null;
                                this.setAcceptingState(false);
                                break block11;
                            }
                            catch (IOException iOException) {
                                this.log(iOException);
                                sessionArray = null;
                                this.setAcceptingState(false);
                            }
                            sessionArray = null;
                            this.setAcceptingState(false);
                        }
                        catch (Throwable throwable) {
                            sessionArray = null;
                            this.setAcceptingState(false);
                            throw throwable;
                        }
                    }
                }
                if (this.isStopped.get() || socket == null) continue;
                DebugSession debugSession = (DebugSession)DebuggerManager.getDebuggerManager().getCurrentEngine().lookupFirst(null, DebugSession.class);
                if (debugSession != null) {
                    debugSession.start(socket);
                    StartActionProviderImpl.this.setupCurrentSession(debugSession);
                    socket = null;
                    break;
                }
                Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
                for (Session session2 : sessionArray = DebuggerManager.getDebuggerManager().getSessions()) {
                    if (session2 == session) continue;
                    DebuggerManager.getDebuggerManager().setCurrentSession(session2);
                }
                this.log((Throwable)((Object)new AssertionError(socket)));
            }
            this.closeSocket();
        }

        private void log(Throwable throwable) {
            Logger.getLogger(StartActionProviderImpl.class.getName()).log(Level.FINE, null, throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean createServer() {
            StartActionProviderImpl startActionProviderImpl = StartActionProviderImpl.this;
            synchronized (startActionProviderImpl) {
                try {
                    this.myServer = new ServerSocket(this.myPort);
                    this.myServer.setSoTimeout(60000);
                }
                catch (IOException iOException) {
                    String string = NbBundle.getMessage(StartActionProviderImpl.class, (String)StartActionProviderImpl.PORT_OCCUPIED);
                    string = MessageFormat.format(string, this.myPort);
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    this.log(iOException);
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeSocket() {
            StartActionProviderImpl startActionProviderImpl = StartActionProviderImpl.this;
            synchronized (startActionProviderImpl) {
                if (this.myServer == null) {
                    return;
                }
                try {
                    if (!this.myServer.isClosed()) {
                        this.myServer.close();
                    }
                }
                catch (IOException iOException) {
                    this.log(iOException);
                }
            }
        }

        private void stop() {
            this.isStopped.set(true);
            this.closeSocket();
        }

        private boolean isStopped() {
            return this.isStopped.get();
        }

        private synchronized Semaphore getSemaphore() {
            return this.accepting;
        }

        private synchronized void setAcceptingState(boolean bl) {
            try {
                if (bl) {
                    this.getSemaphore().release();
                } else {
                    this.getSemaphore().acquire();
                }
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
        }
    }
}

