/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting;

import java.beans.Beans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.shale.remoting.Mapping;
import org.apache.shale.remoting.Mappings;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.faces.MappingsHelper;

public class XhtmlHelper {
    protected static final String PREFIX = "org.apache.shale.remoting.LINKED";
    private MappingsHelper helper = new MappingsHelper();

    public void linkJavascript(FacesContext context, UIComponent component, ResponseWriter writer, Mechanism mechanism, String resourceId) throws IOException {
        this.linkJavascript(context, component, writer, mechanism, resourceId, "text/javascript");
    }

    public void linkJavascript(FacesContext context, UIComponent component, ResponseWriter writer, Mechanism mechanism, String resourceId, String contentType) throws IOException {
        if (this.linked(context, resourceId)) {
            return;
        }
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)contentType, null);
        writer.writeURIAttribute("src", (Object)this.mapResourceId(context, mechanism, resourceId), null);
        writer.endElement("script");
        writer.write("\n");
        this.link(context, resourceId);
    }

    public void linkStylesheet(FacesContext context, UIComponent component, ResponseWriter writer, Mechanism mechanism, String resourceId) throws IOException {
        if (this.linked(context, resourceId)) {
            return;
        }
        writer.startElement("link", component);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeURIAttribute("href", (Object)this.mapResourceId(context, mechanism, resourceId), null);
        writer.endElement("link");
        writer.write("\n");
        this.link(context, resourceId);
    }

    public String mapResourceId(FacesContext context, Mechanism mechanism, String resourceId) {
        if (resourceId == null) {
            throw new IllegalArgumentException(this.resourceBundle(context).getString("xhtml.noResourceId"));
        }
        if (mechanism == null) {
            throw new IllegalArgumentException(this.resourceBundle(context).getString("xhtml.noMechanism"));
        }
        if (Beans.isDesignTime()) {
            return resourceId;
        }
        Mappings mappings = this.helper.getMappings(context);
        if (mappings == null) {
            throw new IllegalStateException(this.resourceBundle(context).getString("xhtml.noMappings"));
        }
        ArrayList list = mappings.getMappings();
        if (list == null) {
            list = new ArrayList();
        }
        Iterator instances = list.iterator();
        Mapping mapping = null;
        while (instances.hasNext()) {
            Mapping instance = (Mapping)instances.next();
            if (mechanism != instance.getMechanism()) continue;
            mapping = instance;
            break;
        }
        if (mapping == null) {
            throw new IllegalArgumentException(mechanism.toString());
        }
        return mapping.mapResourceId(context, resourceId);
    }

    protected void link(FacesContext context, String resourceId) {
        context.getExternalContext().getRequestMap().put(PREFIX + resourceId, Boolean.TRUE);
    }

    protected boolean linked(FacesContext context, String resourceId) {
        return context.getExternalContext().getRequestMap().containsKey(PREFIX + resourceId);
    }

    protected ResourceBundle resourceBundle(FacesContext context) {
        return ResourceBundle.getBundle("org.apache.shale.remoting.Bundle", context.getViewRoot().getLocale(), Thread.currentThread().getContextClassLoader());
    }
}

