/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.logger;

import org.apache.shale.remoting.logger.AbstractLogger;
import org.apache.shale.remoting.logger.Logger;

public class DefaultLogger
extends AbstractLogger {
    protected Logger logger = null;

    public DefaultLogger() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = loader.loadClass("org.apache.shale.remoting.logger.CommonsLogger");
            this.logger = (Logger)clazz.newInstance();
            return;
        }
        catch (Exception e) {
            try {
                Class<?> clazz = loader.loadClass("org.apache.shale.remoting.logger.JdkLogger");
                this.logger = (Logger)clazz.newInstance();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public boolean isTraceEnabled(String name) {
        if (this.logger != null) {
            return this.logger.isTraceEnabled(name);
        }
        return false;
    }

    public boolean isDebugEnabled(String name) {
        if (this.logger != null) {
            return this.logger.isDebugEnabled(name);
        }
        return false;
    }

    public boolean isInfoEnabled(String name) {
        if (this.logger != null) {
            return this.logger.isInfoEnabled(name);
        }
        return false;
    }

    public boolean isWarnEnabled(String name) {
        if (this.logger != null) {
            return this.logger.isWarnEnabled(name);
        }
        return false;
    }

    public boolean isErrorEnabled(String name) {
        if (this.logger != null) {
            return this.logger.isErrorEnabled(name);
        }
        return false;
    }

    public boolean isFatalEnabled(String name) {
        if (this.logger != null) {
            return this.logger.isFatalEnabled(name);
        }
        return false;
    }

    public void trace(String name, String message, Throwable exception, Object[] params) {
        if (this.logger != null) {
            this.trace(name, message, exception, params);
            return;
        }
        System.out.println("TRACE: " + this.message(message, params));
        if (exception != null) {
            exception.printStackTrace(System.out);
        }
    }

    public void debug(String name, String message, Throwable exception, Object[] params) {
        if (this.logger != null) {
            this.debug(name, message, exception, params);
            return;
        }
        System.out.println("DEBUG: " + this.message(message, params));
        if (exception != null) {
            exception.printStackTrace(System.out);
        }
    }

    public void info(String name, String message, Throwable exception, Object[] params) {
        if (this.logger != null) {
            this.info(name, message, exception, params);
            return;
        }
        System.out.println("INFO: " + this.message(message, params));
        if (exception != null) {
            exception.printStackTrace(System.out);
        }
    }

    public void warn(String name, String message, Throwable exception, Object[] params) {
        if (this.logger != null) {
            this.warn(name, message, exception, params);
            return;
        }
        System.out.println("WARN: " + this.message(message, params));
        if (exception != null) {
            exception.printStackTrace(System.out);
        }
    }

    public void error(String name, String message, Throwable exception, Object[] params) {
        if (this.logger != null) {
            this.error(name, message, exception, params);
            return;
        }
        System.out.println("ERROR: " + this.message(message, params));
        if (exception != null) {
            exception.printStackTrace(System.out);
        }
    }

    public void fatal(String name, String message, Throwable exception, Object[] params) {
        if (this.logger != null) {
            this.fatal(name, message, exception, params);
            return;
        }
        System.out.println("FATAL: " + this.message(message, params));
        if (exception != null) {
            exception.printStackTrace(System.out);
        }
    }
}

