/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.debugger.RubyDebuggerActionProvider;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpointManager;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.platform.spi.RubyDebuggerImplementation;
import org.netbeans.spi.debugger.SessionProvider;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.rubyforge.debugcommons.RubyDebugEventListener;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerFactory;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.IRubyBreakpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyDebugger
implements RubyDebuggerImplementation {
    private static final String PATH_TO_CLASSIC_DEBUG_DIR;
    private ExecutionDescriptor descriptor;
    private RubySession rubySession;

    public void describeProcess(ExecutionDescriptor executionDescriptor) {
        this.descriptor = executionDescriptor;
    }

    public boolean canDebug() {
        return !this.descriptor.getPlatform().isRubinius();
    }

    public Process debug() {
        Process process = null;
        try {
            this.rubySession = RubyDebugger.startDebugging(this.descriptor);
            if (this.rubySession != null) {
                this.rubySession.getProxy().startDebugging((IRubyBreakpoint[])RubyBreakpointManager.getBreakpoints());
                process = this.rubySession.getProxy().getDebugTarged().getProcess();
            }
        }
        catch (IOException iOException) {
            this.getFinishAction().run();
            RubyDebugger.problemOccurred(iOException);
        }
        catch (RubyDebuggerException rubyDebuggerException) {
            this.getFinishAction().run();
            RubyDebugger.problemOccurred((Exception)((Object)rubyDebuggerException));
        }
        return process;
    }

    public Runnable getFinishAction() {
        return new Runnable(){

            public void run() {
                if (RubyDebugger.this.rubySession != null) {
                    RubyDebugger.this.rubySession.getActionProvider().doAction(ActionsManager.ACTION_KILL);
                    RubyDebugger.this.rubySession = null;
                }
            }
        };
    }

    private static void problemOccurred(Exception exception) {
        Util.showWarning(NbBundle.getMessage(RubyDebugger.class, (String)"RubyDebugger.startup.problem", (Object)exception.getMessage()));
    }

    static RubySession startDebugging(ExecutionDescriptor executionDescriptor) throws IOException, RubyDebuggerException {
        RubyDebuggerProxy rubyDebuggerProxy;
        Cloneable cloneable;
        RubyPlatform rubyPlatform = executionDescriptor.getPlatform();
        boolean bl = rubyPlatform.isJRuby();
        if (!RubyDebugger.checkAndTuneSettings(executionDescriptor)) {
            return null;
        }
        RubyDebuggerFactory.Descriptor descriptor = new RubyDebuggerFactory.Descriptor();
        descriptor.useDefaultPort(false);
        descriptor.setJRuby(bl);
        descriptor.setScriptPath(executionDescriptor.getScript());
        if (executionDescriptor.useInterpreter()) {
            cloneable = new ArrayList<String>();
            if (executionDescriptor.getInitialArgs() != null) {
                cloneable.addAll(Arrays.asList(executionDescriptor.getInitialArgs()));
            }
            if (bl && executionDescriptor.getJVMArguments() != null) {
                for (String string2 : executionDescriptor.getJVMArguments()) {
                    cloneable.add("-J" + string2);
                }
            }
            if (!cloneable.isEmpty()) {
                descriptor.setAdditionalOptions(cloneable);
            }
        }
        descriptor.setScriptArguments(executionDescriptor.getAdditionalArgs());
        descriptor.setSynchronizedOutput(true);
        if (executionDescriptor.getPwd() != null) {
            descriptor.setBaseDirectory(executionDescriptor.getPwd());
        }
        cloneable = new HashMap();
        GemManager.adjustEnvironment((RubyPlatform)rubyPlatform, cloneable);
        if (executionDescriptor.getAdditionalEnvironment() != null) {
            cloneable.putAll(executionDescriptor.getAdditionalEnvironment());
        }
        if (bl) {
            cloneable.putAll(RubyDebugger.getJRubyEnvironment(executionDescriptor));
        }
        descriptor.setEnvironment((Map)((Object)cloneable));
        int n = Integer.getInteger("org.netbeans.modules.ruby.debugger.timeout", 15);
        Util.finer("Using timeout: " + n + 's');
        String string = rubyPlatform.getInterpreter();
        if (!rubyPlatform.hasFastDebuggerInstalled()) {
            Util.LOGGER.fine("Running classic(slow) debugger...");
            rubyDebuggerProxy = RubyDebuggerFactory.startClassicDebugger((RubyDebuggerFactory.Descriptor)descriptor, (String)PATH_TO_CLASSIC_DEBUG_DIR, (String)string, (int)n);
        } else {
            String string2;
            string2 = rubyPlatform.getLatestAvailableValidRDebugIDEVersions();
            descriptor.setRubyDebugIDEVersion(string2);
            Util.LOGGER.fine("Running fast debugger...");
            File file = new File(Util.findRDebugExecutable(rubyPlatform));
            if (executionDescriptor.useInterpreter()) {
                rubyDebuggerProxy = RubyDebuggerFactory.startRubyDebug((RubyDebuggerFactory.Descriptor)descriptor, (String)file.getAbsolutePath(), (String)string, (int)n);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>(20);
                arrayList.add(executionDescriptor.getCmd().getAbsolutePath());
                assert (bl) : "jruby is used";
                if (executionDescriptor.getJVMArguments() != null) {
                    arrayList.addAll(Arrays.asList(executionDescriptor.getJVMArguments()));
                }
                arrayList.addAll(Arrays.asList(executionDescriptor.getInitialArgs()));
                rubyDebuggerProxy = RubyDebuggerFactory.startRubyDebug((RubyDebuggerFactory.Descriptor)descriptor, arrayList, (String)file.getAbsolutePath(), (int)n);
            }
        }
        return RubyDebugger.intializeIDEDebuggerEngine(rubyDebuggerProxy, executionDescriptor.getFileLocator());
    }

    private static Map<String, String> getJRubyEnvironment(ExecutionDescriptor executionDescriptor) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (executionDescriptor.getClassPath() != null) {
            hashMap.put("CLASSPATH", executionDescriptor.getClassPath());
        }
        return hashMap;
    }

    static boolean checkAndTuneSettings(ExecutionDescriptor executionDescriptor) {
        Util.FastDebugInstallationResult fastDebugInstallationResult;
        RubyPlatform rubyPlatform = executionDescriptor.getPlatform();
        if (rubyPlatform.isRubinius()) {
            return false;
        }
        assert (rubyPlatform.isValid()) : rubyPlatform + " is a valid platform";
        boolean bl = rubyPlatform.isJRuby();
        boolean bl2 = executionDescriptor.isFastDebugRequired();
        if (!(bl || (fastDebugInstallationResult = Util.offerToInstallFastDebugger(rubyPlatform)) != Util.FastDebugInstallationResult.CANCELLED && fastDebugInstallationResult != Util.FastDebugInstallationResult.FAILED)) {
            return false;
        }
        if (bl2 && (fastDebugInstallationResult = Util.ensureRubyDebuggerIsPresent(rubyPlatform, true, "RubyDebugger.wrong.fast.debugger.required")) != Util.FastDebugInstallationResult.INSTALLED) {
            if (bl) {
                Util.showMessage(NbBundle.getMessage(RubyDebugger.class, (String)"RubyDebugger.instructionsToInstallJRubyDebugger", (Object)rubyPlatform.getFastDebuggerProblemsInHTML()));
            }
            return false;
        }
        if (rubyPlatform.hasFastDebuggerInstalled()) {
            fastDebugInstallationResult = Util.ensureRubyDebuggerIsPresent(rubyPlatform, true, "RubyDebugger.requiredMessage");
            if (fastDebugInstallationResult != Util.FastDebugInstallationResult.INSTALLED) {
                return false;
            }
            String string = Util.findRDebugExecutable(rubyPlatform);
            if (string == null) {
                Util.showMessage(NbBundle.getMessage(RubyDebugger.class, (String)"RubyDebugger.wrong.rdebug-ide", (Object)rubyPlatform.getInfo().getLongDescription(), (Object)rubyPlatform.getInterpreter(), (Object)Util.rdebugPattern()));
                return false;
            }
        }
        return true;
    }

    private static RubySession intializeIDEDebuggerEngine(RubyDebuggerProxy rubyDebuggerProxy, FileLocator fileLocator) {
        RubySession rubySession = new RubySession(rubyDebuggerProxy, fileLocator);
        SessionProvider sessionProvider = rubySession.createSessionProvider();
        DebuggerInfo debuggerInfo = DebuggerInfo.create((String)"RubyDebuggerInfo", (Object[])new Object[]{sessionProvider, rubySession});
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        DebuggerEngine[] debuggerEngineArray = debuggerManager.startDebugging(debuggerInfo);
        assert (debuggerEngineArray.length == 1) : "one debugger engine";
        Session session = (Session)debuggerEngineArray[0].lookupFirst(null, Session.class);
        assert (session != null) : "non-null Session in the lookup";
        rubySession.setSession(session);
        RubyDebuggerActionProvider rubyDebuggerActionProvider = (RubyDebuggerActionProvider)((Object)debuggerEngineArray[0].lookupFirst(null, RubyDebuggerActionProvider.class));
        assert (rubyDebuggerActionProvider != null);
        rubySession.setActionProvider(rubyDebuggerActionProvider);
        rubyDebuggerProxy.addRubyDebugEventListener((RubyDebugEventListener)rubyDebuggerActionProvider);
        return rubySession;
    }

    static {
        String string = "ruby/debug-commons-0.9.5/classic-debug.rb";
        File file = InstalledFileLocator.getDefault().locate(string, "org.netbeans.modules.ruby.debugger", false);
        if (file == null || !file.isFile()) {
            throw new IllegalStateException("Cannot locate classic debugger in NetBeans Ruby cluster (" + string + ')');
        }
        PATH_TO_CLASSIC_DEBUG_DIR = file.getParentFile().getAbsolutePath();
    }
}

