/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class ToolTipAnnotation
extends Annotation
implements Runnable {
    private static final Boolean SKIP_BALLOON_EVAL = Boolean.getBoolean("ruby.debugger.skip.balloon.evaluation");
    private Line.Part lp;
    private EditorCookie ec;

    public String getShortDescription() {
        RubySession rubySession = Util.getCurrentSession();
        if (rubySession == null) {
            return null;
        }
        Line.Part part = (Line.Part)this.getAttachedAnnotatable();
        if (part == null) {
            return null;
        }
        Line line = part.getLine();
        DataObject dataObject = DataEditorSupport.findDataObject((Line)line);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        this.lp = part;
        this.ec = editorCookie;
        RequestProcessor.getDefault().post((Runnable)this);
        return null;
    }

    public void run() {
        StyledDocument styledDocument;
        if (SKIP_BALLOON_EVAL.booleanValue()) {
            return;
        }
        if (this.lp == null || this.ec == null) {
            return;
        }
        try {
            styledDocument = this.ec.openDocument();
        }
        catch (IOException iOException) {
            return;
        }
        JEditorPane jEditorPane = EditorContextDispatcher.getDefault().getCurrentEditor();
        if (jEditorPane == null) {
            return;
        }
        String string = ToolTipAnnotation.getIdentifier(styledDocument, jEditorPane, NbDocument.findLineOffset((StyledDocument)styledDocument, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn());
        if (string == null) {
            return;
        }
        RubySession rubySession = Util.getCurrentSession();
        if (rubySession == null) {
            return;
        }
        RubyVariable rubyVariable = rubySession.inspectExpression(string);
        if (rubyVariable == null) {
            return;
        }
        RubyValue rubyValue = rubyVariable.getValue();
        if (rubyValue == null) {
            return;
        }
        String string2 = rubyValue.getValueString();
        if (string2 == null || string2.equals(string)) {
            return;
        }
        String string3 = string + " = " + string2;
        this.firePropertyChange("shortDescription", null, string3);
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
        try {
            if (element == null) {
                return null;
            }
            int n4 = element.getStartOffset();
            int n5 = element.getEndOffset() - n4;
            if (n3 + 1 >= n5) {
                return null;
            }
            string = styledDocument.getText(n4, n5);
            return ToolTipAnnotation.getExpressionToEvaluate(string, n3);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    static String getExpressionToEvaluate(String string, int n) {
        int n2;
        int n3;
        for (n3 = n; n3 > 0 && (ToolTipAnnotation.isRubyIdentifier(string.charAt(n3 - 1)) || string.charAt(n3 - 1) == '.'); --n3) {
        }
        for (n2 = n; n2 < string.length() && ToolTipAnnotation.isRubyIdentifier(string.charAt(n2)); ++n2) {
        }
        if (n3 == n2) {
            return null;
        }
        return string.substring(n3, n2);
    }

    static boolean isRubyIdentifier(char c) {
        return c == '@' || c == '?' || Character.isJavaIdentifierPart(c);
    }
}

