/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.projectint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.tasklist.projectint.EmptyIterator;
import org.netbeans.modules.tasklist.projectint.FileObjectIterator;
import org.netbeans.modules.tasklist.projectint.MainProjectScanningScope;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MainProjectIterator
implements Iterator<FileObject> {
    private Iterator<FileObject> iterator;
    private Collection<FileObject> editedFiles;

    public MainProjectIterator(Collection<FileObject> collection) {
        this.editedFiles = collection;
    }

    @Override
    public boolean hasNext() {
        this.initialize();
        return this.iterator.hasNext();
    }

    @Override
    public FileObject next() {
        this.initialize();
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void initialize() {
        if (null == this.iterator) {
            this.iterator = this.createIterator();
        }
    }

    protected Iterator<FileObject> createIterator() {
        boolean bl = true;
        Project project = OpenProjects.getDefault().getMainProject();
        if (null == project) {
            bl = false;
            project = MainProjectScanningScope.findCurrentProject();
            if (null == project) {
                return new EmptyIterator();
            }
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(10);
        this.addProject(project, arrayList);
        if (bl) {
            this.addDependantProjects(project, arrayList);
        }
        return new FileObjectIterator(arrayList, this.editedFiles);
    }

    private void addDependantProjects(Project project, ArrayList<FileObject> arrayList) {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            SubprojectProvider subprojectProvider;
            if (projectArray[i].equals(project) || null == (subprojectProvider = (SubprojectProvider)projectArray[i].getLookup().lookup(SubprojectProvider.class)) || !subprojectProvider.getSubprojects().contains(project)) continue;
            this.addProject(projectArray[i], arrayList);
        }
    }

    private void addProject(Project project, ArrayList<FileObject> arrayList) {
        SourceGroup[] sourceGroupArray;
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("generic")) {
            FileObject fileObject = sourceGroup.getRootFolder();
            arrayList.add(fileObject);
        }
    }
}

