/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.tools.JavaFileManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.classpath.CacheClassPath;
import org.netbeans.modules.java.source.classpath.SourcePath;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.CachingFileManager;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.MemoryFileManager;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.parsing.ProxyFileManager;
import org.netbeans.modules.java.source.parsing.SourceFileManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class ClasspathInfo {
    private static final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private final CachingArchiveProvider archiveProvider;
    private final ClassPath srcClassPath;
    private final ClassPath bootClassPath;
    private final ClassPath compileClassPath;
    private final ClassPath cachedSrcClassPath;
    private final ClassPath cachedBootClassPath;
    private final ClassPath cachedCompileClassPath;
    private ClassPath outputClassPath;
    private final ClassPathListener cpListener;
    private final boolean backgroundCompilation;
    private final boolean ignoreExcludes;
    private final JavaFileFilterImplementation filter;
    private JavaFileManager fileManager;
    private OutputFileManager outFileManager;
    private final MemoryFileManager memoryFileManager;
    private EventListenerList listenerList = null;
    private ClassIndex usagesQuery;

    private ClasspathInfo(CachingArchiveProvider cachingArchiveProvider, ClassPath classPath, ClassPath classPath2, ClassPath classPath3, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl, boolean bl2, boolean bl3) {
        assert (cachingArchiveProvider != null);
        assert (classPath != null);
        assert (classPath2 != null);
        this.cpListener = new ClassPathListener();
        this.archiveProvider = cachingArchiveProvider;
        this.bootClassPath = classPath;
        this.compileClassPath = classPath2;
        this.cachedBootClassPath = CacheClassPath.forBootPath(this.bootClassPath);
        this.cachedCompileClassPath = CacheClassPath.forClassPath(this.compileClassPath);
        this.cachedBootClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedBootClassPath));
        this.cachedCompileClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedCompileClassPath));
        if (classPath3 == null) {
            this.cachedSrcClassPath = this.srcClassPath = EMPTY_PATH;
            this.outputClassPath = EMPTY_PATH;
        } else {
            this.srcClassPath = classPath3;
            this.cachedSrcClassPath = SourcePath.create(classPath3, bl);
            this.outputClassPath = CacheClassPath.forSourcePath(this.cachedSrcClassPath);
            this.cachedSrcClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedSrcClassPath));
        }
        this.backgroundCompilation = bl;
        this.ignoreExcludes = bl2;
        this.filter = javaFileFilterImplementation;
        if (bl3) {
            if (classPath3 == null) {
                throw new IllegalStateException();
            }
            this.memoryFileManager = new MemoryFileManager();
        } else {
            this.memoryFileManager = null;
        }
    }

    public String toString() {
        return String.format("ClasspathInfo boot: %s, compile: %s, src: %s, internal boot: %s, internal compile: %s, internal out: %s", this.bootClassPath, this.compileClassPath, this.cachedSrcClassPath, this.cachedBootClassPath, this.cachedCompileClassPath, this.outputClassPath);
    }

    public static ClasspathInfo create(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot pass null as parameter of ClasspathInfo.create(java.io.File)");
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return null;
        }
        return ClasspathInfo.create(fileObject);
    }

    private static ClasspathInfo create(FileObject fileObject, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl, boolean bl2, boolean bl3) {
        ClassPath classPath;
        ClassPath classPath2;
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        if (classPath3 == null) {
            classPath3 = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
        }
        if ((classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile")) == null) {
            classPath2 = EMPTY_PATH;
        }
        if ((classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")) == null) {
            classPath = EMPTY_PATH;
        }
        return ClasspathInfo.create(classPath3, classPath2, classPath, javaFileFilterImplementation, bl, bl2, bl3);
    }

    public static ClasspathInfo create(FileObject fileObject) {
        return ClasspathInfo.create(fileObject, null, false, false, false);
    }

    private static ClasspathInfo create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl, boolean bl2, boolean bl3) {
        return new ClasspathInfo(CachingArchiveProvider.getDefault(), classPath, classPath2, classPath3, javaFileFilterImplementation, bl, bl2, bl3);
    }

    public static ClasspathInfo create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3) {
        Parameters.notNull((CharSequence)"bootPath", (Object)classPath);
        Parameters.notNull((CharSequence)"classPath", (Object)classPath2);
        return ClasspathInfo.create(classPath, classPath2, classPath3, null, false, false, false);
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ClassPath getClassPath(PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.bootClassPath;
            }
            case COMPILE: {
                return this.compileClassPath;
            }
            case SOURCE: {
                return this.srcClassPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    ClassPath getCachedClassPath(PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.cachedBootClassPath;
            }
            case COMPILE: {
                return this.cachedCompileClassPath;
            }
            case SOURCE: {
                return this.cachedSrcClassPath;
            }
            case OUTPUT: {
                return this.outputClassPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    public synchronized ClassIndex getClassIndex() {
        if (this.usagesQuery == null) {
            this.usagesQuery = new ClassIndex(this.bootClassPath, this.compileClassPath, this.cachedSrcClassPath);
        }
        return this.usagesQuery;
    }

    synchronized JavaFileManager getFileManager() {
        if (this.fileManager == null) {
            boolean bl = this.cachedSrcClassPath != null;
            this.fileManager = new ProxyFileManager(new CachingFileManager(this.archiveProvider, this.cachedBootClassPath, true, true), new CachingFileManager(this.archiveProvider, this.cachedCompileClassPath, false, true), bl ? (this.backgroundCompilation ? new CachingFileManager(this.archiveProvider, this.cachedSrcClassPath, this.filter, false, this.ignoreExcludes) : new SourceFileManager(this.cachedSrcClassPath, this.ignoreExcludes)) : null, bl ? (this.outFileManager = new OutputFileManager(this.archiveProvider, this.outputClassPath, this.cachedSrcClassPath)) : null, this.memoryFileManager);
        }
        return this.fileManager;
    }

    synchronized OutputFileManager getOutputFileManager() {
        this.getFileManager();
        return this.outFileManager;
    }

    private void fireChangeListenerStateChanged() {
        ChangeEvent changeEvent = null;
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    static {
        ClasspathInfoAccessor.setINSTANCE(new ClasspathInfoAccessorImpl());
        try {
            Class.forName(ClassIndex.class.getName(), true, CompilationInfo.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)classNotFoundException);
        }
    }

    private static class ClasspathInfoAccessorImpl
    extends ClasspathInfoAccessor {
        private ClasspathInfoAccessorImpl() {
        }

        public JavaFileManager getFileManager(ClasspathInfo classpathInfo) {
            return classpathInfo.getFileManager();
        }

        public ClassPath getCachedClassPath(ClasspathInfo classpathInfo, PathKind pathKind) {
            return classpathInfo.getCachedClassPath(pathKind);
        }

        public ClasspathInfo create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl, boolean bl2, boolean bl3) {
            return ClasspathInfo.create(classPath, classPath2, classPath3, javaFileFilterImplementation, bl, bl2, bl3);
        }

        public ClasspathInfo create(FileObject fileObject, JavaFileFilterImplementation javaFileFilterImplementation, boolean bl, boolean bl2, boolean bl3) {
            return ClasspathInfo.create(fileObject, javaFileFilterImplementation, bl, bl2, bl3);
        }

        public boolean registerVirtualSource(ClasspathInfo classpathInfo, FileObjects.InferableJavaFileObject inferableJavaFileObject) throws UnsupportedOperationException {
            if (classpathInfo.memoryFileManager == null) {
                throw new UnsupportedOperationException("The ClassPathInfo doesn't support memory JavacFileManager");
            }
            return classpathInfo.memoryFileManager.register(inferableJavaFileObject);
        }

        public boolean unregisterVirtualSource(ClasspathInfo classpathInfo, String string) throws UnsupportedOperationException {
            if (classpathInfo.memoryFileManager == null) {
                throw new UnsupportedOperationException();
            }
            return classpathInfo.memoryFileManager.unregister(string);
        }
    }

    private class ClassPathListener
    implements PropertyChangeListener {
        private ClassPathListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("roots".equals(propertyChangeEvent.getPropertyName())) {
                ClassPathListener classPathListener = this;
                synchronized (classPathListener) {
                    ClasspathInfo.this.fileManager = null;
                }
                ClasspathInfo.this.fireChangeListenerStateChanged();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathKind {
        BOOT,
        COMPILE,
        SOURCE,
        OUTPUT;

    }
}

