/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Set;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.WeakSet;

public class ActivatedDocumentListener
implements PropertyChangeListener {
    private static ActivatedDocumentListener INSTANCE;
    private FileObject lastValidFile;
    public static boolean IGNORE_COMPILE_REQUESTS;
    private static final Set<FileObject> modified;

    public static void register() {
        INSTANCE = new ActivatedDocumentListener();
    }

    private ActivatedDocumentListener() {
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JavaSource javaSource;
        JTextComponent jTextComponent = EditorRegistry.lastFocusedComponent();
        if (jTextComponent == null) {
            return;
        }
        Document document = jTextComponent.getDocument();
        if (document == null) {
            return;
        }
        Object object = document.getProperty("stream");
        if (!(object instanceof DataObject)) {
            return;
        }
        DataObject dataObject = (DataObject)object;
        if (dataObject == null) {
            return;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (this.lastValidFile == fileObject) {
            return;
        }
        if (this.lastValidFile != null && ActivatedDocumentListener.isJava(this.lastValidFile) && ActivatedDocumentListener.isModified(this.lastValidFile)) {
            FileObject fileObject2;
            ActivatedDocumentListener.removeFromModified(this.lastValidFile);
            if (!IGNORE_COMPILE_REQUESTS && (javaSource = ClassPath.getClassPath((FileObject)this.lastValidFile, (String)"classpath/source")) != null && (fileObject2 = javaSource.findOwnerRoot(this.lastValidFile)) != null) {
                try {
                    if ("file".equals(this.lastValidFile.getURL().getProtocol())) {
                        RepositoryUpdater.getDefault().scheduleCompilation(this.lastValidFile, fileObject2);
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            this.lastValidFile = null;
        }
        if ((javaSource = JavaSource.forFileObject(fileObject)) == null) {
            return;
        }
        this.lastValidFile = fileObject;
        JavaSourceAccessor.getINSTANCE().revalidate(javaSource);
    }

    private static boolean isJava(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return false;
        }
        if ("java".equals(fileObject.getExt().toLowerCase())) {
            return true;
        }
        return "text/x-java".equals(fileObject.getMIMEType());
    }

    public static synchronized void addToModified(FileObject fileObject) {
        modified.add(fileObject);
    }

    public static synchronized void removeFromModified(FileObject fileObject) {
        modified.remove(fileObject);
    }

    public static synchronized boolean isModified(FileObject fileObject) {
        return modified.contains(fileObject);
    }

    static {
        IGNORE_COMPILE_REQUESTS = false;
        modified = new WeakSet();
    }
}

