/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FolderArchive
implements Archive {
    private static final Logger LOG = Logger.getLogger(FolderArchive.class.getName());
    private static final boolean normalize = Boolean.getBoolean("FolderArchive.normalize");
    final File root;
    final Charset encoding;

    public FolderArchive(File file) {
        FileObject fileObject;
        assert (file != null);
        this.root = file;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "creating FolderArchive for {0}", file.getAbsolutePath());
        }
        this.encoding = (fileObject = FileUtil.toFileObject((File)file)) != null ? FileEncodingQuery.getEncoding((FileObject)fileObject) : null;
    }

    @Override
    public Iterable<JavaFileObject> getFiles(String string, ClassPath.Entry entry, Set<JavaFileObject.Kind> set, JavaFileFilterImplementation javaFileFilterImplementation) throws IOException {
        assert (string != null);
        if (string.length() > 0) {
            string = string + '/';
        }
        if (entry == null || entry.includes(string)) {
            File[] fileArray;
            File file = new File(this.root, string.replace('/', File.separatorChar));
            if (normalize) {
                file = FileUtil.normalizeFile((File)file);
            }
            if (file.canRead() && (fileArray = file.listFiles()) != null) {
                ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>(fileArray.length);
                for (File file2 : fileArray) {
                    if (!file2.isFile() || entry != null && !entry.includes(file2.toURI().toURL()) || set != null && !set.contains((Object)FileObjects.getKind(FileObjects.getExtension(file2.getName())))) continue;
                    arrayList.add(FileObjects.fileFileObject(file2, this.root, javaFileFilterImplementation, this.encoding));
                }
                return Collections.unmodifiableList(arrayList);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void clear() {
    }
}

