/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.tasklist;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.modules.java.source.tasklist.TaskCache;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncorrectErrorBadges
implements CancellableTask<CompilationInfo> {
    private static final boolean DISABLE = Boolean.getBoolean(IncorrectErrorBadges.class.getName() + ".disable");
    private static final Logger LOG = Logger.getLogger(IncorrectErrorBadges.class.getName());
    private int invocationCount;
    private long timestamp;
    private FactoryImpl factory;
    private static final RequestProcessor WORKER = new RequestProcessor(IncorrectErrorBadges.class.getName());

    private IncorrectErrorBadges(FactoryImpl factoryImpl) {
        this.factory = factoryImpl;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void run(CompilationInfo compilationInfo) {
        if (DISABLE) {
            return;
        }
        if (RepositoryUpdater.getDefault().isRULocked()) {
            return;
        }
        if (this.invocationCount++ > 1) {
            return;
        }
        try {
            Diagnostic diagnostic2;
            for (Diagnostic diagnostic2 : compilationInfo.getDiagnostics()) {
                if (diagnostic2.getKind() != Diagnostic.Kind.ERROR) continue;
                return;
            }
            final FileObject fileObject = compilationInfo.getFileObject();
            diagnostic2 = DataObject.find((FileObject)fileObject);
            if (diagnostic2.isModified()) {
                return;
            }
            if (!TaskCache.getDefault().isInError(fileObject, false)) {
                return;
            }
            if (this.invocationCount == 1) {
                this.timestamp = fileObject.lastModified().getTime();
                WORKER.post(new Runnable(){

                    public void run() {
                        IncorrectErrorBadges.this.factory.rescheduleImpl(fileObject);
                    }
                }, 2 * RepositoryUpdater.getDelay());
                return;
            }
            if (this.timestamp != fileObject.lastModified().getTime()) {
                return;
            }
            LOG.log(Level.WARNING, "Incorrect error badges detected, file={0}.", FileUtil.getFileDisplayName((FileObject)fileObject));
            ClassPath classPath = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
            FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
            if (fileObject2 == null) {
                LOG.log(Level.WARNING, "The file is not on its own source classpath, ignoring.");
                return;
            }
            LOG.log(Level.WARNING, "Going to recompute root={0}, files in error={1}.", new Object[]{FileUtil.getFileDisplayName((FileObject)fileObject2), TaskCache.getDefault().getAllFilesInError(fileObject2.getURL())});
            RepositoryUpdater.getDefault().rebuildRoot(fileObject2.getURL(), true);
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, null, iOException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FactoryImpl
    extends EditorAwareJavaSourceTaskFactory {
        public FactoryImpl() {
            super(JavaSource.Phase.UP_TO_DATE, JavaSource.Priority.MIN);
        }

        @Override
        protected CancellableTask<CompilationInfo> createTask(FileObject fileObject) {
            return new IncorrectErrorBadges(this);
        }

        void rescheduleImpl(FileObject fileObject) {
            this.reschedule(fileObject);
        }
    }
}

