/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.transform;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.QualIdentTree;
import org.netbeans.modules.java.source.builder.TreeFactory;
import org.netbeans.modules.java.source.pretty.ImportAnalysis2;
import org.netbeans.modules.java.source.query.CommentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableTreeTranslator
implements TreeVisitor<Tree, Object> {
    public Element currentSym;
    protected TreeFactory make;
    protected CommentHandler comments;
    protected ASTService model;
    private CompilationUnitTree topLevel;
    private ImportAnalysis2 importAnalysis;
    private Map<Tree, Object> tree2Tag;

    public void attach(Context context, ImportAnalysis2 importAnalysis2, CompilationUnitTree compilationUnitTree, Map<Tree, Object> map) {
        this.make = TreeFactory.instance(context);
        this.comments = CommentHandlerService.instance(context);
        this.model = ASTService.instance(context);
        this.importAnalysis = importAnalysis2;
        this.topLevel = compilationUnitTree;
        this.tree2Tag = map;
    }

    public void attach(Context context) {
        this.attach(context, new ImportAnalysis2(context), null, null);
    }

    public void release() {
        this.make = null;
        this.comments = null;
        this.model = null;
        this.topLevel = null;
        this.importAnalysis = null;
    }

    public Tree translate(Tree tree) {
        if (tree == null) {
            return null;
        }
        Tree tree2 = tree.accept(this, null);
        if (this.tree2Tag != null && tree != tree2) {
            this.tree2Tag.put(tree2, this.tree2Tag.get(tree));
        }
        return tree2;
    }

    public <T extends Tree> T translateClassRef(T t) {
        return (T)this.translate(t);
    }

    public final <T extends Tree> List<T> translateClassRef(List<T> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        boolean bl = false;
        for (Tree tree : list) {
            Tree tree2 = this.translateClassRef(tree);
            if (tree2 != tree) {
                bl = true;
            }
            if (tree2 == null) continue;
            arrayList.add(tree2);
        }
        return bl ? arrayList : list;
    }

    public <T extends Tree> T translateStable(T t) {
        Tree tree = this.translate(t);
        if (tree != null && tree.getClass() != t.getClass() && tree.getClass() != t.getClass() && (t.getClass() != QualIdentTree.class || tree.getKind() != Tree.Kind.IDENTIFIER && tree.getKind() != Tree.Kind.MEMBER_SELECT)) {
            System.err.println("Rewrite stability problem: got " + tree.getClass() + "\n\t\texpected " + t.getClass());
            return t;
        }
        return (T)tree;
    }

    public static boolean isEmpty(Tree tree) {
        if (tree == null) {
            return true;
        }
        switch (tree.getKind()) {
            default: {
                return false;
            }
            case BLOCK: {
                for (StatementTree statementTree : ((BlockTree)tree).getStatements()) {
                    if (ImmutableTreeTranslator.isEmpty(statementTree)) continue;
                    return false;
                }
                return true;
            }
            case EMPTY_STATEMENT: 
        }
        return true;
    }

    public <T extends Tree> List<T> translate(List<T> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        boolean bl = false;
        for (Tree tree : list) {
            Tree tree2 = this.translate(tree);
            if (tree2 != tree) {
                bl = true;
            }
            if (tree2 == null) continue;
            arrayList.add(tree2);
        }
        return bl ? arrayList : list;
    }

    public <T extends Tree> List<T> translateStable(List<T> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<Tree> arrayList = new ArrayList<Tree>();
        boolean bl = false;
        for (Tree tree : list) {
            Tree tree2 = this.translateStable(tree);
            if (tree2 != tree) {
                bl = true;
            }
            if (tree2 == null) continue;
            arrayList.add(tree2);
        }
        return bl ? arrayList : list;
    }

    protected <T extends Tree> List<T> optimize(List<T> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Tree tree : list) {
            if (tree == null || ImmutableTreeTranslator.isEmpty(tree)) continue;
            switch (tree.getKind()) {
                case BLOCK: 
                case RETURN: 
                case THROW: 
                case BREAK: 
                case CONTINUE: {
                    arrayList.add(tree);
                    return ImmutableTreeTranslator.equals(list, arrayList) ? list : arrayList;
                }
            }
            arrayList.add(tree);
        }
        return ImmutableTreeTranslator.equals(list, arrayList) ? list : arrayList;
    }

    private static <T extends Tree> boolean equals(List<T> list, List<T> list2) {
        int n = list.size();
        if (n != list2.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (list.get(i) == list2.get(i)) continue;
            return false;
        }
        return true;
    }

    public final void copyCommentTo(Tree tree, Tree tree2, Tree tree3) {
        this.copyCommentTo(tree, tree3);
        if (tree != tree2) {
            this.copyCommentTo(tree2, tree3);
        }
    }

    public final void copyCommentTo(Tree tree, Tree tree2) {
        this.comments.copyComments(tree, tree2);
    }

    int size(List<?> list) {
        return list == null ? 0 : list.size();
    }

    private void copyPosTo(Tree tree, Tree tree2) {
        this.model.setPos(tree2, this.model.getPos(tree));
    }

    private boolean safeEquals(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree compilationUnitTree, Object object) {
        this.topLevel = compilationUnitTree;
        CompilationUnitTree compilationUnitTree2 = this.rewriteChildren(this.topLevel);
        this.topLevel = null;
        return compilationUnitTree2;
    }

    @Override
    public Tree visitImport(ImportTree importTree, Object object) {
        return this.rewriteChildren(importTree);
    }

    @Override
    public Tree visitClass(ClassTree classTree, Object object) {
        Element element = this.currentSym;
        this.currentSym = this.model.getElement(classTree);
        this.importAnalysis.classEntered(classTree);
        ClassTree classTree2 = this.rewriteChildren(classTree);
        this.importAnalysis.classLeft();
        this.currentSym = element;
        return classTree2;
    }

    @Override
    public Tree visitMethod(MethodTree methodTree, Object object) {
        Element element = this.currentSym;
        this.currentSym = this.model.getElement(methodTree);
        MethodTree methodTree2 = this.rewriteChildren(methodTree);
        this.currentSym = element;
        return methodTree2;
    }

    @Override
    public Tree visitVariable(VariableTree variableTree, Object object) {
        Element element = this.currentSym;
        this.currentSym = this.model.getElement(variableTree);
        VariableTree variableTree2 = this.rewriteChildren(variableTree);
        this.currentSym = element;
        return variableTree2;
    }

    @Override
    public Tree visitEmptyStatement(EmptyStatementTree emptyStatementTree, Object object) {
        return this.rewriteChildren(emptyStatementTree);
    }

    @Override
    public Tree visitBlock(BlockTree blockTree, Object object) {
        return this.rewriteChildren(blockTree);
    }

    @Override
    public Tree visitDoWhileLoop(DoWhileLoopTree doWhileLoopTree, Object object) {
        return this.rewriteChildren(doWhileLoopTree);
    }

    @Override
    public Tree visitWhileLoop(WhileLoopTree whileLoopTree, Object object) {
        return this.rewriteChildren(whileLoopTree);
    }

    @Override
    public Tree visitForLoop(ForLoopTree forLoopTree, Object object) {
        return this.rewriteChildren(forLoopTree);
    }

    @Override
    public Tree visitEnhancedForLoop(EnhancedForLoopTree enhancedForLoopTree, Object object) {
        return this.rewriteChildren(enhancedForLoopTree);
    }

    @Override
    public Tree visitLabeledStatement(LabeledStatementTree labeledStatementTree, Object object) {
        return this.rewriteChildren(labeledStatementTree);
    }

    @Override
    public Tree visitSwitch(SwitchTree switchTree, Object object) {
        return this.rewriteChildren(switchTree);
    }

    @Override
    public Tree visitCase(CaseTree caseTree, Object object) {
        return this.rewriteChildren(caseTree);
    }

    @Override
    public Tree visitSynchronized(SynchronizedTree synchronizedTree, Object object) {
        return this.rewriteChildren(synchronizedTree);
    }

    @Override
    public Tree visitTry(TryTree tryTree, Object object) {
        return this.rewriteChildren(tryTree);
    }

    @Override
    public Tree visitCatch(CatchTree catchTree, Object object) {
        return this.rewriteChildren(catchTree);
    }

    @Override
    public Tree visitConditionalExpression(ConditionalExpressionTree conditionalExpressionTree, Object object) {
        return this.rewriteChildren(conditionalExpressionTree);
    }

    @Override
    public Tree visitIf(IfTree ifTree, Object object) {
        return this.rewriteChildren(ifTree);
    }

    @Override
    public Tree visitExpressionStatement(ExpressionStatementTree expressionStatementTree, Object object) {
        return this.rewriteChildren(expressionStatementTree);
    }

    @Override
    public Tree visitBreak(BreakTree breakTree, Object object) {
        return this.rewriteChildren(breakTree);
    }

    @Override
    public Tree visitContinue(ContinueTree continueTree, Object object) {
        return this.rewriteChildren(continueTree);
    }

    @Override
    public Tree visitReturn(ReturnTree returnTree, Object object) {
        return this.rewriteChildren(returnTree);
    }

    @Override
    public Tree visitThrow(ThrowTree throwTree, Object object) {
        return this.rewriteChildren(throwTree);
    }

    @Override
    public Tree visitAssert(AssertTree assertTree, Object object) {
        return this.rewriteChildren(assertTree);
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree methodInvocationTree, Object object) {
        return this.rewriteChildren(methodInvocationTree);
    }

    @Override
    public Tree visitNewClass(NewClassTree newClassTree, Object object) {
        return this.rewriteChildren(newClassTree);
    }

    @Override
    public Tree visitNewArray(NewArrayTree newArrayTree, Object object) {
        return this.rewriteChildren(newArrayTree);
    }

    @Override
    public Tree visitParenthesized(ParenthesizedTree parenthesizedTree, Object object) {
        return this.rewriteChildren(parenthesizedTree);
    }

    @Override
    public Tree visitAssignment(AssignmentTree assignmentTree, Object object) {
        return this.rewriteChildren(assignmentTree);
    }

    @Override
    public Tree visitCompoundAssignment(CompoundAssignmentTree compoundAssignmentTree, Object object) {
        return this.rewriteChildren(compoundAssignmentTree);
    }

    @Override
    public Tree visitUnary(UnaryTree unaryTree, Object object) {
        return this.rewriteChildren(unaryTree);
    }

    @Override
    public Tree visitBinary(BinaryTree binaryTree, Object object) {
        return this.rewriteChildren(binaryTree);
    }

    @Override
    public Tree visitTypeCast(TypeCastTree typeCastTree, Object object) {
        return this.rewriteChildren(typeCastTree);
    }

    @Override
    public Tree visitInstanceOf(InstanceOfTree instanceOfTree, Object object) {
        return this.rewriteChildren(instanceOfTree);
    }

    @Override
    public Tree visitArrayAccess(ArrayAccessTree arrayAccessTree, Object object) {
        return this.rewriteChildren(arrayAccessTree);
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Object object) {
        if (memberSelectTree instanceof QualIdentTree) {
            Symbol symbol = ((QualIdentTree)memberSelectTree).sym;
            return this.importAnalysis.resolveImport(memberSelectTree, symbol);
        }
        return this.rewriteChildren(memberSelectTree);
    }

    @Override
    public Tree visitIdentifier(IdentifierTree identifierTree, Object object) {
        return this.rewriteChildren(identifierTree);
    }

    @Override
    public Tree visitLiteral(LiteralTree literalTree, Object object) {
        return this.rewriteChildren(literalTree);
    }

    @Override
    public Tree visitPrimitiveType(PrimitiveTypeTree primitiveTypeTree, Object object) {
        return this.rewriteChildren(primitiveTypeTree);
    }

    @Override
    public Tree visitArrayType(ArrayTypeTree arrayTypeTree, Object object) {
        return this.rewriteChildren(arrayTypeTree);
    }

    @Override
    public Tree visitParameterizedType(ParameterizedTypeTree parameterizedTypeTree, Object object) {
        return this.rewriteChildren(parameterizedTypeTree);
    }

    @Override
    public Tree visitTypeParameter(TypeParameterTree typeParameterTree, Object object) {
        return this.rewriteChildren(typeParameterTree);
    }

    @Override
    public Tree visitWildcard(WildcardTree wildcardTree, Object object) {
        return this.rewriteChildren(wildcardTree);
    }

    @Override
    public Tree visitAnnotation(AnnotationTree annotationTree, Object object) {
        return this.rewriteChildren(annotationTree);
    }

    @Override
    public Tree visitModifiers(ModifiersTree modifiersTree, Object object) {
        return this.rewriteChildren(modifiersTree);
    }

    @Override
    public Tree visitErroneous(ErroneousTree erroneousTree, Object object) {
        return this.rewriteChildren(erroneousTree);
    }

    @Override
    public Tree visitOther(Tree tree, Object object) {
        throw new Error("Tree not overloaded: " + tree);
    }

    protected final CompilationUnitTree rewriteChildren(CompilationUnitTree compilationUnitTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(compilationUnitTree.getPackageName());
        this.importAnalysis.setCompilationUnit(compilationUnitTree);
        this.importAnalysis.setPackage(compilationUnitTree.getPackageName());
        this.importAnalysis.setImports(this.translate(compilationUnitTree.getImports()));
        List<? extends Tree> list = this.translate(compilationUnitTree.getTypeDecls());
        List<? extends ImportTree> list2 = this.importAnalysis.getImports();
        if (expressionTree != compilationUnitTree.getPackageName() || !((Object)list2).equals(compilationUnitTree.getImports()) || !((Object)list).equals(compilationUnitTree.getTypeDecls())) {
            CompilationUnitTree compilationUnitTree2 = this.make.CompilationUnit(expressionTree, list2, list, compilationUnitTree.getSourceFile());
            this.model.setElement(compilationUnitTree2, this.model.getElement(compilationUnitTree));
            this.copyCommentTo(compilationUnitTree, compilationUnitTree2);
            this.model.setPos(compilationUnitTree2, this.model.getPos(compilationUnitTree));
            compilationUnitTree = compilationUnitTree2;
        }
        return compilationUnitTree;
    }

    protected final ImportTree rewriteChildren(ImportTree importTree) {
        Tree tree = this.translateClassRef(importTree.getQualifiedIdentifier());
        if (tree == importTree.getQualifiedIdentifier()) {
            tree = this.translate(importTree.getQualifiedIdentifier());
        }
        if (tree != importTree.getQualifiedIdentifier()) {
            ImportTree importTree2 = this.make.Import(tree, importTree.isStatic());
            this.model.setType(importTree2, this.model.getType(importTree));
            this.copyCommentTo(importTree, importTree2);
            this.copyPosTo(importTree, importTree2);
            importTree = importTree2;
        }
        return importTree;
    }

    protected final ClassTree rewriteChildren(ClassTree classTree) {
        boolean bl;
        ModifiersTree modifiersTree = (ModifiersTree)this.translate(classTree.getModifiers());
        List<? extends TypeParameterTree> list = this.translateStable(classTree.getTypeParameters());
        Tree tree = this.translateClassRef(classTree.getExtendsClause());
        List<? extends Tree> list2 = this.translateClassRef(classTree.getImplementsClause());
        List<? extends Tree> list3 = this.translate(classTree.getMembers());
        boolean bl2 = bl = !((Object)list).equals(classTree.getTypeParameters()) || tree != classTree.getExtendsClause() || !((Object)list2).equals(classTree.getImplementsClause());
        if (bl || modifiersTree != classTree.getModifiers() || !((Object)list3).equals(classTree.getMembers())) {
            ClassTree classTree2 = this.make.Class(modifiersTree, classTree.getSimpleName(), list, tree, list2, list3);
            if (!bl) {
                this.model.setElement(classTree2, this.model.getElement(classTree));
                this.model.setType(classTree2, this.model.getType(classTree));
            }
            this.copyCommentTo(classTree, classTree2);
            if (classTree.getMembers().size() == list3.size()) {
                this.model.setPos(classTree2, this.model.getPos(classTree));
            } else {
                this.copyPosTo(classTree, classTree2);
            }
            classTree = classTree2;
        }
        return classTree;
    }

    protected final MethodTree rewriteChildren(MethodTree methodTree) {
        ModifiersTree modifiersTree = (ModifiersTree)this.translate(methodTree.getModifiers());
        ExpressionTree expressionTree = (ExpressionTree)this.translateClassRef(methodTree.getReturnType());
        List<? extends TypeParameterTree> list = this.translateStable(methodTree.getTypeParameters());
        List<? extends VariableTree> list2 = this.translateStable(methodTree.getParameters());
        List<? extends ExpressionTree> list3 = this.translateStable(methodTree.getThrows());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translate(methodTree.getDefaultValue());
        BlockTree blockTree = (BlockTree)this.translate(methodTree.getBody());
        if (!(expressionTree == methodTree.getReturnType() && ((Object)list).equals(methodTree.getTypeParameters()) && ((Object)list2).equals(methodTree.getParameters()) && ((Object)list3).equals(methodTree.getThrows()) && modifiersTree == methodTree.getModifiers() && expressionTree2 == methodTree.getDefaultValue() && blockTree == methodTree.getBody())) {
            MethodTree methodTree2 = this.make.Method(modifiersTree, methodTree.getName().toString(), expressionTree, list, list2, list3, blockTree, expressionTree2);
            this.copyCommentTo(methodTree, methodTree2);
            this.copyPosTo(methodTree, methodTree2);
            methodTree = methodTree2;
        }
        return methodTree;
    }

    protected final VariableTree rewriteChildren(VariableTree variableTree) {
        ModifiersTree modifiersTree = (ModifiersTree)this.translate(variableTree.getModifiers());
        ExpressionTree expressionTree = (ExpressionTree)this.translateClassRef(variableTree.getType());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translate(variableTree.getInitializer());
        if (expressionTree != variableTree.getType() || modifiersTree != variableTree.getModifiers() || expressionTree2 != variableTree.getInitializer()) {
            VariableTree variableTree2 = this.make.Variable(modifiersTree, variableTree.getName().toString(), expressionTree, expressionTree2);
            this.copyCommentTo(variableTree, variableTree2);
            this.copyPosTo(variableTree, variableTree2);
            variableTree = variableTree2;
        }
        return variableTree;
    }

    protected final EmptyStatementTree rewriteChildren(EmptyStatementTree emptyStatementTree) {
        return emptyStatementTree;
    }

    protected final BlockTree rewriteChildren(BlockTree blockTree) {
        List<? extends StatementTree> list = blockTree.getStatements();
        List<? extends StatementTree> list2 = this.translate(list);
        if (!((Object)list2).equals(list)) {
            BlockTree blockTree2 = this.make.Block(list2, blockTree.isStatic());
            this.model.setType(blockTree2, this.model.getType(blockTree));
            this.copyCommentTo(blockTree, blockTree2);
            if (list2.size() != list.size() || list.size() > 0 && list2.size() > 0 && list.get(0) != list2.get(0) && (this.model.getPos(list.get(0)) < 0 || this.model.getPos(list2.get(0)) < 0)) {
                assert (this.topLevel != null);
                this.model.setPos(this.topLevel, -2);
            } else {
                this.copyPosTo(blockTree, blockTree2);
            }
            blockTree = blockTree2;
        }
        return blockTree;
    }

    protected final DoWhileLoopTree rewriteChildren(DoWhileLoopTree doWhileLoopTree) {
        StatementTree statementTree = (StatementTree)this.translate(doWhileLoopTree.getStatement());
        ExpressionTree expressionTree = (ExpressionTree)this.translate(doWhileLoopTree.getCondition());
        if (statementTree != doWhileLoopTree.getStatement() || expressionTree != doWhileLoopTree.getCondition()) {
            DoWhileLoopTree doWhileLoopTree2 = this.make.DoWhileLoop(expressionTree, statementTree);
            this.model.setType(doWhileLoopTree2, this.model.getType(doWhileLoopTree));
            this.copyCommentTo(doWhileLoopTree, doWhileLoopTree2);
            this.copyPosTo(doWhileLoopTree, doWhileLoopTree2);
            doWhileLoopTree = doWhileLoopTree2;
        }
        return doWhileLoopTree;
    }

    protected final WhileLoopTree rewriteChildren(WhileLoopTree whileLoopTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(whileLoopTree.getCondition());
        StatementTree statementTree = (StatementTree)this.translate(whileLoopTree.getStatement());
        if (expressionTree != whileLoopTree.getCondition() || statementTree != whileLoopTree.getStatement()) {
            WhileLoopTree whileLoopTree2 = this.make.WhileLoop(expressionTree, statementTree);
            this.model.setType(whileLoopTree2, this.model.getType(whileLoopTree));
            this.copyCommentTo(whileLoopTree, whileLoopTree2);
            this.copyPosTo(whileLoopTree, whileLoopTree2);
            whileLoopTree = whileLoopTree2;
        }
        return whileLoopTree;
    }

    protected final ForLoopTree rewriteChildren(ForLoopTree forLoopTree) {
        List<? extends StatementTree> list = this.translate(forLoopTree.getInitializer());
        ExpressionTree expressionTree = (ExpressionTree)this.translate(forLoopTree.getCondition());
        List<? extends ExpressionStatementTree> list2 = this.translate(forLoopTree.getUpdate());
        StatementTree statementTree = (StatementTree)this.translate(forLoopTree.getStatement());
        if (!((Object)list).equals(forLoopTree.getInitializer()) || expressionTree != forLoopTree.getCondition() || !((Object)list2).equals(forLoopTree.getUpdate()) || statementTree != forLoopTree.getStatement()) {
            if (list != forLoopTree.getInitializer()) {
                list = this.optimize(list);
            }
            if (list2 != forLoopTree.getUpdate()) {
                list2 = this.optimize(list2);
            }
            ForLoopTree forLoopTree2 = this.make.ForLoop(list, expressionTree, list2, statementTree);
            this.model.setType(forLoopTree2, this.model.getType(forLoopTree));
            this.copyCommentTo(forLoopTree, forLoopTree2);
            if (forLoopTree.getInitializer().size() != list.size() || forLoopTree.getUpdate().size() != list2.size()) {
                this.model.setPos(forLoopTree, -2);
            } else {
                this.copyPosTo(forLoopTree, forLoopTree2);
            }
            forLoopTree = forLoopTree2;
        }
        return forLoopTree;
    }

    protected final EnhancedForLoopTree rewriteChildren(EnhancedForLoopTree enhancedForLoopTree) {
        VariableTree variableTree = (VariableTree)this.translate(enhancedForLoopTree.getVariable());
        ExpressionTree expressionTree = (ExpressionTree)this.translate(enhancedForLoopTree.getExpression());
        StatementTree statementTree = (StatementTree)this.translate(enhancedForLoopTree.getStatement());
        if (variableTree != enhancedForLoopTree.getVariable() || expressionTree != enhancedForLoopTree.getExpression() || statementTree != enhancedForLoopTree.getStatement()) {
            EnhancedForLoopTree enhancedForLoopTree2 = this.make.EnhancedForLoop(variableTree, expressionTree, statementTree);
            this.model.setType(enhancedForLoopTree2, this.model.getType(enhancedForLoopTree));
            this.copyCommentTo(enhancedForLoopTree, enhancedForLoopTree2);
            this.copyPosTo(enhancedForLoopTree, enhancedForLoopTree2);
            enhancedForLoopTree = enhancedForLoopTree2;
        }
        return enhancedForLoopTree;
    }

    protected final LabeledStatementTree rewriteChildren(LabeledStatementTree labeledStatementTree) {
        StatementTree statementTree = (StatementTree)this.translate(labeledStatementTree.getStatement());
        if (statementTree != labeledStatementTree.getStatement()) {
            LabeledStatementTree labeledStatementTree2 = this.make.LabeledStatement(labeledStatementTree.getLabel(), statementTree);
            this.model.setType(labeledStatementTree2, this.model.getType(labeledStatementTree));
            this.copyCommentTo(labeledStatementTree, labeledStatementTree2);
            this.copyPosTo(labeledStatementTree, labeledStatementTree2);
            labeledStatementTree = labeledStatementTree2;
        }
        return labeledStatementTree;
    }

    protected final SwitchTree rewriteChildren(SwitchTree switchTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(switchTree.getExpression());
        List<? extends CaseTree> list = this.translateStable(switchTree.getCases());
        if (expressionTree != switchTree.getExpression() || !((Object)list).equals(switchTree.getCases())) {
            SwitchTree switchTree2 = this.make.Switch(expressionTree, list);
            this.model.setType(switchTree2, this.model.getType(switchTree));
            this.copyCommentTo(switchTree, switchTree2);
            this.copyPosTo(switchTree, switchTree2);
            switchTree = switchTree2;
        }
        return switchTree;
    }

    protected final CaseTree rewriteChildren(CaseTree caseTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(caseTree.getExpression());
        List<? extends StatementTree> list = this.translate(caseTree.getStatements());
        if (expressionTree != caseTree.getExpression() || !((Object)list).equals(caseTree.getStatements())) {
            if (list != caseTree.getStatements()) {
                list = this.optimize(list);
            }
            CaseTree caseTree2 = this.make.Case(expressionTree, list);
            this.model.setType(caseTree2, this.model.getType(caseTree));
            this.copyCommentTo(caseTree, caseTree2);
            this.copyPosTo(caseTree, caseTree2);
            caseTree = caseTree2;
        }
        return caseTree;
    }

    protected final SynchronizedTree rewriteChildren(SynchronizedTree synchronizedTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(synchronizedTree.getExpression());
        BlockTree blockTree = (BlockTree)this.translate(synchronizedTree.getBlock());
        if (expressionTree != synchronizedTree.getExpression() || blockTree != synchronizedTree.getBlock()) {
            SynchronizedTree synchronizedTree2 = this.make.Synchronized(expressionTree, blockTree);
            this.model.setType(synchronizedTree2, this.model.getType(synchronizedTree));
            this.copyCommentTo(synchronizedTree, synchronizedTree2);
            this.copyPosTo(synchronizedTree, synchronizedTree2);
            synchronizedTree = synchronizedTree2;
        }
        return synchronizedTree;
    }

    protected final TryTree rewriteChildren(TryTree tryTree) {
        BlockTree blockTree = (BlockTree)this.translate(tryTree.getBlock());
        List<? extends CatchTree> list = this.translateStable(tryTree.getCatches());
        BlockTree blockTree2 = (BlockTree)this.translate(tryTree.getFinallyBlock());
        if (blockTree != tryTree.getBlock() || !((Object)list).equals(tryTree.getCatches()) || blockTree2 != tryTree.getFinallyBlock()) {
            TryTree tryTree2 = this.make.Try(blockTree, list, blockTree2);
            this.model.setType(tryTree2, this.model.getType(tryTree));
            this.copyCommentTo(tryTree, tryTree2);
            this.copyPosTo(tryTree, tryTree2);
            tryTree = tryTree2;
        }
        return tryTree;
    }

    protected final CatchTree rewriteChildren(CatchTree catchTree) {
        VariableTree variableTree = this.translateStable(catchTree.getParameter());
        BlockTree blockTree = (BlockTree)this.translate(catchTree.getBlock());
        if (variableTree != catchTree.getParameter() || blockTree != catchTree.getBlock()) {
            CatchTree catchTree2 = this.make.Catch(variableTree, blockTree);
            this.model.setType(catchTree2, this.model.getType(catchTree));
            this.copyCommentTo(catchTree, catchTree2);
            this.copyPosTo(catchTree, catchTree2);
            catchTree = catchTree2;
        }
        return catchTree;
    }

    protected final ConditionalExpressionTree rewriteChildren(ConditionalExpressionTree conditionalExpressionTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(conditionalExpressionTree.getCondition());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translate(conditionalExpressionTree.getTrueExpression());
        ExpressionTree expressionTree3 = (ExpressionTree)this.translate(conditionalExpressionTree.getFalseExpression());
        if (expressionTree != conditionalExpressionTree.getCondition() || expressionTree2 != conditionalExpressionTree.getTrueExpression() || expressionTree3 != conditionalExpressionTree.getFalseExpression()) {
            ConditionalExpressionTree conditionalExpressionTree2 = this.make.ConditionalExpression(expressionTree, expressionTree2, expressionTree3);
            this.model.setType(conditionalExpressionTree2, this.model.getType(conditionalExpressionTree));
            this.copyCommentTo(conditionalExpressionTree, conditionalExpressionTree2);
            this.copyPosTo(conditionalExpressionTree, conditionalExpressionTree2);
            conditionalExpressionTree = conditionalExpressionTree2;
        }
        return conditionalExpressionTree;
    }

    protected final IfTree rewriteChildren(IfTree ifTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(ifTree.getCondition());
        StatementTree statementTree = (StatementTree)this.translate(ifTree.getThenStatement());
        StatementTree statementTree2 = (StatementTree)this.translate(ifTree.getElseStatement());
        if (expressionTree != ifTree.getCondition() || statementTree != ifTree.getThenStatement() || statementTree2 != ifTree.getElseStatement()) {
            IfTree ifTree2 = this.make.If(expressionTree, statementTree, statementTree2);
            this.model.setType(ifTree2, this.model.getType(ifTree));
            this.copyCommentTo(ifTree, ifTree2);
            this.copyPosTo(ifTree, ifTree2);
            ifTree = ifTree2;
        }
        return ifTree;
    }

    protected final ExpressionStatementTree rewriteChildren(ExpressionStatementTree expressionStatementTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(expressionStatementTree.getExpression());
        if (expressionTree != expressionStatementTree.getExpression()) {
            ExpressionStatementTree expressionStatementTree2 = this.make.ExpressionStatement(expressionTree);
            this.model.setType(expressionStatementTree2, this.model.getType(expressionStatementTree));
            this.copyCommentTo(expressionStatementTree, expressionStatementTree2);
            this.copyPosTo(expressionStatementTree, expressionStatementTree2);
            expressionStatementTree = expressionStatementTree2;
        }
        return expressionStatementTree;
    }

    protected final BreakTree rewriteChildren(BreakTree breakTree) {
        return breakTree;
    }

    protected final ContinueTree rewriteChildren(ContinueTree continueTree) {
        return continueTree;
    }

    protected final ReturnTree rewriteChildren(ReturnTree returnTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(returnTree.getExpression());
        if (expressionTree != returnTree.getExpression()) {
            ReturnTree returnTree2 = this.make.Return(expressionTree);
            this.model.setType(returnTree2, this.model.getType(returnTree));
            this.copyCommentTo(returnTree, returnTree2);
            this.copyPosTo(returnTree, returnTree2);
            returnTree = returnTree2;
        }
        return returnTree;
    }

    protected final ThrowTree rewriteChildren(ThrowTree throwTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(throwTree.getExpression());
        if (expressionTree != throwTree.getExpression()) {
            ThrowTree throwTree2 = this.make.Throw(expressionTree);
            this.model.setType(throwTree2, this.model.getType(throwTree));
            this.copyCommentTo(throwTree, throwTree2);
            this.copyPosTo(throwTree, throwTree2);
            throwTree = throwTree2;
        }
        return throwTree;
    }

    protected final AssertTree rewriteChildren(AssertTree assertTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(assertTree.getCondition());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translate(assertTree.getDetail());
        if (expressionTree != assertTree.getCondition() || expressionTree2 != assertTree.getDetail()) {
            AssertTree assertTree2 = this.make.Assert(expressionTree, expressionTree2);
            this.model.setType(assertTree2, this.model.getType(assertTree));
            this.copyCommentTo(assertTree, assertTree2);
            this.copyPosTo(assertTree, assertTree2);
            assertTree = assertTree2;
        }
        return assertTree;
    }

    protected final MethodInvocationTree rewriteChildren(MethodInvocationTree methodInvocationTree) {
        List<? extends Tree> list = this.translate(methodInvocationTree.getTypeArguments());
        ExpressionTree expressionTree = (ExpressionTree)this.translate(methodInvocationTree.getMethodSelect());
        List<? extends ExpressionTree> list2 = this.translate(methodInvocationTree.getArguments());
        if (!((Object)list).equals(methodInvocationTree.getTypeArguments()) || expressionTree != methodInvocationTree.getMethodSelect() || !((Object)list2).equals(methodInvocationTree.getArguments())) {
            if (list2 != methodInvocationTree.getArguments()) {
                list2 = this.optimize(list2);
            }
            if (list != methodInvocationTree.getTypeArguments()) {
                list = this.optimize(list);
            }
            MethodInvocationTree methodInvocationTree2 = this.make.MethodInvocation(list, expressionTree, list2);
            this.model.setType(methodInvocationTree2, this.model.getType(methodInvocationTree));
            this.copyCommentTo(methodInvocationTree, methodInvocationTree2);
            methodInvocationTree = methodInvocationTree2;
            if (this.size(methodInvocationTree.getTypeArguments()) != this.size(list) && this.size(methodInvocationTree.getArguments()) != this.size(list2)) {
                this.model.setPos(methodInvocationTree, -2);
            } else {
                this.copyPosTo(methodInvocationTree, methodInvocationTree2);
            }
        }
        return methodInvocationTree;
    }

    protected final NewClassTree rewriteChildren(NewClassTree newClassTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(newClassTree.getEnclosingExpression());
        List<? extends Tree> list = this.translate(newClassTree.getTypeArguments());
        ExpressionTree expressionTree2 = this.translateClassRef(newClassTree.getIdentifier());
        List<? extends ExpressionTree> list2 = this.translate(newClassTree.getArguments());
        ClassTree classTree = this.translateStable(newClassTree.getClassBody());
        if (expressionTree != newClassTree.getEnclosingExpression() || !((Object)list).equals(newClassTree.getTypeArguments()) || expressionTree2 != newClassTree.getIdentifier() || !((Object)list2).equals(newClassTree.getArguments()) || classTree != newClassTree.getClassBody()) {
            if (list2 != newClassTree.getArguments()) {
                list2 = this.optimize(list2);
            }
            if (list != newClassTree.getTypeArguments()) {
                list = this.optimize(list);
            }
            NewClassTree newClassTree2 = this.make.NewClass(expressionTree, list, expressionTree2, list2, classTree);
            this.model.setElement(newClassTree2, this.model.getElement(newClassTree));
            this.model.setType(newClassTree2, this.model.getType(newClassTree));
            this.copyCommentTo(newClassTree, newClassTree2);
            if (this.size(newClassTree.getTypeArguments()) != this.size(list) && this.size(newClassTree.getArguments()) != this.size(list2) || classTree != newClassTree.getClassBody()) {
                this.model.setPos(newClassTree2, -2);
            } else {
                this.copyPosTo(newClassTree, newClassTree2);
            }
            newClassTree = newClassTree2;
        }
        return newClassTree;
    }

    protected final NewArrayTree rewriteChildren(NewArrayTree newArrayTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateClassRef(newArrayTree.getType());
        List<? extends ExpressionTree> list = this.translate(newArrayTree.getDimensions());
        List<? extends ExpressionTree> list2 = this.translate(newArrayTree.getInitializers());
        if (expressionTree != newArrayTree.getType() || !this.safeEquals(list, newArrayTree.getDimensions()) || !this.safeEquals(list2, newArrayTree.getInitializers())) {
            if (list2 != newArrayTree.getInitializers()) {
                list2 = this.optimize(list2);
            }
            if (list != newArrayTree.getDimensions()) {
                list = this.optimize(list);
            }
            NewArrayTree newArrayTree2 = this.make.NewArray(expressionTree, list, list2);
            this.model.setType(newArrayTree2, this.model.getType(newArrayTree));
            this.copyCommentTo(newArrayTree, newArrayTree2);
            newArrayTree = newArrayTree2;
            if (this.size(newArrayTree.getDimensions()) != this.size(list) || this.size(newArrayTree.getInitializers()) != this.size(list2)) {
                this.model.setPos(newArrayTree, -2);
            } else {
                this.copyPosTo(newArrayTree, newArrayTree2);
            }
        }
        return newArrayTree;
    }

    protected final ParenthesizedTree rewriteChildren(ParenthesizedTree parenthesizedTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(parenthesizedTree.getExpression());
        if (expressionTree != parenthesizedTree.getExpression()) {
            ParenthesizedTree parenthesizedTree2 = this.make.Parenthesized(expressionTree);
            this.model.setType(parenthesizedTree2, this.model.getType(parenthesizedTree));
            this.copyCommentTo(parenthesizedTree, parenthesizedTree2);
            this.copyPosTo(parenthesizedTree, parenthesizedTree2);
            parenthesizedTree = parenthesizedTree2;
        }
        return parenthesizedTree;
    }

    protected final AssignmentTree rewriteChildren(AssignmentTree assignmentTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(assignmentTree.getVariable());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translate(assignmentTree.getExpression());
        if (expressionTree != assignmentTree.getVariable() || expressionTree2 != assignmentTree.getExpression()) {
            AssignmentTree assignmentTree2 = this.make.Assignment(expressionTree, expressionTree2);
            this.model.setType(assignmentTree2, this.model.getType(assignmentTree));
            this.copyCommentTo(assignmentTree, assignmentTree2);
            this.copyPosTo(assignmentTree, assignmentTree2);
            assignmentTree = assignmentTree2;
        }
        return assignmentTree;
    }

    protected final CompoundAssignmentTree rewriteChildren(CompoundAssignmentTree compoundAssignmentTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(compoundAssignmentTree.getVariable());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translate(compoundAssignmentTree.getExpression());
        if (expressionTree != compoundAssignmentTree.getVariable() || expressionTree2 != compoundAssignmentTree.getExpression()) {
            CompoundAssignmentTree compoundAssignmentTree2 = this.make.CompoundAssignment(compoundAssignmentTree.getKind(), expressionTree, expressionTree2);
            this.model.setType(compoundAssignmentTree2, this.model.getType(compoundAssignmentTree));
            this.copyCommentTo(compoundAssignmentTree, compoundAssignmentTree2);
            this.copyPosTo(compoundAssignmentTree, compoundAssignmentTree2);
            compoundAssignmentTree = compoundAssignmentTree2;
        }
        return compoundAssignmentTree;
    }

    protected final UnaryTree rewriteChildren(UnaryTree unaryTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(unaryTree.getExpression());
        if (expressionTree != unaryTree.getExpression()) {
            UnaryTree unaryTree2 = this.make.Unary(unaryTree.getKind(), expressionTree);
            this.model.setType(unaryTree2, this.model.getType(unaryTree));
            this.copyCommentTo(unaryTree, unaryTree2);
            this.copyPosTo(unaryTree, unaryTree2);
            unaryTree = unaryTree2;
        }
        return unaryTree;
    }

    protected final BinaryTree rewriteChildren(BinaryTree binaryTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(binaryTree.getLeftOperand());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translate(binaryTree.getRightOperand());
        if (expressionTree != binaryTree.getLeftOperand() || expressionTree2 != binaryTree.getRightOperand()) {
            BinaryTree binaryTree2 = this.make.Binary(binaryTree.getKind(), expressionTree, expressionTree2);
            this.model.setType(binaryTree2, this.model.getType(binaryTree));
            this.copyCommentTo(binaryTree, binaryTree2);
            this.copyPosTo(binaryTree, binaryTree2);
            binaryTree = binaryTree2;
        }
        return binaryTree;
    }

    protected final TypeCastTree rewriteChildren(TypeCastTree typeCastTree) {
        Tree tree = this.translateClassRef(typeCastTree.getType());
        ExpressionTree expressionTree = (ExpressionTree)this.translate(typeCastTree.getExpression());
        if (tree != typeCastTree.getType() || expressionTree != typeCastTree.getExpression()) {
            TypeCastTree typeCastTree2 = this.make.TypeCast(tree, expressionTree);
            this.model.setType(typeCastTree2, this.model.getType(typeCastTree));
            this.copyCommentTo(typeCastTree, typeCastTree2);
            this.copyPosTo(typeCastTree, typeCastTree2);
            typeCastTree = typeCastTree2;
        }
        return typeCastTree;
    }

    protected final InstanceOfTree rewriteChildren(InstanceOfTree instanceOfTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(instanceOfTree.getExpression());
        Tree tree = this.translateClassRef(instanceOfTree.getType());
        if (expressionTree != instanceOfTree.getExpression() || tree != instanceOfTree.getType()) {
            InstanceOfTree instanceOfTree2 = this.make.InstanceOf(expressionTree, tree);
            this.model.setType(instanceOfTree2, this.model.getType(instanceOfTree));
            this.copyCommentTo(instanceOfTree, instanceOfTree2);
            this.copyPosTo(instanceOfTree, instanceOfTree2);
            instanceOfTree = instanceOfTree2;
        }
        return instanceOfTree;
    }

    protected final ArrayAccessTree rewriteChildren(ArrayAccessTree arrayAccessTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translate(arrayAccessTree.getExpression());
        ExpressionTree expressionTree2 = (ExpressionTree)this.translate(arrayAccessTree.getIndex());
        if (expressionTree != arrayAccessTree.getExpression() || expressionTree2 != arrayAccessTree.getIndex()) {
            ArrayAccessTree arrayAccessTree2 = this.make.ArrayAccess(expressionTree, expressionTree2);
            this.model.setType(arrayAccessTree2, this.model.getType(arrayAccessTree));
            this.copyCommentTo(arrayAccessTree, arrayAccessTree2);
            this.copyPosTo(arrayAccessTree, arrayAccessTree2);
            arrayAccessTree = arrayAccessTree2;
        }
        return arrayAccessTree;
    }

    protected final MemberSelectTree rewriteChildren(MemberSelectTree memberSelectTree) {
        ExpressionTree expressionTree = this.translateClassRef(memberSelectTree.getExpression());
        if (expressionTree != memberSelectTree.getExpression()) {
            MemberSelectTree memberSelectTree2 = this.make.MemberSelect(expressionTree, memberSelectTree.getIdentifier());
            this.model.setElement(memberSelectTree2, this.model.getElement(memberSelectTree));
            this.model.setType(memberSelectTree2, this.model.getType(memberSelectTree));
            this.copyCommentTo(memberSelectTree, memberSelectTree2);
            this.copyPosTo(memberSelectTree, memberSelectTree2);
            memberSelectTree = memberSelectTree2;
        }
        return memberSelectTree;
    }

    protected final IdentifierTree rewriteChildren(IdentifierTree identifierTree) {
        return identifierTree;
    }

    protected final LiteralTree rewriteChildren(LiteralTree literalTree) {
        return literalTree;
    }

    protected final PrimitiveTypeTree rewriteChildren(PrimitiveTypeTree primitiveTypeTree) {
        return primitiveTypeTree;
    }

    protected final ArrayTypeTree rewriteChildren(ArrayTypeTree arrayTypeTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateClassRef(arrayTypeTree.getType());
        if (expressionTree != arrayTypeTree.getType()) {
            ArrayTypeTree arrayTypeTree2 = this.make.ArrayType(expressionTree);
            this.model.setType(arrayTypeTree2, this.model.getType(arrayTypeTree));
            this.copyCommentTo(arrayTypeTree, arrayTypeTree2);
            this.copyPosTo(arrayTypeTree, arrayTypeTree2);
            arrayTypeTree = arrayTypeTree2;
        }
        return arrayTypeTree;
    }

    protected final ParameterizedTypeTree rewriteChildren(ParameterizedTypeTree parameterizedTypeTree) {
        ExpressionTree expressionTree = (ExpressionTree)this.translateClassRef(parameterizedTypeTree.getType());
        List<? extends Tree> list = this.translate(parameterizedTypeTree.getTypeArguments());
        if (expressionTree != parameterizedTypeTree.getType() || !((Object)list).equals(parameterizedTypeTree.getTypeArguments())) {
            if (list != parameterizedTypeTree.getTypeArguments()) {
                list = this.optimize(list);
            }
            ParameterizedTypeTree parameterizedTypeTree2 = this.make.ParameterizedType(expressionTree, list);
            this.model.setType(parameterizedTypeTree2, this.model.getType(parameterizedTypeTree));
            this.copyCommentTo(parameterizedTypeTree, parameterizedTypeTree2);
            parameterizedTypeTree = parameterizedTypeTree2;
            if (parameterizedTypeTree.getTypeArguments().size() != list.size()) {
                this.model.setPos(parameterizedTypeTree, -2);
            } else {
                this.copyPosTo(parameterizedTypeTree, parameterizedTypeTree2);
            }
        }
        return parameterizedTypeTree;
    }

    protected final TypeParameterTree rewriteChildren(TypeParameterTree typeParameterTree) {
        List<? extends Tree> list = this.translate(typeParameterTree.getBounds());
        if (!((Object)list).equals(typeParameterTree.getBounds())) {
            list = this.optimize(list);
            TypeParameterTree typeParameterTree2 = this.make.TypeParameter(typeParameterTree.getName(), list);
            this.model.setType(typeParameterTree2, this.model.getType(typeParameterTree));
            this.copyCommentTo(typeParameterTree, typeParameterTree2);
            typeParameterTree = typeParameterTree2;
            if (typeParameterTree.getBounds().size() != list.size()) {
                this.model.setPos(typeParameterTree, -2);
            } else {
                this.copyPosTo(typeParameterTree, typeParameterTree2);
            }
        }
        return typeParameterTree;
    }

    protected final WildcardTree rewriteChildren(WildcardTree wildcardTree) {
        Tree tree = this.translateClassRef(wildcardTree.getBound());
        if (tree != wildcardTree.getBound()) {
            WildcardTree wildcardTree2 = this.make.Wildcard(wildcardTree.getKind(), tree);
            this.model.setType(wildcardTree2, this.model.getType(wildcardTree));
            this.copyCommentTo(wildcardTree, wildcardTree2);
            this.copyPosTo(wildcardTree, wildcardTree2);
            wildcardTree = wildcardTree2;
        }
        return wildcardTree;
    }

    protected final AnnotationTree rewriteChildren(AnnotationTree annotationTree) {
        Tree tree = this.translate(annotationTree.getAnnotationType());
        List<? extends ExpressionTree> list = this.translate(annotationTree.getArguments());
        if (tree != annotationTree.getAnnotationType() || !((Object)list).equals(annotationTree.getArguments())) {
            if (list != annotationTree.getArguments()) {
                list = this.optimize(list);
            }
            AnnotationTree annotationTree2 = this.make.Annotation(tree, list);
            this.model.setType(annotationTree2, this.model.getType(annotationTree));
            this.copyCommentTo(annotationTree, annotationTree2);
            annotationTree = annotationTree2;
            if (annotationTree.getArguments().size() != list.size()) {
                this.model.setPos(annotationTree, -2);
            } else {
                this.copyPosTo(annotationTree, annotationTree2);
            }
        }
        return annotationTree;
    }

    protected final ModifiersTree rewriteChildren(ModifiersTree modifiersTree) {
        List<? extends AnnotationTree> list = this.translateStable(modifiersTree.getAnnotations());
        if (!((Object)list).equals(modifiersTree.getAnnotations())) {
            ModifiersTree modifiersTree2 = this.make.Modifiers(modifiersTree, list);
            this.model.setType(modifiersTree2, this.model.getType(modifiersTree));
            this.copyCommentTo(modifiersTree, modifiersTree2);
            this.copyPosTo(modifiersTree, modifiersTree2);
            modifiersTree = modifiersTree2;
        }
        return modifiersTree;
    }

    protected final ErroneousTree rewriteChildren(ErroneousTree erroneousTree) {
        List<? extends Tree> list = erroneousTree.getErrorTrees();
        List<? extends Tree> list2 = this.translate(list);
        if (!((Object)list2).equals(list)) {
            ErroneousTree erroneousTree2 = this.make.Erroneous(list2);
            this.model.setType(erroneousTree2, this.model.getType(erroneousTree));
            this.copyCommentTo(erroneousTree, erroneousTree2);
            this.copyPosTo(erroneousTree, erroneousTree2);
            erroneousTree = erroneousTree2;
        }
        return erroneousTree;
    }
}

