/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManagerEvent;
import org.netbeans.modules.java.source.usages.ClassIndexManagerListener;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.PersistentClassIndex;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassIndexManager {
    private static final byte OP_ADD = 1;
    private static final byte OP_REMOVE = 2;
    private static ClassIndexManager instance;
    private final Map<URL, ClassIndexImpl> instances = new HashMap<URL, ClassIndexImpl>();
    private final ReentrantReadWriteLock lock;
    private final List<ClassIndexManagerListener> listeners = new CopyOnWriteArrayList<ClassIndexManagerListener>();
    private boolean invalid;
    private Set<URL> added;
    private Set<URL> removed;
    private int depth = 0;

    private ClassIndexManager() {
        this.lock = new ReentrantReadWriteLock(false);
    }

    public void addClassIndexManagerListener(ClassIndexManagerListener classIndexManagerListener) {
        assert (classIndexManagerListener != null);
        this.listeners.add(classIndexManagerListener);
    }

    public void removeClassIndexManagerListener(ClassIndexManagerListener classIndexManagerListener) {
        assert (classIndexManagerListener != null);
        this.listeners.remove(classIndexManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public <T> T writeLock(ExceptionAction<T> exceptionAction) throws IOException, InterruptedException {
        this.lock.writeLock().lock();
        try {
            T t;
            block12: {
                ++this.depth;
                if (this.depth == 1) {
                    this.added = new HashSet<URL>();
                    this.removed = new HashSet<URL>();
                }
                t = exceptionAction.run();
                {
                    Object var4_3 = null;
                    if (this.depth != 1) break block12;
                    if (!this.removed.isEmpty()) {
                        this.fire(this.removed, (byte)2);
                        this.removed.clear();
                    }
                    if (this.added.isEmpty()) break block12;
                    this.fire(this.added, (byte)1);
                    this.added.clear();
                }
            }
            Object var6_5 = null;
            --this.depth;
            Object var8_7 = null;
            this.lock.writeLock().unlock();
            return t;
            {
                catch (Throwable throwable) {
                    try {
                        Object var4_4 = null;
                        if (this.depth == 1) {
                            if (!this.removed.isEmpty()) {
                                this.fire(this.removed, (byte)2);
                                this.removed.clear();
                            }
                            if (!this.added.isEmpty()) {
                                this.fire(this.added, (byte)1);
                                this.added.clear();
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        Object var6_6 = null;
                        --this.depth;
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readLock(ExceptionAction<T> exceptionAction) throws IOException, InterruptedException {
        T t;
        this.lock.readLock().lock();
        try {
            t = exceptionAction.run();
            Object var4_3 = null;
            this.lock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
        return t;
    }

    public boolean holdsWriteLock() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    public synchronized ClassIndexImpl getUsagesQuery(URL uRL) {
        assert (uRL != null);
        if (this.invalid) {
            return null;
        }
        return this.instances.get(uRL);
    }

    public synchronized ClassIndexImpl createUsagesQuery(URL uRL, boolean bl) throws IOException {
        assert (uRL != null);
        if (this.invalid) {
            return null;
        }
        ClassIndexImpl classIndexImpl = this.instances.get(uRL);
        if (classIndexImpl == null) {
            classIndexImpl = PersistentClassIndex.create(uRL, Index.getDataFolder(uRL), bl);
            this.instances.put(uRL, classIndexImpl);
            if (this.added != null) {
                this.added.add(uRL);
            }
        } else if (bl && !classIndexImpl.isSource()) {
            classIndexImpl.close();
            classIndexImpl = PersistentClassIndex.create(uRL, Index.getDataFolder(uRL), bl);
            this.instances.put(uRL, classIndexImpl);
            if (this.added != null) {
                this.added.add(uRL);
            }
        }
        return classIndexImpl;
    }

    synchronized void removeRoot(URL uRL) throws IOException {
        ClassIndexImpl classIndexImpl = this.instances.remove(uRL);
        if (classIndexImpl != null) {
            classIndexImpl.close();
            if (this.removed != null) {
                this.removed.add(uRL);
            }
        }
    }

    public synchronized void close() {
        this.invalid = true;
        for (ClassIndexImpl classIndexImpl : this.instances.values()) {
            try {
                classIndexImpl.close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private void fire(Set<? extends URL> set, byte by) {
        if (!this.listeners.isEmpty()) {
            ClassIndexManagerEvent classIndexManagerEvent = new ClassIndexManagerEvent(this, set);
            for (ClassIndexManagerListener classIndexManagerListener : this.listeners) {
                if (by == 1) {
                    classIndexManagerListener.classIndexAdded(classIndexManagerEvent);
                    continue;
                }
                if (by == 2) {
                    classIndexManagerListener.classIndexRemoved(classIndexManagerEvent);
                    continue;
                }
                assert (false) : "Unknown op: " + by;
            }
        }
    }

    public static synchronized ClassIndexManager getDefault() {
        if (instance == null) {
            instance = new ClassIndexManager();
        }
        return instance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExceptionAction<T> {
        public T run() throws IOException, InterruptedException;
    }
}

