/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.actions.BuildToolsAction;
import org.netbeans.modules.cnd.actions.ShellRunAction;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.api.utils.RemoteUtils;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.CustomProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.DefaultProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.RunDialogPanel;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.ui.utils.ConfSelectorPanel;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.modules.cnd.ui.options.LocalToolsPanelModel;
import org.netbeans.modules.cnd.ui.options.ToolsPanel;
import org.netbeans.modules.cnd.ui.options.ToolsPanelModel;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class MakeActionProvider
implements ActionProvider {
    public static final String COMMAND_BATCH_BUILD = "batch_build";
    public static final String COMMAND_BUILD_PACKAGE = "build_packages";
    public static final String COMMAND_DEBUG_LOAD_ONLY = "debug.load.only";
    public static final String COMMAND_CUSTOM_ACTION = "custom.action";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.stepinto", "debug.load.only", "debug.single", "batch_build", "build_packages", "delete", "copy", "move", "rename", "custom.action"};
    MakeProject project;
    ConfigurationDescriptor projectDescriptor = null;
    Map<String, String[]> commands = new HashMap<String, String[]>();
    Map<String, String[]> commandsNoBuild;
    private boolean lastValidation = false;
    private static ResourceBundle bundle;

    public MakeActionProvider(MakeProject makeProject) {
        this.commands.put("build", new String[]{"save", "build"});
        this.commands.put(COMMAND_BUILD_PACKAGE, new String[]{"save", "build", "build-package"});
        this.commands.put("clean", new String[]{"save", "clean"});
        this.commands.put("rebuild", new String[]{"save", "clean", "build"});
        this.commands.put("run", new String[]{"save", "build", "run"});
        this.commands.put("debug", new String[]{"save", "build", "debug"});
        this.commands.put("debug.stepinto", new String[]{"save", "build", "debug-stepinto"});
        this.commands.put(COMMAND_DEBUG_LOAD_ONLY, new String[]{"save", "build", "debug-load-only"});
        this.commands.put("run.single", new String[]{"run-single"});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.commands.put("compile.single", new String[]{"save", "compile-single"});
        this.commands.put(COMMAND_CUSTOM_ACTION, new String[]{"save", "build", "custom-action"});
        this.commandsNoBuild = new HashMap<String, String[]>();
        this.commandsNoBuild.put("build", new String[]{"save", "build-package"});
        this.commandsNoBuild.put(COMMAND_BUILD_PACKAGE, new String[]{"save", "build"});
        this.commandsNoBuild.put("clean", new String[]{"save", "clean"});
        this.commandsNoBuild.put("rebuild", new String[]{"save", "clean", "build"});
        this.commandsNoBuild.put("run", new String[]{"run"});
        this.commandsNoBuild.put("debug", new String[]{"debug"});
        this.commandsNoBuild.put("debug.stepinto", new String[]{"debug-stepinto"});
        this.commandsNoBuild.put(COMMAND_DEBUG_LOAD_ONLY, new String[]{"debug-load-only"});
        this.commandsNoBuild.put(COMMAND_CUSTOM_ACTION, new String[]{"save", "custom-action"});
        this.project = makeProject;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject("build.xml");
    }

    private boolean isProjectDescriptorLoaded() {
        if (this.projectDescriptor == null) {
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            return configurationDescriptorProvider.gotDescriptor();
        }
        return true;
    }

    private MakeConfigurationDescriptor getProjectDescriptor() {
        if (this.projectDescriptor == null) {
            ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            this.projectDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
        }
        return (MakeConfigurationDescriptor)this.projectDescriptor;
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(final String string, final Lookup lookup) throws IllegalArgumentException {
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        if ("run.single".equals(string)) {
            Node node = (Node)lookup.lookup(Node.class);
            if (node != null) {
                ShellRunAction.performAction((Node)node);
            }
            return;
        }
        ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        final String string2 = projectInformation.getDisplayName();
        final MakeConfigurationDescriptor makeConfigurationDescriptor = this.getProjectDescriptor();
        final MakeConfiguration makeConfiguration = (MakeConfiguration)makeConfigurationDescriptor.getConfs().getActive();
        Runnable runnable = new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                ArrayList arrayList = new ArrayList();
                if (string.equals(MakeActionProvider.COMMAND_BATCH_BUILD)) {
                    BatchConfigurationSelector batchConfigurationSelector = new BatchConfigurationSelector(makeConfigurationDescriptor.getConfs().getConfs());
                    String string3 = batchConfigurationSelector.getCommand();
                    Configuration[] configurationArray = batchConfigurationSelector.getSelectedConfs();
                    if (string3 == null || configurationArray == null) return;
                    for (int i = 0; i < configurationArray.length; ++i) {
                        MakeActionProvider.this.addAction(arrayList, string2, makeConfigurationDescriptor, (MakeConfiguration)configurationArray[i], string3, lookup);
                    }
                } else {
                    MakeActionProvider.this.addAction(arrayList, string2, makeConfigurationDescriptor, makeConfiguration, string, lookup);
                }
                if (arrayList.size() <= 0) return;
                ProjectActionSupport.fireActionPerformed(arrayList.toArray(new ProjectActionEvent[arrayList.size()]));
            }
        };
        MakeActionProvider.runActionWorker(makeConfiguration.getDevelopmentHost().getName(), runnable);
    }

    private static void runActionWorker(String string, Runnable runnable) {
        if (RemoteUtils.isLocalhost((String)string)) {
            runnable.run();
        } else {
            ServerList serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class);
            assert (serverList != null);
            ServerRecord serverRecord = serverList.get(string);
            assert (serverRecord != null);
            MakeActionProvider.invokeRemoteHostAction(serverRecord, runnable);
        }
    }

    public void invokeCustomAction(final String string, final MakeConfigurationDescriptor makeConfigurationDescriptor, final MakeConfiguration makeConfiguration, final CustomProjectActionHandler customProjectActionHandler) {
        Runnable runnable = new Runnable(){

            public void run() {
                ArrayList arrayList = new ArrayList();
                MakeActionProvider.this.addAction(arrayList, string, makeConfigurationDescriptor, makeConfiguration, MakeActionProvider.COMMAND_CUSTOM_ACTION, null);
                ActionEvent actionEvent = new ActionEvent(arrayList.toArray(new ProjectActionEvent[arrayList.size()]), 0, null);
                DefaultProjectActionHandler defaultProjectActionHandler = new DefaultProjectActionHandler();
                defaultProjectActionHandler.setCustomActionHandlerProvider(customProjectActionHandler);
                defaultProjectActionHandler.actionPerformed(actionEvent);
            }
        };
        MakeActionProvider.runActionWorker(makeConfiguration.getDevelopmentHost().getName(), runnable);
    }

    private static void invokeRemoteHostAction(final ServerRecord serverRecord, final Runnable runnable) {
        if (!serverRecord.isDeleted() && serverRecord.isOnline()) {
            runnable.run();
        } else {
            Frame frame;
            int n = 1;
            if (serverRecord.isDeleted()) {
                String string = MessageFormat.format(MakeActionProvider.getString("ERR_RequestingDeletedConnection"), serverRecord.getName());
                n = JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), string, MakeActionProvider.getString("DLG_TITLE_DeletedConnection"), 0);
                if (n == 0) {
                    frame = (ServerList)Lookup.getDefault().lookup(ServerList.class);
                    assert (frame != null);
                    frame.addServer(serverRecord.getName(), false, true);
                }
            } else if (!serverRecord.isOnline()) {
                String string = MessageFormat.format(MakeActionProvider.getString("ERR_NeedToInitializeRemoteHost"), serverRecord.getName());
                n = JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), string, MakeActionProvider.getString("DLG_TITLE_Connect"), 0);
            }
            if (n == 0) {
                frame = WindowManager.getDefault().getMainWindow();
                Runnable runnable2 = new Runnable(){

                    public void run() {
                        try {
                            serverRecord.validate(true);
                            CompilerSetManager compilerSetManager = CompilerSetManager.getDefault((String)serverRecord.getName());
                            compilerSetManager.initialize(true);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                };
                Runnable runnable3 = new Runnable(){

                    public void run() {
                        if (serverRecord.isOnline()) {
                            runnable.run();
                        }
                    }
                };
                String string = NbBundle.getMessage(MakeActionProvider.class, (String)"MSG_Configure_Host_Progress", (Object)serverRecord.getName());
                ModalMessageDlg.runLongTask((Frame)frame, (Runnable)runnable2, (Runnable)runnable3, (String)NbBundle.getMessage(MakeActionProvider.class, (String)"DLG_TITLE_Configure_Host"), (String)string);
            }
        }
    }

    public void addAction(ArrayList arrayList, String string, MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, String string2, Lookup lookup) throws IllegalArgumentException {
        boolean bl = false;
        this.lastValidation = false;
        String[] stringArray = this.getTargetNames(string2, lookup);
        if (stringArray == null) {
            return;
        }
        if (stringArray.length == 0) {
            stringArray = null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            Object object2;
            Object object3;
            Object object42;
            Object object5;
            String string3 = stringArray[i];
            int n = string3.equals("build") ? 0 : (string3.equals("build-package") ? 0 : (string3.equals("clean") ? 1 : (string3.equals("compile-single") ? 0 : (string3.equals("run") ? 2 : (string3.equals("run-single") ? 2 : (string3.equals("debug") ? 3 : (string3.equals("debug-stepinto") ? 4 : (string3.equals("debug-load-only") ? 5 : (string3.equals("custom-action") ? 6 : 2)))))))));
            PlatformInfo platformInfo = makeConfiguration.getPlatformInfo();
            if (string3.equals("save")) {
                if (MakeOptions.getInstance().getSave()) {
                    LifecycleManager.getDefault().saveAll();
                }
                if (ProjectSupport.saveAllProjects(MakeActionProvider.getString("NeedToSaveAllText"))) continue;
                return;
            }
            if (string3.equals("run") || string3.equals("debug") || string3.equals("debug-stepinto") || string3.equals("debug-load-only")) {
                if (!this.validateBuildSystem(makeConfigurationDescriptor, makeConfiguration, bl)) {
                    return;
                }
                bl = true;
                if (makeConfiguration.isMakefileConfiguration()) {
                    if (string3.equals("run")) {
                        object5 = makeConfiguration.getMakefileConfiguration().getOutput().getValue();
                        if (((String)object5).length() > 0 && !IpeUtils.isPathAbsolute((String)object5)) {
                            object5 = makeConfiguration.getMakefileConfiguration().getAbsOutput();
                            object5 = IpeUtils.toRelativePath((String)makeConfiguration.getProfile().getRunDirectory(), (String)object5);
                        }
                    } else {
                        object5 = makeConfiguration.getMakefileConfiguration().getAbsOutput();
                    }
                    object42 = new ProjectActionEvent(this.project, n, MakeActionProvider.getActionName(string, string3, makeConfiguration), (String)object5, makeConfiguration, null, false);
                    arrayList.add(object42);
                    RunDialogPanel.addElementToExecutablePicklist((String)object5);
                    continue;
                }
                if (makeConfiguration.isLibraryConfiguration()) {
                    assert (false);
                    return;
                }
                if (makeConfiguration.isCompileConfiguration()) {
                    Object object6;
                    object5 = null;
                    if (makeConfiguration.getPlatform().getValue() == 3) {
                        object5 = makeConfiguration.getProfile().cloneProfile();
                        object42 = makeConfiguration.getSubProjectOutputLocations();
                        object3 = "";
                        object6 = object42.iterator();
                        while (object6.hasNext()) {
                            object2 = FilePathAdaptor.naturalize((String)object6.next());
                            object3 = (String)object2 + ";" + (String)object3;
                        }
                        object2 = ((RunProfile)object5).getEnvironment().getenv(platformInfo.getPathName());
                        if (object2 == null) {
                            object2 = (String)HostInfoProvider.getDefault().getEnv(makeConfiguration.getDevelopmentHost().getName()).get(platformInfo.getPathName());
                        }
                        object3 = (String)object3 + ";" + (String)object2;
                        ((RunProfile)object5).getEnvironment().putenv(platformInfo.getPathName(), (String)object3);
                    } else if (Platforms.getPlatform(makeConfiguration.getPlatform().getValue()).getId() == 4) {
                        object42 = makeConfiguration.getSubProjectOutputLocations();
                        object3 = object42.iterator();
                        if (object3.hasNext()) {
                            String string4 = (String)HostInfoProvider.getDefault().getEnv(makeConfiguration.getDevelopmentHost().getName()).get("DYLD_LIBRARY_PATH");
                            object5 = makeConfiguration.getProfile().cloneProfile();
                            object2 = new StringBuffer();
                            while (object3.hasNext()) {
                                object = FilePathAdaptor.naturalize((String)object3.next());
                                if (((StringBuffer)object2).length() > 0) {
                                    ((StringBuffer)object2).append(":");
                                }
                                ((StringBuffer)object2).append((String)object);
                            }
                            if (string4 != null) {
                                ((StringBuffer)object2).append(":" + string4);
                            }
                            ((RunProfile)object5).getEnvironment().putenv("DYLD_LIBRARY_PATH", ((StringBuffer)object2).toString());
                        }
                        if (HostInfoProvider.getDefault().getEnv(makeConfiguration.getDevelopmentHost().getName()).get("DISPLAY") == null && makeConfiguration.getProfile().getEnvironment().getenv("DISPLAY") == null) {
                            if (object5 == null) {
                                object5 = makeConfiguration.getProfile().cloneProfile();
                            }
                            ((RunProfile)object5).getEnvironment().putenv("DISPLAY", ":0.0");
                        }
                    }
                    object42 = new MakeArtifact(makeConfigurationDescriptor, makeConfiguration);
                    if (string3.equals("run")) {
                        object3 = ((MakeArtifact)object42).getOutput();
                        if (makeConfiguration.getDevelopmentHost().isLocalhost() && !IpeUtils.isPathAbsolute((String)object3)) {
                            object3 = ((MakeArtifact)object42).getWorkingDirectory() + "/" + (String)object3;
                            object3 = FilePathAdaptor.naturalize((String)object3);
                            object3 = IpeUtils.toRelativePath((String)makeConfiguration.getProfile().getRunDirectory(), (String)object3);
                            object3 = FilePathAdaptor.naturalize((String)object3);
                        }
                    } else {
                        object3 = IpeUtils.toAbsolutePath((String)makeConfiguration.getBaseDir(), (String)((MakeArtifact)object42).getOutput());
                    }
                    object6 = new ProjectActionEvent(this.project, n, MakeActionProvider.getActionName(string, string3, makeConfiguration), (String)object3, makeConfiguration, (RunProfile)object5, false);
                    arrayList.add(object6);
                    RunDialogPanel.addElementToExecutablePicklist((String)object3);
                    continue;
                }
                assert (false);
                continue;
            }
            if (string3.equals("run-single") || string3.equals("debug-single")) {
                if (makeConfiguration.isMakefileConfiguration()) {
                    object5 = lookup.lookup(new Lookup.Template(DataObject.class)).allInstances().iterator();
                    object42 = (DataObject)object5.next();
                    object3 = FileUtil.toFile((FileObject)object42.getPrimaryFile()).getPath();
                    ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, n, MakeActionProvider.getActionName(string, "run", makeConfiguration), (String)object3, makeConfiguration, null, false);
                    arrayList.add(projectActionEvent);
                    RunDialogPanel.addElementToExecutablePicklist((String)object3);
                    continue;
                }
                assert (false);
                continue;
            }
            if (string3.equals("build")) {
                if (makeConfiguration.isCompileConfiguration() && !this.validateProject(makeConfiguration)) break;
                if (this.validateBuildSystem(makeConfigurationDescriptor, makeConfiguration, bl)) {
                    object5 = new MakeArtifact(makeConfigurationDescriptor, makeConfiguration);
                    object42 = ((MakeArtifact)object5).getBuildCommand(MakeActionProvider.getMakeCommand(makeConfigurationDescriptor, makeConfiguration), "");
                    object3 = "";
                    int n2 = ((String)object42).indexOf(32);
                    if (n2 > 0) {
                        object3 = ((String)object42).substring(n2 + 1);
                        object42 = ((String)object42).substring(0, n2);
                    }
                } else {
                    return;
                }
                object2 = new RunProfile(((MakeArtifact)object5).getWorkingDirectory(), makeConfiguration.getPlatform().getValue());
                ((RunProfile)object2).setArgs((String)object3);
                object = new ProjectActionEvent(this.project, n, MakeActionProvider.getActionName(string, string3, makeConfiguration), (String)object42, makeConfiguration, (RunProfile)object2, true);
                arrayList.add(object);
                bl = true;
                continue;
            }
            if (string3.equals("build-package")) {
                if (!this.validatePackaging(makeConfiguration)) {
                    arrayList.clear();
                    break;
                }
                if (makeConfiguration.getPlatform().getValue() == 3) {
                    object5 = "cmd.exe";
                    object42 = "/c sh";
                } else {
                    object5 = "bash";
                    object42 = "";
                }
                if (makeConfiguration.getPackagingConfiguration().getVerbose().getValue()) {
                    object42 = (String)object42 + " -x ";
                }
                object42 = (String)object42 + "nbproject/Package-" + makeConfiguration.getName() + ".bash";
                object3 = new RunProfile(makeConfiguration.getBaseDir(), makeConfiguration.getPlatform().getValue());
                ((RunProfile)object3).setArgs((String)object42);
                ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, n, MakeActionProvider.getActionName(string, string3, makeConfiguration), (String)object5, makeConfiguration, (RunProfile)object3, true);
                arrayList.add(projectActionEvent);
                continue;
            }
            if (string3.equals("clean")) {
                if (this.validateBuildSystem(makeConfigurationDescriptor, makeConfiguration, bl)) {
                    object5 = new MakeArtifact(makeConfigurationDescriptor, makeConfiguration);
                    object42 = ((MakeArtifact)object5).getCleanCommand(MakeActionProvider.getMakeCommand(makeConfigurationDescriptor, makeConfiguration), "");
                    object3 = "";
                    int n3 = ((String)object42).indexOf(32);
                    if (n3 > 0) {
                        object3 = ((String)object42).substring(n3 + 1);
                        object42 = ((String)object42).substring(0, n3);
                    }
                } else {
                    return;
                }
                object2 = new RunProfile(((MakeArtifact)object5).getWorkingDirectory(), makeConfiguration.getPlatform().getValue());
                ((RunProfile)object2).setArgs((String)object3);
                object = new ProjectActionEvent(this.project, n, MakeActionProvider.getActionName(string, string3, makeConfiguration), (String)object42, makeConfiguration, (RunProfile)object2, true);
                arrayList.add(object);
                bl = true;
                continue;
            }
            if (string3.equals("compile-single")) {
                if (this.validateBuildSystem(makeConfigurationDescriptor, makeConfiguration, bl)) {
                    for (Object object42 : lookup.lookup(new Lookup.Template(Node.class)).allInstances()) {
                        String string5;
                        Object object7;
                        object3 = this.getNoteItem((Node)object42);
                        if (object3 == null) {
                            return;
                        }
                        ItemConfiguration itemConfiguration = ((Item)object3).getItemConfiguration(makeConfiguration);
                        if (itemConfiguration == null) {
                            return;
                        }
                        if (itemConfiguration.getExcluded().getValue()) {
                            return;
                        }
                        if (itemConfiguration.getTool() == 3 && !itemConfiguration.getCustomToolConfiguration().getModified()) {
                            return;
                        }
                        object2 = new MakeArtifact(makeConfigurationDescriptor, makeConfiguration);
                        object = null;
                        if (itemConfiguration.getTool() == 0) {
                            object7 = itemConfiguration.getCCompilerConfiguration();
                            object = ((BasicCompilerConfiguration)object7).getOutputFile((Item)object3, makeConfiguration, true);
                        } else if (itemConfiguration.getTool() == 1) {
                            object7 = itemConfiguration.getCCCompilerConfiguration();
                            object = ((BasicCompilerConfiguration)object7).getOutputFile((Item)object3, makeConfiguration, true);
                        } else if (itemConfiguration.getTool() == 2) {
                            object7 = itemConfiguration.getFortranCompilerConfiguration();
                            object = ((BasicCompilerConfiguration)object7).getOutputFile((Item)object3, makeConfiguration, true);
                        } else if (itemConfiguration.getTool() == 3) {
                            object7 = itemConfiguration.getCustomToolConfiguration();
                            object = ((CustomToolConfiguration)object7).getOutputs().getValue();
                        }
                        object = makeConfiguration.expandMacros((String)object);
                        if (makeConfiguration.getPlatform().getValue() == 3) {
                            object7 = "cmd.exe";
                            string5 = "/c rm -rf " + (String)object;
                        } else {
                            object7 = "rm";
                            string5 = "-rf " + (String)object;
                        }
                        RunProfile runProfile = new RunProfile(((MakeArtifact)object2).getWorkingDirectory(), makeConfiguration.getPlatform().getValue());
                        runProfile.setArgs(string5);
                        ProjectActionEvent projectActionEvent = new ProjectActionEvent(this.project, 1, MakeActionProvider.getActionName(string, "clean", makeConfiguration), (String)object7, makeConfiguration, runProfile, true);
                        arrayList.add(projectActionEvent);
                        object7 = MakeActionProvider.getMakeCommand(makeConfigurationDescriptor, makeConfiguration) + " -f nbproject" + '/' + "Makefile-" + makeConfiguration.getName() + ".mk " + (String)object;
                        string5 = "";
                        int n4 = ((String)object7).indexOf(32);
                        if (n4 > 0) {
                            string5 = ((String)object7).substring(n4 + 1);
                            object7 = ((String)object7).substring(0, n4);
                        }
                        runProfile = new RunProfile(((MakeArtifact)object2).getWorkingDirectory(), makeConfiguration.getPlatform().getValue());
                        runProfile.setArgs(string5);
                        projectActionEvent = new ProjectActionEvent(this.project, n, MakeActionProvider.getActionName(string, string3, makeConfiguration), (String)object7, makeConfiguration, runProfile, true);
                        arrayList.add(projectActionEvent);
                    }
                } else {
                    return;
                }
                bl = true;
                continue;
            }
            if (!string3.equals("custom-action")) continue;
            object5 = "";
            if (makeConfiguration.isMakefileConfiguration()) {
                object5 = makeConfiguration.getMakefileConfiguration().getOutput().getValue();
            } else if (makeConfiguration.isApplicationConfiguration()) {
                object5 = makeConfiguration.getLinkerConfiguration().getOutputValue();
            }
            object5 = makeConfiguration.expandMacros((String)object5);
            if (((String)object5).length() > 0) {
                object5 = IpeUtils.toAbsolutePath((String)makeConfiguration.getBaseDir(), (String)object5);
            }
            object42 = new ProjectActionEvent(this.project, n, MakeActionProvider.getActionName(string, string3, makeConfiguration), (String)object5, makeConfiguration, null, true);
            arrayList.add(object42);
        }
    }

    private static String getActionName(String string, String string2, MakeConfiguration makeConfiguration) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" (").append(string2);
        if (!makeConfiguration.getDevelopmentHost().isLocalhost()) {
            stringBuilder.append(" - ").append(makeConfiguration.getDevelopmentHost().getName());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private boolean validateProject(MakeConfiguration makeConfiguration) {
        boolean bl = false;
        if (this.getProjectDescriptor().getProjectItems().length == 0) {
            bl = false;
        } else {
            for (int i = 0; i < this.getProjectDescriptor().getProjectItems().length; ++i) {
                Item item = this.getProjectDescriptor().getProjectItems()[i];
                ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
                if (itemConfiguration.getExcluded().getValue() || itemConfiguration.getTool() == 3 && itemConfiguration.getCustomToolConfiguration().getCommandLine().getValue().length() <= 0) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeActionProvider.getString("ERR_EMPTY_PROJECT"), 0));
        }
        return bl;
    }

    String[] getTargetNames(String string, Lookup lookup) throws IllegalArgumentException {
        String[] stringArray = new String[]{};
        if (string.equals("compile.single")) {
            stringArray = this.commands.get(string);
        } else if (string.equals("run") || string.equals("debug") || string.equals("debug.stepinto") || string.equals(COMMAND_DEBUG_LOAD_ONLY) || string.equals(COMMAND_CUSTOM_ACTION)) {
            MakeConfigurationDescriptor makeConfigurationDescriptor = this.getProjectDescriptor();
            MakeConfiguration makeConfiguration = (MakeConfiguration)makeConfigurationDescriptor.getConfs().getActive();
            RunProfile runProfile = (RunProfile)makeConfiguration.getAuxObject("runprofile");
            if (runProfile == null) {
                return null;
            }
            stringArray = runProfile.getBuildFirst() ? this.commands.get(string) : this.commandsNoBuild.get(string);
            if (stringArray == null) {
                throw new IllegalArgumentException(string);
            }
        } else if (string.equals("run.single") || string.equals("debug.single") ? (stringArray = this.commands.get(string)) == null : (stringArray = this.commands.get(string)) == null) {
            throw new IllegalArgumentException(string);
        }
        return stringArray;
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        if (!this.isProjectDescriptorLoaded()) {
            return false;
        }
        if (!(this.getProjectDescriptor().getConfs().getActive() instanceof MakeConfiguration)) {
            return false;
        }
        MakeConfiguration makeConfiguration = (MakeConfiguration)this.getProjectDescriptor().getConfs().getActive();
        if (string.equals("clean")) {
            return true;
        }
        if (string.equals("build")) {
            return true;
        }
        if (string.equals(COMMAND_BUILD_PACKAGE)) {
            return true;
        }
        if (string.equals(COMMAND_BATCH_BUILD)) {
            return true;
        }
        if (string.equals("rebuild")) {
            return true;
        }
        if (string.equals("run")) {
            return !makeConfiguration.isLibraryConfiguration();
        }
        if (string.equals("debug")) {
            return MakeActionProvider.hasDebugger() && !makeConfiguration.isLibraryConfiguration();
        }
        if (string.equals("debug.stepinto")) {
            return MakeActionProvider.hasDebugger() && !makeConfiguration.isLibraryConfiguration();
        }
        if (string.equals(COMMAND_DEBUG_LOAD_ONLY)) {
            return MakeActionProvider.hasDebugger() && !makeConfiguration.isLibraryConfiguration();
        }
        if (string.equals("compile.single")) {
            boolean bl = true;
            for (Node node : lookup.lookup(new Lookup.Template(Node.class)).allInstances()) {
                Item item = this.getNoteItem(node);
                if (item == null) {
                    return false;
                }
                ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
                if (itemConfiguration == null) {
                    return false;
                }
                if (itemConfiguration.getExcluded().getValue()) {
                    return false;
                }
                if (itemConfiguration.getTool() == 3 && !itemConfiguration.getCustomToolConfiguration().getModified()) {
                    return false;
                }
                if (!makeConfiguration.isMakefileConfiguration()) continue;
                return false;
            }
            return bl;
        }
        if (string.equals("delete") || string.equals("copy") || string.equals("move") || string.equals("rename")) {
            return true;
        }
        if (string.equals("run.single")) {
            Node node = (Node)lookup.lookup(Node.class);
            return node != null && node.getCookie(ShellExecSupport.class) != null;
        }
        return false;
    }

    private Item getNoteItem(Node node) {
        Item item = (Item)node.getValue("Item");
        if (item == null) {
            try {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject != null) {
                    File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
                    item = this.getProjectDescriptor().findItemByFile(file);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return item;
    }

    private static boolean hasDebugger() {
        return DefaultProjectActionHandler.getInstance().getCustomDebugActionHandlerProvider() != null;
    }

    private static String getMakeCommand(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration) {
        String string = null;
        CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        if (compilerSet != null) {
            string = compilerSet.getTool(5).getPath();
        } else {
            assert (false);
            string = "make";
        }
        return string;
    }

    public boolean validateBuildSystem(MakeConfigurationDescriptor makeConfigurationDescriptor, MakeConfiguration makeConfiguration, boolean bl) {
        Tool tool;
        CompilerSet compilerSet;
        String string;
        CompilerSet2Configuration compilerSet2Configuration = makeConfiguration.getCompilerSet();
        String string2 = makeConfiguration.getDevelopmentHost().getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        ServerList serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class);
        boolean bl2 = makeConfiguration.hasCFiles(makeConfigurationDescriptor);
        boolean bl3 = makeConfiguration.hasCPPFiles(makeConfigurationDescriptor);
        boolean bl4 = CppSettings.getDefault().isFortranEnabled() && makeConfiguration.hasFortranFiles(makeConfigurationDescriptor);
        boolean bl5 = false;
        if (bl) {
            return this.lastValidation;
        }
        if (!makeConfiguration.getDevelopmentHost().isLocalhost()) {
            assert (serverList != null);
            ServerRecord serverRecord = serverList.get(string2);
            assert (serverRecord != null);
            serverRecord.validate(false);
            if (!serverRecord.isOnline()) {
                this.lastValidation = false;
                bl5 = true;
            }
        }
        boolean bl6 = false;
        if (compilerSet2Configuration.getFlavor() != null && compilerSet2Configuration.getFlavor().equals("Unknown")) {
            bl6 = true;
            string = compilerSet2Configuration.getOption();
            compilerSet = CompilerSetManager.getDefault((String)string2).getCompilerSet(string);
            if (compilerSet == null) {
                compilerSet = CompilerSetManager.getDefault((String)string2).getDefaultCompilerSet();
            }
            bl5 = true;
        } else if (compilerSet2Configuration.isValid()) {
            string = compilerSet2Configuration.getOption();
            compilerSet = CompilerSetManager.getDefault((String)string2).getCompilerSet(string);
        } else {
            string = compilerSet2Configuration.getOldName();
            tool = null;
            if (compilerSet2Configuration.getFlavor() != null) {
                tool = CompilerSet.CompilerFlavor.toFlavor((String)compilerSet2Configuration.getFlavor(), (int)makeConfiguration.getPlatformInfo().getPlatform());
            }
            if (tool == null) {
                tool = CompilerSet.CompilerFlavor.getUnknown((int)makeConfiguration.getPlatformInfo().getPlatform());
            }
            compilerSet = CompilerSet.getCustomCompilerSet((String)"", (CompilerSet.CompilerFlavor)tool, (String)compilerSet2Configuration.getOldName());
            CompilerSetManager.getDefault((String)string2).add(compilerSet);
            compilerSet2Configuration.setValid();
        }
        tool = compilerSet.getTool(0);
        Tool tool2 = compilerSet.getTool(1);
        Tool tool3 = compilerSet.getTool(2);
        Tool tool4 = compilerSet.getTool(5);
        if (makeConfiguration.getDevelopmentHost().isLocalhost()) {
            File file = new File(tool4.getPath());
            if (!file.exists() && Path.findCommand((String)tool4.getPath()) == null || !ToolsPanel.supportedMake((String)file.getPath())) {
                bl5 = true;
            }
        } else if (serverList != null && !bl6 && !serverList.isValidExecutable(string2, tool4.getPath())) {
            bl5 = true;
        }
        PlatformInfo platformInfo = makeConfiguration.getPlatformInfo();
        if (bl2 && !MakeActionProvider.exists(tool.getPath(), platformInfo)) {
            arrayList.add(NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MissingCCompiler", (Object)string, (Object)tool.getDisplayName()));
            bl5 = true;
        }
        if (bl3 && !MakeActionProvider.exists(tool2.getPath(), platformInfo)) {
            arrayList.add(NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MissingCppCompiler", (Object)string, (Object)tool2.getDisplayName()));
            bl5 = true;
        }
        if (bl4 && !MakeActionProvider.exists(tool3.getPath(), platformInfo)) {
            arrayList.add(NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MissingFortranCompiler", (Object)string, (Object)tool3.getDisplayName()));
            bl5 = true;
        }
        if (makeConfiguration.getDevelopmentHost().isLocalhost() && Boolean.getBoolean("netbeans.cnd.always_show_bta")) {
            bl5 = true;
        }
        if (bl5) {
            if (makeConfiguration.getDevelopmentHost().isLocalhost()) {
                BuildToolsAction buildToolsAction = (BuildToolsAction)SystemAction.get(BuildToolsAction.class);
                buildToolsAction.setTitle(NbBundle.getMessage(BuildToolsAction.class, (String)"LBL_ResolveMissingTools_Title"));
                LocalToolsPanelModel localToolsPanelModel = new LocalToolsPanelModel();
                localToolsPanelModel.setSelectedDevelopmentHost(string2);
                localToolsPanelModel.setEnableDevelopmentHostChange(false);
                localToolsPanelModel.setCompilerSetName(null);
                localToolsPanelModel.setSelectedCompilerSetName(string);
                localToolsPanelModel.setMakeRequired(true);
                localToolsPanelModel.setGdbRequired(false);
                localToolsPanelModel.setCRequired(bl2);
                localToolsPanelModel.setCppRequired(bl3);
                localToolsPanelModel.setFortranRequired(bl4);
                localToolsPanelModel.setShowRequiredBuildTools(true);
                localToolsPanelModel.setShowRequiredDebugTools(false);
                localToolsPanelModel.SetEnableRequiredCompilerCB(makeConfiguration.isMakefileConfiguration());
                if (buildToolsAction.initBuildTools((ToolsPanelModel)localToolsPanelModel, arrayList) && makeConfigurationDescriptor.okToChange()) {
                    String string3 = localToolsPanelModel.getSelectedCompilerSetName();
                    CppSettings.getDefault().setCompilerSetName(string3);
                    makeConfiguration.getCRequired().setValue(localToolsPanelModel.isCRequired());
                    makeConfiguration.getCppRequired().setValue(localToolsPanelModel.isCppRequired());
                    makeConfiguration.getFortranRequired().setValue(localToolsPanelModel.isFortranRequired());
                    makeConfiguration.getCompilerSet().setValue(string3);
                    makeConfigurationDescriptor.setModified();
                    makeConfigurationDescriptor.save();
                    this.lastValidation = true;
                } else {
                    this.lastValidation = false;
                }
            } else {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_INVALID_COMPILER_SET", (Object)string, (Object)makeConfiguration.getDevelopmentHost().getName()));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                this.lastValidation = false;
            }
        } else {
            this.lastValidation = true;
        }
        return this.lastValidation;
    }

    private boolean validatePackaging(MakeConfiguration makeConfiguration) {
        Object object;
        String string = null;
        if (makeConfiguration.getPackagingConfiguration().getFiles().getValue().size() == 0) {
            string = MakeActionProvider.getString("ERR_EMPTY_PACKAGE");
        }
        if (PackagerManager.getDefault().getPackager(makeConfiguration.getPackagingConfiguration().getType().getValue()) == null) {
            string = NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MISSING_TOOL4", (Object)makeConfiguration.getPackagingConfiguration().getType().getValue());
        }
        if (string == null) {
            object = makeConfiguration.getPackagingConfiguration().getToolValue();
            if (makeConfiguration.getDevelopmentHost().isLocalhost()) {
                if (!IpeUtils.isPathAbsolute((String)object) && Path.findCommand((String)object) == null) {
                    string = NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MISSING_TOOL1", (Object)object);
                } else if (IpeUtils.isPathAbsolute((String)object) && !new File((String)object).exists()) {
                    string = NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MISSING_TOOL2", (Object)object);
                }
            } else {
                String string2 = makeConfiguration.getDevelopmentHost().getName();
                ServerList serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class);
                if (serverList != null && !serverList.isValidExecutable(string2, (String)object)) {
                    string = NbBundle.getMessage(MakeActionProvider.class, (String)"ERR_MISSING_TOOL3", (Object)object, (Object)string2);
                }
            }
        }
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
            if (makeConfiguration.getPackagingConfiguration().getFiles().getValue().size() == 0 && (object = (MakeCustomizerProvider)this.project.getLookup().lookup(MakeCustomizerProvider.class)) != null) {
                ((MakeCustomizerProvider)object).showCustomizer("Packaging");
            }
            return false;
        }
        return true;
    }

    private static boolean exists(String string, PlatformInfo platformInfo) {
        return platformInfo.fileExists(string) || platformInfo.findCommand(string) != null;
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(MakeActionProvider.class);
        }
        return bundle.getString(string);
    }

    class BatchConfigurationSelector
    implements ActionListener {
        private JButton buildButton = new JButton(MakeActionProvider.access$000("BuildButton"));
        private JButton rebuildButton = new JButton(MakeActionProvider.access$000("CleanBuildButton"));
        private JButton cleanButton = new JButton(MakeActionProvider.access$000("CleanButton"));
        private JButton closeButton = new JButton(MakeActionProvider.access$000("CloseButton"));
        private ConfSelectorPanel confSelectorPanel;
        private String command = null;
        private Dialog dialog = null;

        BatchConfigurationSelector(Configuration[] configurationArray) {
            this.confSelectorPanel = new ConfSelectorPanel(MakeActionProvider.getString("CheckLabel"), MakeActionProvider.getString("CheckLabelMn").charAt(0), configurationArray, new JButton[]{this.buildButton, this.rebuildButton, this.cleanButton});
            String string = MessageFormat.format(MakeActionProvider.getString("BatchBuildTitle"), ProjectUtils.getInformation((Project)MakeActionProvider.this.project).getDisplayName());
            this.buildButton.setMnemonic(MakeActionProvider.getString("BuildButtonMn").charAt(0));
            this.buildButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("BuildButtonAD"));
            this.buildButton.addActionListener(this);
            this.rebuildButton.setMnemonic(MakeActionProvider.getString("CleanBuildButtonMn").charAt(0));
            this.rebuildButton.addActionListener(this);
            this.rebuildButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("CleanBuildButtonAD"));
            this.cleanButton.setMnemonic(MakeActionProvider.getString("CleanButtonMn").charAt(0));
            this.cleanButton.addActionListener(this);
            this.cleanButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("CleanButtonAD"));
            this.closeButton.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("CloseButtonAD"));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.confSelectorPanel, string, true, new Object[]{this.closeButton}, (Object)this.closeButton, 0, null, null);
            this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            this.dialog.getAccessibleContext().setAccessibleDescription(MakeActionProvider.getString("BatchBuildDialogAD"));
            this.dialog.setVisible(true);
        }

        public Configuration[] getSelectedConfs() {
            return this.confSelectorPanel.getSelectedConfs();
        }

        public String getCommand() {
            return this.command;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.buildButton) {
                this.command = "build";
            } else if (actionEvent.getSource() == this.rebuildButton) {
                this.command = "rebuild";
            } else if (actionEvent.getSource() == this.cleanButton) {
                this.command = "clean";
            } else assert (false);
            this.dialog.dispose();
        }
    }
}

