/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.OptionsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationMakefileWriter;
import org.netbeans.modules.cnd.makeproject.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public abstract class BasicCompilerConfiguration {
    private String baseDir;
    private BasicCompilerConfiguration master;
    public static int DEVELOPMENT_MODE_FAST = 0;
    public static int DEVELOPMENT_MODE_DEBUG = 1;
    public static int DEVELOPMENT_MODE_DEBUG_PERF = 2;
    public static int DEVELOPMENT_MODE_TEST = 3;
    public static int DEVELOPMENT_MODE_RELEASE_DIAG = 4;
    public static int DEVELOPMENT_MODE_RELEASE = 5;
    public static int DEVELOPMENT_MODE_RELEASE_PERF = 6;
    private static final String[] DEVELOPMENT_MODE_NAMES = new String[]{BasicCompilerConfiguration.getString("FastBuildTxt"), BasicCompilerConfiguration.getString("DebugTxt"), BasicCompilerConfiguration.getString("PerformanceDebugTxt"), BasicCompilerConfiguration.getString("TestCoverageTxt"), BasicCompilerConfiguration.getString("DiagnosableReleaseTxt"), BasicCompilerConfiguration.getString("ReleaseTxt"), BasicCompilerConfiguration.getString("PerformanceReleaseTxt")};
    private IntConfiguration developmentMode;
    public static int WARNING_LEVEL_NO = 0;
    public static int WARNING_LEVEL_DEFAULT = 1;
    public static int WARNING_LEVEL_MORE = 2;
    public static int WARNING_LEVEL_TAGS = 3;
    public static int WARNING_LEVEL_CONVERT = 4;
    public static int WARNING_LEVEL_32_64 = 5;
    private static final String[] WARNING_LEVEL_NAMES = new String[]{BasicCompilerConfiguration.getString("NoWarningsTxt"), BasicCompilerConfiguration.getString("SomeWarningsTxt"), BasicCompilerConfiguration.getString("MoreWarningsTxt"), BasicCompilerConfiguration.getString("ConvertWarningsTxt")};
    private IntConfiguration warningLevel;
    public static int BITS_DEFAULT = 0;
    public static int BITS_32 = 1;
    public static int BITS_64 = 2;
    private static final String[] BITS_NAMES = new String[]{BasicCompilerConfiguration.getString("BITS_DEFAULT"), BasicCompilerConfiguration.getString("BITS_32"), BasicCompilerConfiguration.getString("BITS_64")};
    private IntConfiguration sixtyfourBits;
    private BooleanConfiguration strip;
    private StringConfiguration additionalDependencies;
    private StringConfiguration tool;
    private OptionsConfiguration commandLineConfiguration;

    protected BasicCompilerConfiguration(String string, BasicCompilerConfiguration basicCompilerConfiguration) {
        this.baseDir = string;
        this.master = basicCompilerConfiguration;
        this.developmentMode = new IntConfiguration(basicCompilerConfiguration != null ? basicCompilerConfiguration.getDevelopmentMode() : null, DEVELOPMENT_MODE_DEBUG, DEVELOPMENT_MODE_NAMES, null);
        this.warningLevel = new IntConfiguration(basicCompilerConfiguration != null ? basicCompilerConfiguration.getWarningLevel() : null, WARNING_LEVEL_DEFAULT, WARNING_LEVEL_NAMES, null);
        this.sixtyfourBits = new IntConfiguration(basicCompilerConfiguration != null ? basicCompilerConfiguration.getSixtyfourBits() : null, BITS_DEFAULT, BITS_NAMES, null);
        this.strip = new BooleanConfiguration(basicCompilerConfiguration != null ? basicCompilerConfiguration.getStrip() : null, false, "", "");
        this.additionalDependencies = new StringConfiguration(basicCompilerConfiguration != null ? basicCompilerConfiguration.getAdditionalDependencies() : null, "");
        this.tool = new StringConfiguration(basicCompilerConfiguration != null ? basicCompilerConfiguration.getTool() : null, "");
        this.commandLineConfiguration = new OptionsConfiguration();
    }

    public boolean getModified() {
        return this.developmentMode.getModified() || this.warningLevel.getModified() || this.sixtyfourBits.getModified() || this.strip.getModified() || this.additionalDependencies.getModified() || this.tool.getModified() || this.commandLineConfiguration.getModified();
    }

    public void setBaseDir(String string) {
        this.baseDir = string;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getOptions(BasicCompiler basicCompiler) {
        return "OVERRIDE";
    }

    public void setMaster(BasicCompilerConfiguration basicCompilerConfiguration) {
        this.master = basicCompilerConfiguration;
    }

    public BasicCompilerConfiguration getMaster() {
        return this.master;
    }

    public void setDevelopmentMode(IntConfiguration intConfiguration) {
        this.developmentMode = intConfiguration;
    }

    public IntConfiguration getDevelopmentMode() {
        return this.developmentMode;
    }

    public void setWarningLevel(IntConfiguration intConfiguration) {
        this.warningLevel = intConfiguration;
    }

    public IntConfiguration getWarningLevel() {
        return this.warningLevel;
    }

    public void setSixtyfourBits(IntConfiguration intConfiguration) {
        this.sixtyfourBits = intConfiguration;
    }

    public IntConfiguration getSixtyfourBits() {
        return this.sixtyfourBits;
    }

    public void setStrip(BooleanConfiguration booleanConfiguration) {
        this.strip = booleanConfiguration;
    }

    public BooleanConfiguration getStrip() {
        return this.strip;
    }

    public void setAdditionalDependencies(StringConfiguration stringConfiguration) {
        this.additionalDependencies = stringConfiguration;
    }

    public StringConfiguration getAdditionalDependencies() {
        return this.additionalDependencies;
    }

    public void setTool(StringConfiguration stringConfiguration) {
        this.tool = stringConfiguration;
    }

    public StringConfiguration getTool() {
        return this.tool;
    }

    public OptionsConfiguration getCommandLineConfiguration() {
        return this.commandLineConfiguration;
    }

    public void setCommandLineConfiguration(OptionsConfiguration optionsConfiguration) {
        this.commandLineConfiguration = optionsConfiguration;
    }

    public String getOutputFile(Item item, MakeConfiguration makeConfiguration, boolean bl) {
        int n;
        Object object;
        String string;
        String string2 = string = item.getPath(true);
        String string3 = ".o";
        boolean bl2 = false;
        if (item.hasHeaderOrSourceExtension(false, false)) {
            string3 = ".pch";
            ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
            if (makeConfiguration.getCompilerSet().getCompilerSet() != null && (object = (BasicCompiler)makeConfiguration.getCompilerSet().getCompilerSet().getTool(itemConfiguration.getTool())) != null) {
                string3 = ((BasicCompiler)((Object)object)).getDescriptor().getPrecompiledHeaderSuffix();
                bl2 = ((BasicCompiler)((Object)object)).getDescriptor().getPrecompiledHeaderSuffixAppend();
            }
        }
        string2 = (n = string2.lastIndexOf(46)) >= 0 && !bl2 ? string2.substring(0, n) + string3 : string2 + string3;
        object = bl ? ConfigurationMakefileWriter.getObjectDir(makeConfiguration) : "${OBJECTDIR}";
        if (IpeUtils.isPathAbsolute((String)string2)) {
            String string4 = string2;
            if (string4.charAt(0) != '/') {
                string4 = '/' + string4;
            }
            string4 = (String)object + '/' + "_ext" + string4;
            string4 = IpeUtils.replaceOddCharacters((String)string4, (char)'_');
            return string4;
        }
        if (string.startsWith("..")) {
            String string5 = IpeUtils.toAbsolutePath((String)this.getBaseDir(), (String)string2);
            string5 = FilePathAdaptor.normalize(string5);
            if ((string5 = IpeUtils.replaceOddCharacters((String)string5, (char)'_')).charAt(0) != '/') {
                string5 = '/' + string5;
            }
            return (String)object + '/' + "_ext" + string5;
        }
        return (String)object + '/' + string2;
    }

    public void assign(BasicCompilerConfiguration basicCompilerConfiguration) {
        this.setBaseDir(basicCompilerConfiguration.getBaseDir());
        this.getDevelopmentMode().assign(basicCompilerConfiguration.getDevelopmentMode());
        this.getWarningLevel().assign(basicCompilerConfiguration.getWarningLevel());
        this.getSixtyfourBits().assign(basicCompilerConfiguration.getSixtyfourBits());
        this.getStrip().assign(basicCompilerConfiguration.getStrip());
        this.getAdditionalDependencies().assign(basicCompilerConfiguration.getAdditionalDependencies());
        this.getTool().assign(basicCompilerConfiguration.getTool());
        this.getCommandLineConfiguration().assign(basicCompilerConfiguration.getCommandLineConfiguration());
    }

    public Sheet.Set getBasicSet() {
        Sheet.Set set = new Sheet.Set();
        set.setName("BasicOptions");
        set.setDisplayName(BasicCompilerConfiguration.getString("BasicOptionsTxt"));
        set.setShortDescription(BasicCompilerConfiguration.getString("BasicOptionsHint"));
        set.put((Node.Property)new IntNodeProp(this.getDevelopmentMode(), true, "DevelopmentMode", BasicCompilerConfiguration.getString("DevelopmentModeTxt"), BasicCompilerConfiguration.getString("DevelopmentModeHint")));
        set.put((Node.Property)new IntNodeProp(this.getWarningLevel(), true, "WarningLevel", BasicCompilerConfiguration.getString("WarningLevelTxt"), BasicCompilerConfiguration.getString("WarningLevelHint")));
        set.put((Node.Property)new IntNodeProp(this.getSixtyfourBits(), true, "64BitArchitecture", BasicCompilerConfiguration.getString("64BitArchitectureTxt"), BasicCompilerConfiguration.getString("64BitArchitectureHint")));
        set.put((Node.Property)new BooleanNodeProp(this.getStrip(), true, "StripSymbols", BasicCompilerConfiguration.getString("StripSymbolsTxt"), BasicCompilerConfiguration.getString("StripSymbolsHint")));
        return set;
    }

    public Sheet.Set getInputSet() {
        Sheet.Set set = new Sheet.Set();
        set.setName("Input");
        set.setDisplayName(BasicCompilerConfiguration.getString("InputTxt"));
        set.setShortDescription(BasicCompilerConfiguration.getString("InputHint"));
        set.put((Node.Property)new StringNodeProp(this.getAdditionalDependencies(), "AdditionalDependencies", BasicCompilerConfiguration.getString("AdditionalDependenciesTxt1"), BasicCompilerConfiguration.getString("AdditionalDependenciesHint")));
        return set;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(BasicCompilerConfiguration.class, (String)string);
    }
}

