/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ui.CompilerSetNodeProp;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class CompilerSet2Configuration
implements PropertyChangeListener {
    private DevelopmentHostConfiguration dhconf;
    private StringConfiguration compilerSetName;
    private CompilerSetNodeProp compilerSetNodeProp;
    private String flavor;
    private boolean dirty = false;
    private Map<String, String> oldNameMap = new HashMap<String, String>();

    private CompilerSet2Configuration(CompilerSet2Configuration compilerSet2Configuration) {
        this.dhconf = (DevelopmentHostConfiguration)compilerSet2Configuration.dhconf.clone();
        this.compilerSetName = (StringConfiguration)compilerSet2Configuration.compilerSetName.clone();
        this.flavor = compilerSet2Configuration.flavor;
        this.compilerSetNodeProp = null;
    }

    public CompilerSet2Configuration(DevelopmentHostConfiguration developmentHostConfiguration) {
        this.dhconf = developmentHostConfiguration;
        String string = this.getCompilerSetManager().getDefaultCompilerSet().getName();
        if (string == null || string.length() == 0) {
            string = this.getCompilerSetManager().getCompilerSetNames().size() > 0 ? this.getCompilerSetManager().getCompilerSet(0).getName() : (Utilities.getOperatingSystem() == 8 ? "Sun" : "GNU");
        }
        this.compilerSetName = new StringConfiguration(null, string);
        this.flavor = null;
        this.compilerSetNodeProp = null;
    }

    public CompilerSetManager getCompilerSetManager() {
        return CompilerSetManager.getDefault((String)this.dhconf.getName());
    }

    public StringConfiguration getCompilerSetName() {
        return this.compilerSetName;
    }

    public void setCompilerSetName(StringConfiguration stringConfiguration) {
        this.compilerSetName = stringConfiguration;
    }

    public void setCompilerSetNodeProp(CompilerSetNodeProp compilerSetNodeProp) {
        this.compilerSetNodeProp = compilerSetNodeProp;
    }

    public void setValue(String string) {
        if (!this.getOption().equals(string)) {
            this.setValue(string, null);
        }
    }

    public void setNameAndFlavor(String string, int n) {
        String string2;
        String string3;
        int n2 = string.indexOf("|");
        if (n2 > 0) {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        } else {
            string3 = string;
            string2 = string;
        }
        this.setValue(CompilerSet.CompilerFlavor.mapOldToNew((String)string3, (int)n), CompilerSet.CompilerFlavor.mapOldToNew((String)string2, (int)n));
    }

    public void setValue(String string, String string2) {
        this.getCompilerSetName().setValue(string);
        this.setFlavor(string2);
    }

    public int getValue() {
        String string = this.getCompilerSetName().getValue();
        if (string != null) {
            int n = 0;
            for (String string2 : CompilerSetManager.getDefault((String)this.dhconf.getName()).getCompilerSetNames()) {
                if (string.equals(string2)) {
                    return n;
                }
                ++n;
            }
        }
        return 0;
    }

    public CompilerSet getCompilerSet() {
        return this.getCompilerSetManager().getCompilerSet(this.getCompilerSetName().getValue());
    }

    public int getPlatform() {
        return this.getCompilerSetManager().getPlatform();
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return this.getDisplayName(false);
    }

    public String getDisplayName(boolean bl) {
        CompilerSet compilerSet = this.getCompilerSetManager().getCompilerSet(this.getCompilerSetName().getValue());
        String string = null;
        if (compilerSet != null) {
            string = compilerSet.getName();
        }
        if (string != null && this.dhconf.isOnline()) {
            return string;
        }
        if (bl) {
            return this.createNotFoundName(this.getCompilerSetName().getValue());
        }
        return "";
    }

    public String createNotFoundName(String string) {
        if (!this.dhconf.isOnline()) {
            return "";
        }
        return string.equals("None") ? string : NbBundle.getMessage(CompilerSet2Configuration.class, (String)"NOT_FOUND", (Object)string);
    }

    public boolean isDevHostOnline() {
        return this.dhconf.isOnline();
    }

    public void assign(CompilerSet2Configuration compilerSet2Configuration) {
        String string = this.getCompilerSetName().getValue();
        String string2 = compilerSet2Configuration.getCompilerSetName().getValue();
        this.setDirty(string2 != null && !string2.equals(string));
        this.setValue(compilerSet2Configuration.getCompilerSetName().getValue());
    }

    public Object clone() {
        CompilerSet2Configuration compilerSet2Configuration = new CompilerSet2Configuration(this);
        return compilerSet2Configuration;
    }

    public void setDevelopmentHostConfiguration(DevelopmentHostConfiguration developmentHostConfiguration) {
        this.dhconf = developmentHostConfiguration;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public boolean isValid() {
        return this.getCompilerSet() != null;
    }

    public void setValid() {
    }

    public String getOldName() {
        return this.getCompilerSetName().getValue();
    }

    public String getOption() {
        return this.getCompilerSetName().getValue();
    }

    public String getNameAndFlavor() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getOption());
        if (this.getFlavor() != null) {
            stringBuilder.append("|");
            stringBuilder.append(this.getFlavor());
        }
        return stringBuilder.toString();
    }

    public String getFlavor() {
        CompilerSet compilerSet;
        if (this.flavor == null && (compilerSet = this.getCompilerSet()) != null) {
            this.flavor = compilerSet.getCompilerFlavor().toString();
        }
        return this.flavor;
    }

    public void setFlavor(String string) {
        this.flavor = string;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        CompilerSet compilerSet = null;
        final String string = ((DevelopmentHostConfiguration)propertyChangeEvent.getNewValue()).getName();
        String string2 = this.oldNameMap.get(string);
        compilerSet = string2 != null ? CompilerSetManager.getDefault((String)string).getCompilerSet(string2) : CompilerSetManager.getDefault((String)string).getDefaultCompilerSet();
        if (compilerSet == null) {
            compilerSet = CompilerSetManager.getDefault((String)string).getCompilerSet(0);
        }
        String string3 = (String)propertyChangeEvent.getOldValue();
        this.oldNameMap.put(string3, this.getName());
        if (string.equals("localhost")) {
            this.setValue(compilerSet.getName());
        } else {
            this.setValue(compilerSet.getName());
            final CompilerSet compilerSet2 = compilerSet;
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ServerRecord serverRecord;
                    ServerList serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class);
                    if (serverList != null && (serverRecord = serverList.get(string)) != null) {
                        CompilerSet2Configuration.this.setValue(compilerSet2.getName());
                        if (CompilerSet2Configuration.this.compilerSetNodeProp != null) {
                            CompilerSet2Configuration.this.compilerSetNodeProp.repaint();
                        }
                    }
                }
            });
        }
    }
}

