/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLReader;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.Lookup;

public class ConfigurationDescriptorProvider {
    public static final String USG_PROJECT_CONFIG_CND = "USG_PROJECT_CONFIG_CND";
    public static final String USG_PROJECT_OPEN_CND = "USG_PROJECT_OPEN_CND";
    private FileObject projectDirectory;
    private ConfigurationDescriptor projectDescriptor = null;
    boolean hasTried = false;
    private String relativeOffset = null;
    private List<FileObject> trackedFiles;
    private volatile boolean needReload;
    private final Object readLock = new Object();

    public ConfigurationDescriptorProvider(FileObject fileObject) {
        this.projectDirectory = fileObject;
    }

    public void setRelativeOffset(String string) {
        this.relativeOffset = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationDescriptor getConfigurationDescriptor() {
        if ((this.projectDescriptor == null || this.needReload) && !this.hasTried) {
            Object object = this.readLock;
            synchronized (object) {
                if (!this.hasTried) {
                    Object object2;
                    this.needReload = false;
                    if (this.trackedFiles == null) {
                        object2 = new ConfigurationXMLChangeListener();
                        this.trackedFiles = new ArrayList<FileObject>();
                        for (String string : new String[]{"nbproject/configurations.xml", "nbproject/private/configurations.xml"}) {
                            FileObject fileObject = this.projectDirectory.getFileObject(string);
                            if (fileObject == null) continue;
                            fileObject.addFileChangeListener((FileChangeListener)object2);
                            this.trackedFiles.add(fileObject);
                        }
                    }
                    object2 = new ConfigurationXMLReader(this.projectDirectory);
                    String[] stringArray = null;
                    try {
                        this.projectDescriptor = ((ConfigurationXMLReader)((Object)object2)).read(this.relativeOffset);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.hasTried = true;
                    ConfigurationDescriptorProvider.recordMetrics(USG_PROJECT_OPEN_CND, this.projectDescriptor);
                }
            }
        }
        return this.projectDescriptor;
    }

    public boolean gotDescriptor() {
        return this.projectDescriptor != null;
    }

    public static ConfigurationAuxObjectProvider[] getAuxObjectProviders() {
        HashSet hashSet = new HashSet();
        Lookup.Template template = new Lookup.Template(ConfigurationAuxObjectProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection collection = result.allInstances();
        for (Object e : collection) {
            if (!(e instanceof ConfigurationAuxObjectProvider)) continue;
            hashSet.add(e);
        }
        return hashSet.toArray(new ConfigurationAuxObjectProvider[hashSet.size()]);
    }

    public static void recordMetrics(String string, ConfigurationDescriptor configurationDescriptor) {
        if (!(configurationDescriptor instanceof MakeConfigurationDescriptor)) {
            return;
        }
        Logger logger = Logger.getLogger("org.netbeans.ui.metrics.cnd");
        if (logger.isLoggable(Level.INFO)) {
            CharSequence charSequence;
            String string2;
            String string3;
            String[] stringArray;
            CompilerSet compilerSet;
            String string4;
            String string5;
            LogRecord logRecord = new LogRecord(Level.INFO, string);
            MakeConfiguration makeConfiguration = (MakeConfiguration)configurationDescriptor.getConfs().getActive();
            switch (makeConfiguration.getConfigurationType().getValue()) {
                case 0: {
                    string5 = "MAKEFILE";
                    break;
                }
                case 1: {
                    string5 = "APPLICATION";
                    break;
                }
                case 2: {
                    string5 = "DYNAMIC_LIB";
                    break;
                }
                case 3: {
                    string5 = "STATIC_LIB";
                    break;
                }
                default: {
                    string5 = "UNKNOWN";
                }
            }
            if (makeConfiguration.getDevelopmentHost().isLocalhost()) {
                string4 = "LOCAL";
                compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            } else {
                string4 = "REMOTE";
                compilerSet = null;
            }
            if (compilerSet != null) {
                stringArray = compilerSet.getCompilerFlavor().getToolchainDescriptor().getFamily();
                string3 = compilerSet.getCompilerFlavor().toString();
            } else {
                stringArray = new String[]{};
                string3 = makeConfiguration.getCompilerSet().getFlavor();
            }
            if (stringArray.length == 0) {
                string2 = "UKNOWN";
            } else {
                charSequence = new StringBuilder();
                for (int i = 0; i < stringArray.length; ++i) {
                    ((StringBuilder)charSequence).append(stringArray[i]);
                    if (i >= stringArray.length - 1) continue;
                    ((StringBuilder)charSequence).append(",");
                }
                string2 = ((StringBuilder)charSequence).toString();
            }
            charSequence = Platforms.getPlatform(makeConfiguration.getCompilerSet().getPlatform()) != null ? Platforms.getPlatform(makeConfiguration.getCompilerSet().getPlatform()).getName() : "UNKNOWN_PLATFORM";
            makeConfiguration.reCountLanguages((MakeConfigurationDescriptor)configurationDescriptor);
            Item[] itemArray = ((MakeConfigurationDescriptor)configurationDescriptor).getProjectItems();
            int n = 0;
            int n2 = itemArray.length;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            block12: for (Item item : itemArray) {
                ItemConfiguration itemConfiguration = item.getItemConfiguration(makeConfiguration);
                if (itemConfiguration.getExcluded().getValue()) continue;
                ++n;
                switch (itemConfiguration.getTool()) {
                    case 0: {
                        bl = true;
                        continue block12;
                    }
                    case 1: {
                        bl2 = true;
                        continue block12;
                    }
                    case 2: {
                        bl3 = true;
                    }
                }
            }
            String string6 = bl2 ? "USE_CPP" : "NO_CPP";
            String string7 = bl ? "USE_C" : "NO_C";
            String string8 = bl3 ? "USE_FORTRAN" : "NO_FORTRAN";
            logRecord.setParameters(new Object[]{string5, string3, string2, string4, charSequence, ConfigurationDescriptorProvider.toSizeString(n2), ConfigurationDescriptorProvider.toSizeString(n), string6, string7, string8});
            logRecord.setLoggerName(logger.getName());
            logger.log(logRecord);
        }
    }

    private static String toSizeString(int n) {
        String string = n < 25 ? "25" : (n < 100 ? "100" : (n < 500 ? "500" : (n < 1000 ? "1000" : (n < 2000 ? "2000" : (n < 5000 ? "5000" : (n < 10000 ? "10000" : (n < 20000 ? "20000" : (n < 50000 ? "50000" : "99999"))))))));
        return string;
    }

    private class ConfigurationXMLChangeListener
    implements FileChangeListener {
        private ConfigurationXMLChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetConfiguration() {
            if (ConfigurationDescriptorProvider.this.projectDescriptor != null && ConfigurationDescriptorProvider.this.projectDescriptor.getModified()) {
                return;
            }
            Object object = ConfigurationDescriptorProvider.this.readLock;
            synchronized (object) {
                ConfigurationDescriptorProvider.this.needReload = true;
                ConfigurationDescriptorProvider.this.hasTried = false;
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.resetConfiguration();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.resetConfiguration();
        }

        public void fileChanged(FileEvent fileEvent) {
            this.resetConfiguration();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.resetConfiguration();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.resetConfiguration();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            this.resetConfiguration();
        }
    }
}

