/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DevelopmentHostConfiguration {
    public static final String PROP_DEV_HOST = "devHost";
    private final int def;
    private int value = 0;
    private String[] names = this.getServerNames();
    private boolean modified;
    private boolean dirty = false;
    private PropertyChangeSupport pcs;
    private static ServerList serverList = null;

    public DevelopmentHostConfiguration(String string) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!string.equals(this.names[i])) continue;
            this.value = i;
            break;
        }
        this.def = this.value;
        this.pcs = new PropertyChangeSupport(this);
    }

    public String getName() {
        return this.names[this.value];
    }

    public String getDisplayName(boolean bl) {
        String string = this.names[this.value];
        if (bl && !this.isOnline()) {
            string = NbBundle.getMessage(DevelopmentHostConfiguration.class, (String)"NOT_CONFIGURED", (Object)string);
        }
        return string;
    }

    public boolean isOnline() {
        return !CompilerSetManager.getDefault((String)this.getName()).isUninitialized();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.setValue(string, false);
    }

    public void setValue(String string, boolean bl) {
        for (int i = 0; i < this.names.length; ++i) {
            if (!string.equals(this.names[i])) continue;
            this.value = i;
            if (bl) {
                this.pcs.firePropertyChange(PROP_DEV_HOST, null, this);
            }
            return;
        }
        this.addDevelopmentHost(string);
        this.names = this.getServerNames();
        this.setValue(string, bl);
    }

    private boolean addDevelopmentHost(String string) {
        ServerList serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class);
        if (serverList != null) {
            serverList.addServer(string, false, false);
        }
        return serverList != null;
    }

    public void reset() {
        this.names = this.getServerNames();
        this.value = this.def;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    void assign(DevelopmentHostConfiguration developmentHostConfiguration) {
        boolean bl = false;
        String string = this.getName();
        String string2 = developmentHostConfiguration.getName();
        if (this.names.length != developmentHostConfiguration.names.length) {
            this.names = this.getServerNames();
            bl = true;
        }
        if (!string2.equals(string)) {
            bl = true;
        }
        this.setDirty(bl);
        this.setValue(string2);
    }

    public Object clone() {
        DevelopmentHostConfiguration developmentHostConfiguration = new DevelopmentHostConfiguration(this.getName());
        developmentHostConfiguration.setValue(this.getName());
        return developmentHostConfiguration;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public String[] getServerNames() {
        if (DevelopmentHostConfiguration.getServerList() != null) {
            String[] stringArray = DevelopmentHostConfiguration.getServerList().getServerNames();
            return stringArray;
        }
        return new String[]{"localhost"};
    }

    private static ServerList getServerList() {
        if (serverList == null) {
            serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class);
        }
        return serverList;
    }

    public boolean isLocalhost() {
        return "localhost".equals(this.getName());
    }
}

