/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.loaders.CndDataObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class Folder {
    public static final String DEFAULT_FOLDER_NAME = "f";
    public static final String DEFAULT_FOLDER_DISPLAY_NAME = Folder.getString("NewFolderName");
    private ConfigurationDescriptor configurationDescriptor;
    private final String name;
    private String displayName;
    private String sortName;
    private final Folder parent;
    private Vector items = null;
    private Set<ChangeListener> changeListenerList = new HashSet<ChangeListener>();
    private final boolean projectFiles;
    private String id = null;

    public Folder(ConfigurationDescriptor configurationDescriptor, Folder folder, String string, String string2, boolean bl) {
        this.configurationDescriptor = configurationDescriptor;
        this.parent = folder;
        this.name = string;
        this.displayName = string2;
        this.projectFiles = bl;
        this.items = new Vector();
        this.sortName = string2.toLowerCase();
    }

    public int size() {
        return this.items.size();
    }

    public Folder getParent() {
        return this.parent;
    }

    public Project getProject() {
        return ((MakeConfigurationDescriptor)this.getConfigurationDescriptor()).getProject();
    }

    public String getName() {
        return this.name;
    }

    public String getSortName() {
        return this.sortName;
    }

    public String getPath() {
        StringBuilder stringBuilder = new StringBuilder(32);
        this.reversePath(this, stringBuilder);
        return stringBuilder.toString();
    }

    private void reversePath(Folder folder, StringBuilder stringBuilder) {
        Folder folder2 = folder.getParent();
        if (folder2 != null && folder2.getParent() != null) {
            this.reversePath(folder2, stringBuilder);
            stringBuilder.append('/');
        }
        stringBuilder.append(folder.getName());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
        this.configurationDescriptor.setModified();
        this.sortName = string.toLowerCase();
        this.getParent().reInsertElement(this);
    }

    public ConfigurationDescriptor getConfigurationDescriptor() {
        return this.configurationDescriptor;
    }

    public void setConfigurationDescriptor(ConfigurationDescriptor configurationDescriptor) {
        this.configurationDescriptor = configurationDescriptor;
    }

    public boolean isProjectFiles() {
        return this.projectFiles;
    }

    public Vector getElements() {
        return this.items;
    }

    public void reInsertElement(Object object) {
        int n = this.items.indexOf(object);
        if (n < 0) {
            return;
        }
        this.items.remove(object);
        if (object instanceof Folder) {
            this.insertFolderElement((Folder)object);
        } else if (object instanceof Item) {
            this.insertItemElement((Item)object);
        } else assert (false);
        this.fireChangeEvent();
    }

    private void insertFolderElement(Folder folder) {
        if (!folder.isProjectFiles()) {
            this.items.add(folder);
            return;
        }
        String string = folder.getSortName();
        int n = this.items.size() - 1;
        while (n >= 0) {
            Object e = this.items.elementAt(n);
            if (!(e instanceof Folder)) {
                --n;
                continue;
            }
            if (!((Folder)e).isProjectFiles()) {
                --n;
                continue;
            }
            String string2 = ((Folder)e).getSortName();
            int n2 = string.compareTo(string2);
            if (n2 >= 0) break;
            --n;
        }
        this.items.add(n + 1, folder);
    }

    private void insertItemElement(Item item) {
        String string;
        int n;
        Object e;
        int n2;
        String string2 = item.getSortName();
        for (n2 = this.items.size() - 1; n2 >= 0 && (e = this.items.elementAt(n2)) instanceof Item && (n = string2.compareTo(string = ((Item)e).getSortName())) < 0; --n2) {
        }
        this.items.add(n2 + 1, item);
    }

    public void addElement(Object object) {
        int n = -1;
        if (object instanceof Item) {
            this.insertItemElement((Item)object);
        } else if (object instanceof Folder) {
            this.insertFolderElement((Folder)object);
        } else assert (false);
        this.fireChangeEvent();
    }

    public Item addItemAction(Item item) {
        if (this.addItem(item) == null) {
            return null;
        }
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>(1);
        arrayList.add(item);
        ((MakeConfigurationDescriptor)this.configurationDescriptor).fireFilesAdded(arrayList);
        return item;
    }

    public Item addItem(Item item) {
        return this.addItem(item, true);
    }

    public Item addItem(Item item, boolean bl) {
        Object object;
        Configuration[] configurationArray;
        Item item2;
        if (item == null) {
            return null;
        }
        if (this.isProjectFiles() && (item2 = ((MakeConfigurationDescriptor)this.configurationDescriptor).findProjectItemByPath(item.getPath())) != null) {
            this.refresh(item2);
            return null;
        }
        item.setFolder(this);
        this.addElement(item);
        if (this.isProjectFiles() && bl && (configurationArray = item.getDataObject()) instanceof CndDataObject) {
            CndDataObject cndDataObject = (CndDataObject)configurationArray;
            object = (MyNativeFileItemSet)cndDataObject.getCookie(MyNativeFileItemSet.class);
            if (object == null) {
                object = new MyNativeFileItemSet();
                cndDataObject.addCookie((Node.Cookie)object);
            }
            ((MyNativeFileItemSet)object).add(item);
        }
        if (this.isProjectFiles()) {
            ((MakeConfigurationDescriptor)this.configurationDescriptor).addProjectItem(item);
            if (this.configurationDescriptor.getConfs() == null) {
                return item;
            }
            configurationArray = this.configurationDescriptor.getConfs().getConfs();
            for (int i = 0; i < configurationArray.length; ++i) {
                object = this.getFolderConfiguration(configurationArray[i]);
                configurationArray[i].addAuxObject(new ItemConfiguration(configurationArray[i], item));
            }
        }
        return item;
    }

    public void addFolder(Folder folder) {
        this.addElement(folder);
        if (this.isProjectFiles()) {
            if (this.configurationDescriptor.getConfs() == null) {
                return;
            }
            Configuration[] configurationArray = this.configurationDescriptor.getConfs().getConfs();
            for (int i = 0; i < configurationArray.length; ++i) {
                folder.getFolderConfiguration(configurationArray[i]);
            }
        }
    }

    public String getId() {
        if (this.id == null) {
            this.id = "f-" + this.getPath();
        }
        return this.id;
    }

    public FolderConfiguration getFolderConfiguration(Configuration configuration) {
        FolderConfiguration folderConfiguration = null;
        if (this.isProjectFiles()) {
            String string = this.getId();
            folderConfiguration = (FolderConfiguration)configuration.getAuxObject(this.getId());
            if (folderConfiguration == null) {
                CCCompilerConfiguration cCCompilerConfiguration;
                CCompilerConfiguration cCompilerConfiguration;
                FolderConfiguration folderConfiguration2 = null;
                if (this.getParent() != null) {
                    folderConfiguration2 = this.getParent().getFolderConfiguration(configuration);
                }
                if (folderConfiguration2 != null) {
                    cCompilerConfiguration = folderConfiguration2.getCCompilerConfiguration();
                    cCCompilerConfiguration = folderConfiguration2.getCCCompilerConfiguration();
                } else {
                    cCompilerConfiguration = ((MakeConfiguration)configuration).getCCompilerConfiguration();
                    cCCompilerConfiguration = ((MakeConfiguration)configuration).getCCCompilerConfiguration();
                }
                folderConfiguration = new FolderConfiguration(configuration, cCompilerConfiguration, cCCompilerConfiguration, this);
                configuration.addAuxObject(folderConfiguration);
            }
        }
        return folderConfiguration;
    }

    public Folder addNewFolder(boolean bl) {
        String string;
        String string2;
        int n = 1;
        while (true) {
            string2 = DEFAULT_FOLDER_NAME + n;
            string = DEFAULT_FOLDER_DISPLAY_NAME + " " + n;
            if (this.findFolderByName(string2) == null) break;
            ++n;
        }
        return this.addNewFolder(string2, string, bl);
    }

    public Folder addNewFolder(String string, String string2, boolean bl) {
        Folder folder = new Folder(this.getConfigurationDescriptor(), this, string, string2, bl);
        this.addFolder(folder);
        return folder;
    }

    public boolean removeItemAction(Item item) {
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>(1);
        arrayList.add(item);
        if (this.isProjectFiles()) {
            ((MakeConfigurationDescriptor)this.configurationDescriptor).fireFilesRemoved(arrayList);
        }
        return this.removeItem(item);
    }

    public void renameItemAction(String string, Item item) {
        ((MakeConfigurationDescriptor)this.configurationDescriptor).fireFileRenamed(string, item);
    }

    public boolean removeItem(Item item) {
        Configuration[] configurationArray;
        boolean bl = false;
        if (item == null) {
            return false;
        }
        bl = this.items.removeElement(item);
        if (!bl) {
            return bl;
        }
        if (this.isProjectFiles()) {
            CndDataObject cndDataObject;
            MyNativeFileItemSet myNativeFileItemSet;
            configurationArray = item.getDataObject();
            if (configurationArray == null) {
                configurationArray = item.getLastDataObject();
            }
            if (configurationArray instanceof CndDataObject && (myNativeFileItemSet = (MyNativeFileItemSet)(cndDataObject = (CndDataObject)configurationArray).getCookie(MyNativeFileItemSet.class)) != null) {
                myNativeFileItemSet.remove(item);
                if (myNativeFileItemSet.isEmpty()) {
                    cndDataObject.removeCookie((Node.Cookie)myNativeFileItemSet);
                }
            }
        }
        if (this.isProjectFiles()) {
            ((MakeConfigurationDescriptor)this.configurationDescriptor).removeProjectItem(item);
            configurationArray = this.configurationDescriptor.getConfs().getConfs();
            for (int i = 0; i < configurationArray.length; ++i) {
                configurationArray[i].removeAuxObject(item.getId());
            }
        }
        item.setFolder(null);
        this.fireChangeEvent();
        return bl;
    }

    public boolean removeItemByPath(String string) {
        boolean bl = false;
        Item item = this.findItemByPath(string);
        return this.removeItem(item);
    }

    public boolean removeFolderAction(Folder folder) {
        ((MakeConfigurationDescriptor)this.configurationDescriptor).fireFilesRemoved(folder.getAllItemsAsList());
        return this.removeFolder(folder);
    }

    public boolean removeFolder(Folder folder) {
        boolean bl = false;
        if (folder != null) {
            folder.removeAll();
            bl = this.items.removeElement(folder);
            if (this.isProjectFiles()) {
                Configuration[] configurationArray = this.configurationDescriptor.getConfs().getConfs();
                for (int i = 0; i < configurationArray.length; ++i) {
                    configurationArray[i].removeAuxObject(folder.getId());
                }
            }
        }
        if (bl) {
            this.fireChangeEvent();
        }
        return bl;
    }

    public void removeAll() {
        int n;
        Item[] itemArray = this.getItemsAsArray();
        Folder[] folderArray = this.getFoldersAsArray();
        for (n = 0; n < itemArray.length; ++n) {
            this.removeItem(itemArray[n]);
        }
        for (n = 0; n < folderArray.length; ++n) {
            this.removeFolder(folderArray[n]);
        }
    }

    public void reset() {
        this.items = new Vector();
        this.fireChangeEvent();
    }

    public Item findItemByPath(String string) {
        if (string == null) {
            return null;
        }
        Item[] itemArray = this.getItemsAsArray();
        for (int i = 0; i < itemArray.length; ++i) {
            if (!string.equals(itemArray[i].getPath())) continue;
            return itemArray[i];
        }
        return null;
    }

    public Folder findFolderByName(String string) {
        if (string == null) {
            return null;
        }
        Folder[] folderArray = this.getFoldersAsArray();
        for (int i = 0; i < folderArray.length; ++i) {
            if (!string.equals(folderArray[i].getName())) continue;
            return folderArray[i];
        }
        return null;
    }

    public Folder findFolderByDisplayName(String string) {
        if (string == null) {
            return null;
        }
        Folder[] folderArray = this.getFoldersAsArray();
        for (int i = 0; i < folderArray.length; ++i) {
            if (!string.equals(folderArray[i].getDisplayName())) continue;
            return folderArray[i];
        }
        return null;
    }

    public Folder findFolderByPath(String string) {
        int n = string.indexOf(47);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            Folder folder = this.findFolderByName(string2);
            if (folder == null) {
                return null;
            }
            return folder.findFolderByPath(string.substring(n + 1));
        }
        return this.findFolderByName(string);
    }

    public Item[] getItemsAsArray() {
        Vector vector = new Vector();
        for (Object e : new ArrayList(this.getElements())) {
            if (!(e instanceof Item)) continue;
            vector.add(e);
        }
        return vector.toArray(new Item[vector.size()]);
    }

    public List getAllItemsAsList() {
        ArrayList arrayList = new ArrayList();
        for (Object e : new ArrayList(this.getElements())) {
            if (e instanceof Item) {
                arrayList.add(e);
            }
            if (!(e instanceof Folder)) continue;
            List list = ((Folder)e).getAllItemsAsList();
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public Item[] getAllItemsAsArray() {
        List list = this.getAllItemsAsList();
        return list.toArray(new Item[list.size()]);
    }

    public Set getItemsAsFileObjectSet() {
        Vector<FileObject> vector = new Vector<FileObject>();
        for (Item item : new ArrayList(this.getElements())) {
            FileObject fileObject;
            if (!(item instanceof Item) || (fileObject = item.getFileObject()) == null) continue;
            vector.add(fileObject);
        }
        return new LinkedHashSet(vector);
    }

    public Set getAllItemsAsFileObjectSet(boolean bl) {
        Vector<FileObject> vector = new Vector<FileObject>();
        if (!bl || this.isProjectFiles()) {
            for (Object e : new ArrayList(this.getElements())) {
                FileObject fileObject;
                if (e instanceof Item && (fileObject = ((Item)e).getFileObject()) != null) {
                    vector.add(fileObject);
                }
                if (!(e instanceof Folder)) continue;
                vector.addAll(((Folder)e).getAllItemsAsFileObjectSet(bl));
            }
        }
        return new LinkedHashSet(vector);
    }

    public Set getItemsAsDataObjectSet(String string) {
        Vector<DataObject> vector = new Vector<DataObject>();
        for (Item item : new ArrayList(this.getElements())) {
            DataObject dataObject;
            if (!(item instanceof Item) || (dataObject = item.getDataObject()) == null || string != null && !dataObject.getPrimaryFile().getMIMEType().contains(string)) continue;
            vector.add(dataObject);
        }
        return new LinkedHashSet(vector);
    }

    public Set getAllItemsAsDataObjectSet(boolean bl, String string) {
        Vector<DataObject> vector = new Vector<DataObject>();
        if (!bl || this.isProjectFiles()) {
            for (Object e : new ArrayList(this.getElements())) {
                DataObject dataObject;
                if (e instanceof Item && (dataObject = ((Item)e).getDataObject()) != null && (string == null || dataObject.getPrimaryFile().getMIMEType().contains(string))) {
                    vector.add(dataObject);
                }
                if (!(e instanceof Folder)) continue;
                vector.addAll(((Folder)e).getAllItemsAsDataObjectSet(bl, string));
            }
        }
        return new LinkedHashSet(vector);
    }

    public String[] getItemNamesAsArray() {
        Item[] itemArray = this.getItemsAsArray();
        String[] stringArray = new String[itemArray.length];
        for (int i = 0; i < itemArray.length; ++i) {
            stringArray[i] = itemArray[i].getPath();
        }
        return stringArray;
    }

    public Folder[] getFoldersAsArray() {
        Vector vector = this.getFolders();
        return vector.toArray(new Folder[vector.size()]);
    }

    public Vector getFolders() {
        Vector vector = new Vector();
        for (Object e : new ArrayList(this.getElements())) {
            if (!(e instanceof Folder)) continue;
            vector.add(e);
        }
        return vector;
    }

    public Vector getAllFolders(boolean bl) {
        Vector vector = new Vector();
        if (!bl || this.isProjectFiles()) {
            for (Object e : new ArrayList(this.getElements())) {
                if (!(e instanceof Folder) || bl && !((Folder)e).isProjectFiles()) continue;
                vector.add(e);
                vector.addAll(((Folder)e).getAllFolders(bl));
            }
        }
        return vector;
    }

    public String[] getFolderNamesAsArray() {
        Folder[] folderArray = this.getFoldersAsArray();
        String[] stringArray = new String[folderArray.length];
        for (int i = 0; i < folderArray.length; ++i) {
            stringArray[i] = folderArray[i].getName();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.changeListenerList;
        synchronized (set) {
            this.changeListenerList.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.changeListenerList;
        synchronized (set) {
            this.changeListenerList.remove(changeListener);
        }
    }

    public void refresh() {
        this.fireChangeEvent(this);
    }

    public void refresh(Object object) {
        this.fireChangeEvent(object);
    }

    public void fireChangeEvent() {
        this.fireChangeEvent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeEvent(Object object) {
        Iterator<ChangeListener> iterator;
        Object object2 = this.changeListenerList;
        synchronized (object2) {
            iterator = new HashSet<ChangeListener>(this.changeListenerList).iterator();
        }
        object2 = new ChangeEvent(object);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object2);
        }
        this.configurationDescriptor.setModified();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(Folder.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyNativeFileItemSet
    implements NativeFileItemSet {
        private List<NativeFileItem> items = new ArrayList<NativeFileItem>(1);

        private MyNativeFileItemSet() {
        }

        public synchronized Collection<NativeFileItem> getItems() {
            return new ArrayList<NativeFileItem>(this.items);
        }

        public synchronized void add(NativeFileItem nativeFileItem) {
            if (!this.items.contains(nativeFileItem)) {
                this.items.add(nativeFileItem);
            }
        }

        public synchronized void remove(NativeFileItem nativeFileItem) {
            this.items.remove(nativeFileItem);
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }
    }
}

