/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platform;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.cnd.makeproject.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.PackagingNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.packaging.DummyPackager;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeCustomizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagingConfiguration {
    private MakeConfiguration makeConfiguration;
    private StringConfiguration type;
    private BooleanConfiguration verbose;
    private VectorConfiguration info;
    private VectorConfiguration files;
    private StringConfiguration output;
    private StringConfiguration tool;
    private StringConfiguration options;
    private StringConfiguration topDir;
    TypePropertyChangeListener typePropertyChangeListener;

    public PackagingConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.type = new StringConfiguration(null, "Tar");
        this.verbose = new BooleanConfiguration(null, true);
        this.info = new VectorConfiguration(null);
        this.files = new VectorConfiguration(null);
        this.output = new StringConfiguration(null, "");
        this.tool = new StringConfiguration(null, "");
        this.options = new StringConfiguration(null, "");
        this.topDir = new StringConfiguration(null, null);
        this.setDefaultValues();
    }

    public void setDefaultValues() {
        String string = MakeOptions.getInstance().getDefExePerm();
        String string2 = "${PACKAGE_TOP_DIR}bin";
        String string3 = "";
        if (this.makeConfiguration.isMakefileConfiguration()) {
            string = MakeOptions.getInstance().getDefExePerm();
            string2 = "${PACKAGE_TOP_DIR}bin";
        } else if (this.makeConfiguration.isApplicationConfiguration()) {
            string = MakeOptions.getInstance().getDefExePerm();
            string2 = "${PACKAGE_TOP_DIR}bin";
            if (this.makeConfiguration.getPlatform().getValue() == 3) {
                string3 = ".exe";
            }
        } else if (this.makeConfiguration.isLibraryConfiguration()) {
            string = MakeOptions.getInstance().getDefFilePerm();
            string2 = "${PACKAGE_TOP_DIR}lib";
        } else assert (false);
        PackagerFileElement packagerFileElement = new PackagerFileElement(PackagerFileElement.FileType.FILE, "${OUTPUT_PATH}" + string3, string2 + "/${OUTPUT_BASENAME}" + string3, string, MakeOptions.getInstance().getDefOwner(), MakeOptions.getInstance().getDefGroup());
        packagerFileElement.setDefaultValue(true);
        this.files.add(packagerFileElement);
        List list = this.getInfo().getValue();
        List<PackagerDescriptor> list2 = PackagerManager.getDefault().getPackagerList();
        for (PackagerDescriptor packagerDescriptor : list2) {
            if (!packagerDescriptor.hasInfoList()) continue;
            list.addAll(packagerDescriptor.getDefaultInfoList(this.makeConfiguration, this));
        }
    }

    public List<PackagerInfoElement> getHeaderSubList(String string) {
        ArrayList<PackagerInfoElement> arrayList = new ArrayList<PackagerInfoElement>();
        List list = this.getInfo().getValue();
        for (PackagerInfoElement packagerInfoElement : list) {
            if (!packagerInfoElement.getPackager().equals(string)) continue;
            arrayList.add(packagerInfoElement);
        }
        return arrayList;
    }

    public boolean isModified() {
        Object object2;
        if (this.getType().getModified()) {
            return true;
        }
        if (this.files.getValue().size() != 1) {
            return true;
        }
        for (Object object2 : this.files.getValue()) {
            if (((PackagerFileElement)object2).isDefaultValue()) continue;
            return true;
        }
        List<PackagerInfoElement> list = this.getHeaderSubList(this.getType().getValue());
        object2 = PackagerManager.getDefault().getPackager(this.getType().getValue());
        return object2 != null && object2.hasInfoList() && list.size() != object2.getDefaultInfoList(this.makeConfiguration, this).size();
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public StringConfiguration getType() {
        return this.type;
    }

    public void setType(StringConfiguration stringConfiguration) {
        PackagerDescriptor packagerDescriptor = PackagerManager.getDefault().getPackager(stringConfiguration.getValue());
        if (packagerDescriptor == null) {
            packagerDescriptor = new DummyPackager(stringConfiguration.getValue());
            PackagerManager.getDefault().addPackagingDescriptor(packagerDescriptor);
        }
        this.type = stringConfiguration;
    }

    public BooleanConfiguration getVerbose() {
        return this.verbose;
    }

    public void setVerbose(BooleanConfiguration booleanConfiguration) {
        this.verbose = booleanConfiguration;
    }

    public VectorConfiguration getInfo() {
        return this.info;
    }

    public void setInfo(VectorConfiguration vectorConfiguration) {
        this.info = vectorConfiguration;
    }

    public VectorConfiguration getFiles() {
        return this.files;
    }

    public void setFiles(VectorConfiguration vectorConfiguration) {
        this.files = vectorConfiguration;
    }

    public void setOutput(StringConfiguration stringConfiguration) {
        this.output = stringConfiguration;
    }

    public StringConfiguration getOutput() {
        return this.output;
    }

    public void setTool(StringConfiguration stringConfiguration) {
        this.tool = stringConfiguration;
    }

    public StringConfiguration getTool() {
        return this.tool;
    }

    public void setOptions(StringConfiguration stringConfiguration) {
        this.options = stringConfiguration;
    }

    public StringConfiguration getOptions() {
        return this.options;
    }

    public void setTopDir(StringConfiguration stringConfiguration) {
        this.topDir = stringConfiguration;
    }

    public StringConfiguration getTopDir() {
        return this.topDir;
    }

    public void assign(PackagingConfiguration packagingConfiguration) {
        this.setMakeConfiguration(packagingConfiguration.getMakeConfiguration());
        this.getType().assign(packagingConfiguration.getType());
        this.getVerbose().assign(packagingConfiguration.getVerbose());
        this.getInfo().assign(packagingConfiguration.getInfo());
        this.getFiles().assign(packagingConfiguration.getFiles());
        this.getOutput().assign(packagingConfiguration.getOutput());
        this.getTool().assign(packagingConfiguration.getTool());
        this.getOptions().assign(packagingConfiguration.getOptions());
        this.getTopDir().assign(packagingConfiguration.getTopDir());
    }

    public Object clone() {
        PackagingConfiguration packagingConfiguration = new PackagingConfiguration(this.getMakeConfiguration());
        packagingConfiguration.setType((StringConfiguration)this.getType().clone());
        packagingConfiguration.setVerbose((BooleanConfiguration)this.getVerbose().clone());
        packagingConfiguration.setInfo((VectorConfiguration)this.getInfo().clone());
        packagingConfiguration.setFiles((VectorConfiguration)this.getFiles().clone());
        packagingConfiguration.setOutput((StringConfiguration)this.getOutput().clone());
        packagingConfiguration.setTool((StringConfiguration)this.getTool().clone());
        packagingConfiguration.setOptions((StringConfiguration)this.getOptions().clone());
        packagingConfiguration.setTopDir((StringConfiguration)this.getTopDir().clone());
        return packagingConfiguration;
    }

    public Sheet getGeneralSheet(MakeCustomizer makeCustomizer) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("General");
        set.setDisplayName(PackagingConfiguration.getString("GeneralTxt"));
        set.setShortDescription(PackagingConfiguration.getString("GeneralHint"));
        PackagerIntConfiguration packagerIntConfiguration = new PackagerIntConfiguration(null, 0, PackagerManager.getDefault().getDisplayNames(), null);
        PackagerIntNodeProp packagerIntNodeProp = new PackagerIntNodeProp(packagerIntConfiguration, true, "PackageType", PackagingConfiguration.getString("PackageTypeName"), PackagingConfiguration.getString("PackageTypeHint"));
        set.put((Node.Property)packagerIntNodeProp);
        OutputNodeProp outputNodeProp = new OutputNodeProp(this.getOutput(), this.getOutputDefault(), "Output", PackagingConfiguration.getString("OutputTxt"), PackagingConfiguration.getString("OutputHint"));
        set.put((Node.Property)outputNodeProp);
        String[] stringArray = new String[]{"Files", PackagingConfiguration.getString("FilesName"), PackagingConfiguration.getString("FilesHint")};
        set.put((Node.Property)new PackagingNodeProp(this, this.makeConfiguration, stringArray));
        StringNodeProp stringNodeProp = new StringNodeProp(this.getTool(), this.getToolDefault(), "Tool", PackagingConfiguration.getString("ToolTxt1"), PackagingConfiguration.getString("ToolHint1"));
        set.put((Node.Property)stringNodeProp);
        StringNodeProp stringNodeProp2 = new StringNodeProp(this.getOptions(), this.getOptionsDefault(), "AdditionalOptions", PackagingConfiguration.getString("AdditionalOptionsTxt1"), PackagingConfiguration.getString("AdditionalOptionsHint"));
        set.put((Node.Property)stringNodeProp2);
        set.put((Node.Property)new BooleanNodeProp(this.getVerbose(), true, "Verbose", PackagingConfiguration.getString("VerboseName"), PackagingConfiguration.getString("VerboseHint")));
        sheet.put(set);
        this.typePropertyChangeListener = new TypePropertyChangeListener(makeCustomizer, outputNodeProp, stringNodeProp, stringNodeProp2);
        packagerIntNodeProp.getPropertyEditor().addPropertyChangeListener(this.typePropertyChangeListener);
        return sheet;
    }

    public String getOutputValue() {
        if (this.getOutput().getModified()) {
            return this.getOutput().getValue();
        }
        return this.getOutputDefault();
    }

    public String getTopDirValue() {
        if (this.getTopDir().getModified()) {
            return this.getTopDir().getValue();
        }
        PackagerDescriptor packagerDescriptor = PackagerManager.getDefault().getPackager(this.getType().getValue());
        if (packagerDescriptor != null) {
            return packagerDescriptor.getTopDir(this.makeConfiguration, this);
        }
        return "";
    }

    public String getOutputName() {
        String string = IpeUtils.getBaseName((String)this.getMakeConfiguration().getBaseDir());
        if (this.getMakeConfiguration().getConfigurationType().getValue() == 1) {
            string = string.toLowerCase();
        } else if (this.getMakeConfiguration().getConfigurationType().getValue() == 2) {
            Platform platform = Platforms.getPlatform(this.getMakeConfiguration().getPlatform().getValue());
            string = platform.getLibraryName(string);
        }
        string = this.createValidPackageName(string);
        return string;
    }

    private String getOutputDefault() {
        String string = "dist/" + this.getMakeConfiguration().getName() + "/" + "${PLATFORM}" + "/package";
        PackagerDescriptor packagerDescriptor = PackagerManager.getDefault().getPackager(this.getType().getValue());
        if (!packagerDescriptor.isOutputAFolder()) {
            string = string + "/" + packagerDescriptor.getOutputFileName(this.makeConfiguration, this) + "." + packagerDescriptor.getOutputFileSuffix();
        }
        return string;
    }

    public String getToolValue() {
        if (this.getTool().getModified()) {
            return this.getTool().getValue();
        }
        return this.getToolDefault();
    }

    private String getToolDefault() {
        PackagerDescriptor packagerDescriptor = PackagerManager.getDefault().getPackager(this.getType().getValue());
        return packagerDescriptor.getDefaultTool();
    }

    public String getOptionsValue() {
        if (this.getOptions().getModified()) {
            return this.getOptions().getValue();
        }
        return this.getOptionsDefault();
    }

    private String getOptionsDefault() {
        PackagerDescriptor packagerDescriptor = PackagerManager.getDefault().getPackager(this.getType().getValue());
        return packagerDescriptor.getDefaultOptions();
    }

    public String[] getDisplayNames() {
        return PackagerManager.getDefault().getDisplayNames();
    }

    public String getDisplayName() {
        return PackagerManager.getDefault().getDisplayName(this.getType().getValue());
    }

    public String getName() {
        return this.getType().getValue();
    }

    public String expandMacros(String string) {
        string = this.makeConfiguration.expandMacros(string);
        string = IpeUtils.expandMacro((String)string, (String)"${PACKAGE_TOP_DIR}", (String)(this.getTopDirValue().length() > 0 ? this.getTopDirValue() + "/" : ""));
        return string;
    }

    private String createValidPackageName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_' || c == ' ') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public PackagerInfoElement findInfoElement(String string) {
        List list = this.getInfo().getValue();
        for (PackagerInfoElement packagerInfoElement : list) {
            if (!packagerInfoElement.getName().equals(string)) continue;
            return packagerInfoElement;
        }
        return null;
    }

    public String findInfoValueName(String string) {
        List list = this.getInfo().getValue();
        for (PackagerInfoElement packagerInfoElement : list) {
            if (!packagerInfoElement.getName().equals(string)) continue;
            return packagerInfoElement.getValue();
        }
        return null;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(PackagingConfiguration.class, (String)string);
    }

    private class OutputNodeProp
    extends StringNodeProp {
        public OutputNodeProp(StringConfiguration stringConfiguration, String string, String string2, String string3, String string4) {
            super(stringConfiguration, string, string2, string3, string4);
        }

        public void setValue(Object object) {
            if (IpeUtils.hasMakeSpecialCharacters((String)((String)object))) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PackagingConfiguration.getString("SPECIAL_CHARATERS_ERROR"), 0));
                return;
            }
            super.setValue(object);
        }
    }

    class TypePropertyChangeListener
    implements PropertyChangeListener {
        private MakeCustomizer makeCustomizer;
        private OutputNodeProp outputNodeProp;
        private StringNodeProp toolNodeProp;
        private StringNodeProp optionsNodeProp;

        TypePropertyChangeListener(MakeCustomizer makeCustomizer, OutputNodeProp outputNodeProp, StringNodeProp stringNodeProp, StringNodeProp stringNodeProp2) {
            this.makeCustomizer = makeCustomizer;
            this.outputNodeProp = outputNodeProp;
            this.toolNodeProp = stringNodeProp;
            this.optionsNodeProp = stringNodeProp2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!PackagingConfiguration.this.output.getModified()) {
                this.outputNodeProp.setDefaultValue(PackagingConfiguration.this.getOutputDefault());
                PackagingConfiguration.this.output.reset();
            }
            if (!PackagingConfiguration.this.tool.getModified()) {
                this.toolNodeProp.setDefaultValue(PackagingConfiguration.this.getToolDefault());
                PackagingConfiguration.this.tool.reset();
            }
            if (!PackagingConfiguration.this.options.getModified()) {
                this.optionsNodeProp.setDefaultValue(PackagingConfiguration.this.getOptionsDefault());
                PackagingConfiguration.this.options.reset();
            }
            this.makeCustomizer.validate();
            this.makeCustomizer.repaint();
        }
    }

    class PackagerIntNodeProp
    extends IntNodeProp {
        public PackagerIntNodeProp(IntConfiguration intConfiguration, boolean bl, String string, String string2, String string3) {
            super(intConfiguration, bl, string, string2, string3);
        }

        public Object getValue() {
            return new Integer(PackagerManager.getDefault().getNameIndex(PackagingConfiguration.this.getType().getValue()));
        }

        public void setValue(Object object) {
            String string = (String)object;
            String string2 = PackagerManager.getDefault().getName(string);
            if (string2 != null) {
                PackagingConfiguration.this.getType().setValue(string2);
            } else assert (false);
        }
    }

    class PackagerIntConfiguration
    extends IntConfiguration {
        PackagerIntConfiguration(IntConfiguration intConfiguration, int n, String[] stringArray, String[] stringArray2) {
            super(intConfiguration, n, stringArray, stringArray2);
        }

        public void setValue(String string) {
            if (string != null) {
                String string2 = string;
                String string3 = PackagerManager.getDefault().getName(string2);
                if (string3 != null) {
                    PackagingConfiguration.this.getType().setValue(string3);
                } else assert (false);
            }
        }

        public int getValue() {
            int n = PackagerManager.getDefault().getNameIndex(PackagingConfiguration.this.getType().getValue());
            return n;
        }
    }
}

