/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class MakeArtifactChooser
extends JPanel
implements PropertyChangeListener {
    private ArtifactType artifactType;
    private JPanel leftPanel;
    private JLabel libFilesLabel;
    private JList listArtifacts;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JScrollPane scrollPane1;

    public MakeArtifactChooser(ArtifactType artifactType, JFileChooser jFileChooser) {
        this.artifactType = artifactType;
        this.initComponents();
        this.listArtifacts.setModel(new DefaultListModel());
        jFileChooser.addPropertyChangeListener(this);
        this.listArtifacts.getAccessibleContext().setAccessibleDescription(MakeArtifactChooser.getString("PROJECT_LIBRARY_FILES_AD"));
        this.libFilesLabel.setDisplayedMnemonic(MakeArtifactChooser.getString("PROJECT_LIBRARY_FILES_MN").charAt(0));
    }

    private void initComponents() {
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.libFilesLabel = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.listArtifacts = new JList();
        this.leftPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("PROJECT_NAME_TXT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(null);
        this.libFilesLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("PROJECT_LIBRARY_FILES_MN").charAt(0));
        this.libFilesLabel.setLabelFor(this.listArtifacts);
        Mnemonics.setLocalizedText((JLabel)this.libFilesLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/configurations/ui/Bundle").getString("PROJECT_LIBRARY_FILES_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.libFilesLabel, gridBagConstraints);
        this.scrollPane1.setViewportView(this.listArtifacts);
        this.listArtifacts.getAccessibleContext().setAccessibleDescription(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.scrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 16;
        this.add((Component)this.leftPanel, gridBagConstraints);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
            File file = jFileChooser.getSelectedFile();
            Project project = this.getProject(file);
            this.populateAccessory(project);
        }
    }

    private Project getProject(File file) {
        if (file == null) {
            return null;
        }
        try {
            File file2 = FileUtil.normalizeFile((File)file);
            FileObject fileObject = FileUtil.toFileObject((File)file2);
            if (fileObject != null) {
                return ProjectManager.getDefault().findProject(fileObject);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return null;
    }

    private void populateAccessory(Project project) {
        DefaultListModel defaultListModel = (DefaultListModel)this.listArtifacts.getModel();
        defaultListModel.clear();
        this.projectTextField.setText(project == null ? "" : ProjectUtils.getInformation((Project)project).getDisplayName());
        if (project != null) {
            MakeArtifact[] makeArtifactArray = MakeArtifact.getMakeArtifacts(project);
            if (makeArtifactArray == null) {
                return;
            }
            int n = 0;
            for (int i = 0; i < makeArtifactArray.length; ++i) {
                if (this.artifactType == ArtifactType.LIBRARY) {
                    if (makeArtifactArray[i].getConfigurationType() == 0 && (makeArtifactArray[i].getOutput().endsWith(".a") || makeArtifactArray[i].getOutput().endsWith(".so") || makeArtifactArray[i].getOutput().endsWith(".dylib") || makeArtifactArray[i].getOutput().endsWith(".lib") || makeArtifactArray[i].getOutput().endsWith(".dll")) || makeArtifactArray[i].getConfigurationType() == 2 || makeArtifactArray[i].getConfigurationType() == 3) {
                        defaultListModel.addElement(makeArtifactArray[i]);
                    }
                } else if (this.artifactType == ArtifactType.PROJECT) {
                    defaultListModel.addElement(makeArtifactArray[i]);
                } else assert (false);
                if (!makeArtifactArray[i].getActive()) continue;
                n = i;
            }
            this.listArtifacts.setSelectionInterval(n, n);
        }
    }

    public static MakeArtifact[] showDialog(ArtifactType artifactType, Project project, Component component) {
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        jFileChooser.getAccessibleContext().setAccessibleDescription(MakeArtifactChooser.getString("ADD_PROJECT_DIALOG_AD"));
        jFileChooser.setDialogTitle(MakeArtifactChooser.getString("ADD_PROJECT_DIALOG_TITLE"));
        jFileChooser.setApproveButtonText(MakeArtifactChooser.getString("ADD_BUTTON_TXT"));
        MakeArtifactChooser makeArtifactChooser = new MakeArtifactChooser(artifactType, jFileChooser);
        jFileChooser.setAccessory(makeArtifactChooser);
        jFileChooser.setPreferredSize(new Dimension(650, 380));
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            Project project2 = makeArtifactChooser.getProject(file = FileUtil.normalizeFile((File)file));
            if (project2 == null) {
                return null;
            }
            if (project2.getProjectDirectory().equals(project.getProjectDirectory())) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeArtifactChooser.getString("ADD_ITSELF_ERROR"), 1));
                return null;
            }
            if (ProjectUtils.hasSubprojectCycles((Project)project, (Project)project2)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeArtifactChooser.getString("ADD_CYCLIC_ERROR"), 1));
                return null;
            }
            Object[] objectArray = new Object[makeArtifactChooser.listArtifacts.getModel().getSize()];
            int n2 = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!makeArtifactChooser.listArtifacts.isSelectedIndex(i)) continue;
                objectArray[n2] = makeArtifactChooser.listArtifacts.getModel().getElementAt(i);
                ++n2;
            }
            MakeArtifact[] makeArtifactArray = new MakeArtifact[n2];
            System.arraycopy(objectArray, 0, makeArtifactArray, 0, n2);
            return makeArtifactArray;
        }
        return null;
    }

    private static String getString(String string) {
        return NbBundle.getBundle(MakeArtifactChooser.class).getString(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ArtifactType {
        PROJECT,
        LIBRARY;

    }
}

