/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.Image;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.ui.utils.ListEditorPanel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class TableEditorPanel
extends ListEditorPanel {
    private static Image brokenProjectBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif");
    private String baseDir;
    private JTable targetList;
    private MyTableCellRenderer myTableCellRenderer = new MyTableCellRenderer();
    private static ResourceBundle bundle;

    public char getDownButtonMnemonics() {
        return TableEditorPanel.getString("DOWN_OPTION_BUTTON_MN").charAt(0);
    }

    public TableEditorPanel(Object[] objectArray, JButton[] jButtonArray, String string) {
        super(objectArray, jButtonArray);
        this.baseDir = string;
    }

    public int getSelectedIndex() {
        int n = this.getTargetList().getSelectedRow();
        if (n >= 0 && n < this.listData.size()) {
            return n;
        }
        return 0;
    }

    protected void setSelectedIndex(int n) {
        this.getTargetList().getSelectionModel().setSelectionInterval(n, n);
    }

    protected void setData(Vector vector) {
        this.getTargetList().setModel(new MyTableModel());
        this.getTargetList().getColumnModel().getColumn(1).setPreferredWidth(100);
        this.getTargetList().getColumnModel().getColumn(1).setMaxWidth(200);
        this.getTargetList().getColumnModel().getColumn(2).setPreferredWidth(40);
        this.getTargetList().getColumnModel().getColumn(2).setMaxWidth(100);
        this.getTargetList().getSelectionModel().setSelectionMode(0);
        this.getTargetList().getSelectionModel().addListSelectionListener(new TargetSelectionListener());
        ((DefaultTableCellRenderer)this.getTargetList().getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
    }

    protected void ensureIndexIsVisible(int n) {
    }

    protected Component getViewComponent() {
        return this.getTargetList();
    }

    private JTable getTargetList() {
        if (this.targetList == null) {
            this.targetList = new MyTable();
            this.setData(null);
        }
        return this.targetList;
    }

    private static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(TableEditorPanel.class);
        }
        return bundle.getString(string);
    }

    class MyTableModel
    extends DefaultTableModel {
        private String[] columnNames = new String[]{TableEditorPanel.access$900("ITEM"), TableEditorPanel.access$900("CONFIGURATION"), TableEditorPanel.access$900("BUILD")};

        MyTableModel() {
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return TableEditorPanel.this.listData.size();
        }

        public Object getValueAt(int n, int n2) {
            return TableEditorPanel.this.listData.elementAt(n);
        }

        public boolean isCellEditable(int n, int n2) {
            Object e = TableEditorPanel.this.listData.elementAt(n);
            LibraryItem libraryItem = (LibraryItem)e;
            if (n2 == 0) {
                return libraryItem.canEdit();
            }
            if (n2 == 1) {
                if (libraryItem instanceof LibraryItem.ProjectItem) {
                    return ((LibraryItem.ProjectItem)libraryItem).getProject(TableEditorPanel.this.baseDir) != null;
                }
                return false;
            }
            return libraryItem instanceof LibraryItem.ProjectItem;
        }

        public void setValueAt(Object object, int n, int n2) {
            LibraryItem libraryItem = (LibraryItem)TableEditorPanel.this.listData.elementAt(n);
            if (n2 == 0) {
                libraryItem.setValue((String)object);
                this.fireTableCellUpdated(n, n2);
            } else if (n2 == 1) {
                MakeArtifact makeArtifact = ((LibraryItem.ProjectItem)libraryItem).getMakeArtifact();
                boolean bl = IpeUtils.isPathAbsolute((String)makeArtifact.getProjectLocation());
                TableEditorPanel.this.listData.removeElementAt(n);
                MakeArtifact makeArtifact2 = ((MakeArtifactWrapper)object).getMakeArtifact();
                String string = makeArtifact2.getProjectLocation();
                String string2 = makeArtifact2.getWorkingDirectory();
                if (!bl) {
                    string = IpeUtils.toRelativePath((String)TableEditorPanel.this.baseDir, (String)string);
                    string2 = IpeUtils.toRelativePath((String)TableEditorPanel.this.baseDir, (String)string2);
                }
                makeArtifact2.setProjectLocation(FilePathAdaptor.normalize(string));
                makeArtifact2.setWorkingDirectory(FilePathAdaptor.normalize(string2));
                TableEditorPanel.this.listData.add(n, new LibraryItem.ProjectItem(makeArtifact2));
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            } else {
                if (libraryItem instanceof LibraryItem.ProjectItem) {
                    MakeArtifact makeArtifact;
                    makeArtifact.setBuild(!(makeArtifact = (MakeArtifact)((LibraryItem.ProjectItem)libraryItem).getMakeArtifact().clone()).getBuild());
                    TableEditorPanel.this.listData.removeElementAt(n);
                    TableEditorPanel.this.listData.add(n, new LibraryItem.ProjectItem(makeArtifact));
                }
                this.fireTableCellUpdated(n, 0);
                this.fireTableCellUpdated(n, 1);
                this.fireTableCellUpdated(n, 2);
            }
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        MyTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Object e = TableEditorPanel.this.listData.elementAt(n);
            if (!(e instanceof LibraryItem)) {
                jLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/resources/blank.gif")));
                jLabel.setToolTipText("unknown");
                return jLabel;
            }
            LibraryItem libraryItem = (LibraryItem)e;
            if (n2 == 0) {
                Image image = ImageUtilities.loadImage((String)libraryItem.getIconName());
                jLabel.setToolTipText(libraryItem.getToolTip());
                if (libraryItem instanceof LibraryItem.ProjectItem && ((LibraryItem.ProjectItem)libraryItem).getProject(TableEditorPanel.this.baseDir) == null) {
                    image = ImageUtilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0);
                    jLabel.setToolTipText(TableEditorPanel.getString("BROKEN") + jLabel.getToolTipText());
                }
                jLabel.setIcon(new ImageIcon(image));
            } else if (n2 == 1) {
                jLabel.setText("");
                jLabel.setIcon(null);
                jLabel.setToolTipText(null);
                if (libraryItem instanceof LibraryItem.ProjectItem) {
                    jLabel.setText(((LibraryItem.ProjectItem)libraryItem).getMakeArtifact().getConfigurationName());
                    jLabel.setToolTipText(TableEditorPanel.getString("CLICK_TO_CHANGE"));
                    if (((LibraryItem.ProjectItem)libraryItem).getProject(TableEditorPanel.this.baseDir) == null) {
                        jLabel.setToolTipText("");
                    }
                }
            } else {
                if (libraryItem instanceof LibraryItem.ProjectItem) {
                    JCheckBox jCheckBox = new JCheckBox();
                    jCheckBox.setSelected(((LibraryItem.ProjectItem)libraryItem).getMakeArtifact().getBuild());
                    jCheckBox.setBackground(jLabel.getBackground());
                    return jCheckBox;
                }
                jLabel.setText("");
                jLabel.setIcon(null);
                jLabel.setToolTipText(null);
            }
            return jLabel;
        }
    }

    class MakeArtifactWrapper {
        private MakeArtifact makeArtifact;

        public MakeArtifactWrapper(MakeArtifact makeArtifact) {
            this.makeArtifact = makeArtifact;
        }

        public MakeArtifact getMakeArtifact() {
            return this.makeArtifact;
        }

        public String toString() {
            return this.getMakeArtifact().getConfigurationName();
        }
    }

    class MyTable
    extends JTable {
        public MyTable() {
            if (this.getRowHeight() < 19) {
                this.setRowHeight(19);
            }
            this.getAccessibleContext().setAccessibleDescription("");
            this.getAccessibleContext().setAccessibleName("");
        }

        public boolean getShowHorizontalLines() {
            return false;
        }

        public boolean getShowVerticalLines() {
            return false;
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            return TableEditorPanel.this.myTableCellRenderer;
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            if (n2 == 0) {
                return super.getCellEditor(n, n2);
            }
            if (n2 == 1) {
                LibraryItem.ProjectItem projectItem = (LibraryItem.ProjectItem)TableEditorPanel.this.listData.elementAt(n);
                Project project = projectItem.getProject(TableEditorPanel.this.baseDir);
                if (project == null) {
                    return super.getCellEditor(n, n2);
                }
                MakeArtifact[] makeArtifactArray = MakeArtifact.getMakeArtifacts(project);
                JComboBox<MakeArtifactWrapper> jComboBox = new JComboBox<MakeArtifactWrapper>();
                for (int i = 0; i < makeArtifactArray.length; ++i) {
                    jComboBox.addItem(new MakeArtifactWrapper(makeArtifactArray[i]));
                }
                return new DefaultCellEditor(jComboBox);
            }
            LibraryItem libraryItem = (LibraryItem)TableEditorPanel.this.listData.elementAt(n);
            if (libraryItem instanceof LibraryItem.ProjectItem) {
                LibraryItem.ProjectItem projectItem = (LibraryItem.ProjectItem)TableEditorPanel.this.listData.elementAt(n);
                JCheckBox jCheckBox = new JCheckBox();
                jCheckBox.setSelected(((LibraryItem.ProjectItem)libraryItem).getMakeArtifact().getBuild());
                return new DefaultCellEditor(jCheckBox);
            }
            return super.getCellEditor(n, n2);
        }
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            TableEditorPanel.this.checkSelection();
        }
    }
}

