/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JOptionPane;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.makeproject.MakeActionProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class DevelopmentHostCustomizer
extends JOptionPane
implements VetoableChangeListener {
    private DevelopmentHostConfiguration dhconf;
    private PropertyEnv env;

    public DevelopmentHostCustomizer(DevelopmentHostConfiguration developmentHostConfiguration, PropertyEnv propertyEnv) {
        super(NbBundle.getMessage(DevelopmentHostCustomizer.class, (String)(developmentHostConfiguration.isOnline() ? "ERR_NothingToDo" : "ERR_NeedToInitializeRemoteHost"), (Object)developmentHostConfiguration.getName()), 3, -1, null, new Object[0]);
        this.dhconf = developmentHostConfiguration;
        this.env = propertyEnv;
        if (!developmentHostConfiguration.isOnline()) {
            propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            propertyEnv.addVetoableChangeListener((VetoableChangeListener)this);
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (!this.dhconf.isOnline()) {
            String string = this.dhconf.getName();
            ServerList serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class);
            assert (serverList != null);
            final ServerRecord serverRecord = serverList.get(string);
            assert (serverRecord != null);
            Frame frame = WindowManager.getDefault().getMainWindow();
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        serverRecord.validate(true);
                        CompilerSetManager compilerSetManager = CompilerSetManager.getDefault((String)serverRecord.getName());
                        compilerSetManager.initialize(true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            String string2 = NbBundle.getMessage(MakeActionProvider.class, (String)"MSG_Configure_Host_Progress", (Object)serverRecord.getName());
            ModalMessageDlg.runLongTask((Frame)frame, (Runnable)runnable, null, (String)NbBundle.getMessage(MakeActionProvider.class, (String)"DLG_TITLE_Configure_Host"), (String)string2);
            this.env.removeVetoableChangeListener((VetoableChangeListener)this);
            this.env.setState(PropertyEnv.STATE_VALID);
            if (!serverRecord.isOnline()) {
                System.err.println("");
            }
        }
    }
}

