/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.utils.ElfDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.ElfExecutableFileFilter;
import org.netbeans.modules.cnd.api.utils.ElfStaticLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.FileChooser;
import org.netbeans.modules.cnd.api.utils.MacOSXDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.MacOSXExecutableFileFilter;
import org.netbeans.modules.cnd.api.utils.PeDynamicLibraryFileFilter;
import org.netbeans.modules.cnd.api.utils.PeExecutableFileFilter;
import org.netbeans.modules.cnd.makeproject.api.remote.FilePathAdaptor;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.makeproject.ui.utils.ListEditorPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.cnd.makeproject.ui.wizards.ParserConfigurationDescriptorPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ParserConfigurationPanel
extends JPanel
implements HelpCtx.Provider {
    private ParserConfigurationDescriptorPanel sourceFoldersDescriptorPanel;
    private boolean first = true;
    private boolean lastApplicable;
    private JButton additionalLibrariesButton;
    private JRadioButton automaticButton;
    private ButtonGroup buttonGroup1;
    private JLabel codeModelLabel;
    private JPanel codeModelPanel;
    private JComboBox configurationComboBox;
    private JLabel configurationLabel;
    private JPanel discoveryPanel;
    private JButton includeEditButton;
    private JLabel includeLabel;
    private JTextField includeTextField;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JLabel jLabel2;
    private JLabel librariesLabel;
    private JTextField librariesTextField;
    private JButton macroEditButton;
    private JTextField macroTextField;
    private JRadioButton manualButton;

    public ParserConfigurationPanel(ParserConfigurationDescriptorPanel parserConfigurationDescriptorPanel) {
        this.initComponents();
        this.sourceFoldersDescriptorPanel = parserConfigurationDescriptorPanel;
        this.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("INCLUDE_LABEL_AD"));
        this.includeTextField.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("INCLUDE_LABEL_AD"));
        this.includeEditButton.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("INCLUDE_BROWSE_BUTTON_AD"));
        this.macroTextField.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("MACRO_LABEL_AD"));
        this.macroEditButton.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("MACRO_EDIT_BUTTON_AD"));
        this.configurationComboBox.addItem(new ConfigutationItem("project", ParserConfigurationPanel.getString("CONFIGURATION_LEVEL_project")));
        this.configurationComboBox.addItem(new ConfigutationItem("folder", ParserConfigurationPanel.getString("CONFIGURATION_LEVEL_folder")));
        this.configurationComboBox.addItem(new ConfigutationItem("file", ParserConfigurationPanel.getString("CONFIGURATION_LEVEL_file")));
        this.configurationComboBox.setSelectedIndex(2);
        this.addListeners();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NewMakeWizardP4");
    }

    private boolean isApplicable(WizardDescriptor wizardDescriptor) {
        IteratorExtension iteratorExtension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
        if (iteratorExtension != null) {
            boolean bl = iteratorExtension.isApplicable(wizardDescriptor);
            String string = iteratorExtension.getProviderID(wizardDescriptor);
            if ("dwarf-executable".equals(string)) {
                this.additionalLibrariesButton.setVisible(true);
                this.librariesLabel.setVisible(true);
                this.librariesTextField.setVisible(true);
            } else {
                this.additionalLibrariesButton.setVisible(false);
                this.librariesLabel.setVisible(false);
                this.librariesTextField.setVisible(false);
            }
            return bl;
        }
        return false;
    }

    private void addListeners() {
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ParserConfigurationPanel.this.update(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ParserConfigurationPanel.this.update(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ParserConfigurationPanel.this.update(documentEvent);
            }
        };
        this.librariesTextField.getDocument().addDocumentListener(documentListener);
    }

    private void update(DocumentEvent documentEvent) {
        this.sourceFoldersDescriptorPanel.stateChanged(null);
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.lastApplicable = this.isApplicable(wizardDescriptor);
        if (this.lastApplicable) {
            this.manualButton.setEnabled(true);
            this.automaticButton.setEnabled(true);
            if (this.first) {
                this.automaticButton.setSelected(true);
                this.togglePanel(false);
            }
        } else {
            this.manualButton.setEnabled(true);
            this.automaticButton.setEnabled(true);
            this.manualButton.setSelected(true);
            this.togglePanel(true);
        }
        this.first = false;
    }

    void store(WizardDescriptor wizardDescriptor) {
        if (this.manualButton.isSelected()) {
            wizardDescriptor.putProperty("includeTextField", (Object)this.includeTextField.getText());
            wizardDescriptor.putProperty("macroTextField", (Object)this.macroTextField.getText());
        } else {
            wizardDescriptor.putProperty("includeTextField", (Object)"");
            wizardDescriptor.putProperty("macroTextField", (Object)"");
        }
        if (this.automaticButton.isSelected()) {
            ConfigutationItem configutationItem = (ConfigutationItem)this.configurationComboBox.getSelectedItem();
            wizardDescriptor.putProperty("consolidationLevel", (Object)configutationItem.getID());
            wizardDescriptor.putProperty("additionalLibraries", (Object)this.librariesTextField.getText());
        } else {
            wizardDescriptor.putProperty("consolidationLevel", (Object)"");
            wizardDescriptor.putProperty("additionalLibraries", (Object)"");
        }
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.automaticButton.isSelected()) {
            if (!this.lastApplicable) {
                String string = (String)wizardDescriptor.getProperty("outputTextField");
                if (string == null || string.length() == 0) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)ParserConfigurationPanel.getString("Automatic.Error.NoOutputResult"));
                    return false;
                }
                File file = new File(string);
                if (!file.exists()) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)ParserConfigurationPanel.getString("Automatic.Error.OutputResultNotExist"));
                    return false;
                }
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)ParserConfigurationPanel.getString("Automatic.Error.NoDebugOutputResult"));
                return false;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.librariesTextField.getText(), ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                File file = new File(string);
                if (file.exists() && file.isFile()) continue;
                return false;
            }
        }
        return true;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.codeModelPanel = new JPanel();
        this.includeLabel = new JLabel();
        this.includeTextField = new JTextField();
        this.includeEditButton = new JButton();
        this.jLabel2 = new JLabel();
        this.macroTextField = new JTextField();
        this.codeModelLabel = new JLabel();
        this.macroEditButton = new JButton();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.manualButton = new JRadioButton();
        this.automaticButton = new JRadioButton();
        this.discoveryPanel = new JPanel();
        this.configurationComboBox = new JComboBox();
        this.configurationLabel = new JLabel();
        this.librariesLabel = new JLabel();
        this.librariesTextField = new JTextField();
        this.additionalLibrariesButton = new JButton();
        this.setMinimumSize(new Dimension(300, 158));
        this.setPreferredSize(new Dimension(323, 223));
        this.setLayout(new GridBagLayout());
        this.codeModelPanel.setLayout(new GridBagLayout());
        this.includeLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("INCLUDE_LABEL_MN").charAt(0));
        this.includeLabel.setLabelFor(this.includeTextField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        this.includeLabel.setText(resourceBundle.getString("INCLUDE_LABEL_TXT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.codeModelPanel.add((Component)this.includeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.codeModelPanel.add((Component)this.includeTextField, gridBagConstraints);
        this.includeEditButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("INCLUDE_BROWSE_BUTTON_MN").charAt(0));
        this.includeEditButton.setText(resourceBundle.getString("INCLUDE_BROWSE_BUTTON_TXT"));
        this.includeEditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParserConfigurationPanel.this.includeEditButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.codeModelPanel.add((Component)this.includeEditButton, gridBagConstraints);
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("MACRO_LABEL_MN").charAt(0));
        this.jLabel2.setLabelFor(this.macroTextField);
        this.jLabel2.setText(resourceBundle.getString("MACRO_LABEL_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.codeModelPanel.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.codeModelPanel.add((Component)this.macroTextField, gridBagConstraints);
        this.codeModelLabel.setText(resourceBundle.getString("CODEMODEL_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.codeModelPanel.add((Component)this.codeModelLabel, gridBagConstraints);
        this.macroEditButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("MACRO_EDIT_BUTTON_MN").charAt(0));
        this.macroEditButton.setText(resourceBundle.getString("MACRO_EDIT_BUTTON_TXT"));
        this.macroEditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParserConfigurationPanel.this.macroEditButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.codeModelPanel.add((Component)this.macroEditButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.codeModelPanel, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setText(resourceBundle.getString("SourceFoldersInstructions"));
        this.instructionsTextArea.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        this.instructionsTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ParserConfigurationPanel.class, (String)"INFO_AREA_AN"));
        this.instructionsTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParserConfigurationPanel.class, (String)"INFO_AREA_AD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.buttonGroup1.add(this.manualButton);
        this.manualButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("ParserManualConfiguration_MN").charAt(0));
        this.manualButton.setText(resourceBundle.getString("ParserManualConfiguration"));
        this.manualButton.setMargin(new Insets(0, 0, 0, 0));
        this.manualButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParserConfigurationPanel.this.manualButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.manualButton, gridBagConstraints);
        this.manualButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParserConfigurationPanel.class, (String)"ParserManualConfiguration_AD"));
        this.buttonGroup1.add(this.automaticButton);
        this.automaticButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("ParserAutomaticConfiguration_MN").charAt(0));
        this.automaticButton.setText(resourceBundle.getString("ParserAutomaticConfiguration"));
        this.automaticButton.setMargin(new Insets(0, 0, 0, 0));
        this.automaticButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParserConfigurationPanel.this.automaticButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.automaticButton, gridBagConstraints);
        this.automaticButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParserConfigurationPanel.class, (String)"ParserAutomaticConfiguration_AD"));
        this.discoveryPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.discoveryPanel.add((Component)this.configurationComboBox, gridBagConstraints);
        this.configurationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParserConfigurationPanel.class, (String)"ConfigurationCombobox_AD"));
        this.configurationLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("ConfigurationLevelLabel_MN").charAt(0));
        this.configurationLabel.setLabelFor(this.configurationComboBox);
        this.configurationLabel.setText(resourceBundle.getString("ConfigurationLevelLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.discoveryPanel.add((Component)this.configurationLabel, gridBagConstraints);
        this.librariesLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("AdditionalLibrariesLabel_MN").charAt(0));
        this.librariesLabel.setLabelFor(this.librariesTextField);
        this.librariesLabel.setText(resourceBundle.getString("AdditionalLibrariesLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.discoveryPanel.add((Component)this.librariesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.discoveryPanel.add((Component)this.librariesTextField, gridBagConstraints);
        this.additionalLibrariesButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle").getString("LIBRARY_EDIT_BUTTON_MN").charAt(0));
        this.additionalLibrariesButton.setText(resourceBundle.getString("LIBRARY_EDIT_BUTTON_TXT"));
        this.additionalLibrariesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParserConfigurationPanel.this.additionalLibrariesButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.discoveryPanel.add((Component)this.additionalLibrariesButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.discoveryPanel, gridBagConstraints);
    }

    private void automaticButtonActionPerformed(ActionEvent actionEvent) {
        this.togglePanel(false);
        this.update((DocumentEvent)null);
    }

    private void manualButtonActionPerformed(ActionEvent actionEvent) {
        this.togglePanel(true);
        this.update((DocumentEvent)null);
    }

    private void togglePanel(boolean bl) {
        for (Component component : this.codeModelPanel.getComponents()) {
            component.setEnabled(bl);
        }
        for (Component component : this.discoveryPanel.getComponents()) {
            component.setEnabled(!bl);
        }
        if (bl) {
            this.instructionsTextArea.setText(ParserConfigurationPanel.getString("SourceFoldersInstructions"));
        } else {
            this.instructionsTextArea.setText(ParserConfigurationPanel.getString("DiscoveryInstructions"));
        }
    }

    private void additionalLibrariesButtonActionPerformed(ActionEvent actionEvent) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.librariesTextField.getText(), ";");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        AdditionalLibrariesListPanel additionalLibrariesListPanel = new AdditionalLibrariesListPanel(arrayList.toArray());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.addOuterPanel(additionalLibrariesListPanel), ParserConfigurationPanel.getString("ADDITIONAL_LIBRARIES_TXT"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            Vector vector = additionalLibrariesListPanel.getListData();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(vector.elementAt(i));
            }
            this.librariesTextField.setText(stringBuilder.toString());
        }
    }

    private void macroEditButtonActionPerformed(ActionEvent actionEvent) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.macroTextField.getText(), "; ");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        MacrosListPanel macrosListPanel = new MacrosListPanel(arrayList.toArray());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.addOuterPanel(macrosListPanel), "Macro Definitions");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            Vector vector = macrosListPanel.getListData();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(vector.elementAt(i));
            }
            this.macroTextField.setText(stringBuilder.toString());
        }
    }

    private void includeEditButtonActionPerformed(ActionEvent actionEvent) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.includeTextField.getText(), ";");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        IncludesListPanel includesListPanel = new IncludesListPanel(arrayList.toArray());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.addOuterPanel(includesListPanel), ParserConfigurationPanel.getString("INCLUDE_DIRIRECTORIES_TXT"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            Vector vector = includesListPanel.getListData();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(vector.elementAt(i));
            }
            this.includeTextField.setText(stringBuilder.toString());
        }
    }

    private JPanel addOuterPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("DIALOG_AD"));
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        jPanel2.setPreferredSize(new Dimension(500, 250));
        return jPanel2;
    }

    private static String getString(String string) {
        return NbBundle.getBundle(PanelProjectLocationVisual.class).getString(string);
    }

    private static class ConfigutationItem {
        private String ID;
        private String name;

        private ConfigutationItem(String string, String string2) {
            this.ID = string;
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }

        public String getID() {
            return this.ID;
        }
    }

    private class MacrosListPanel
    extends ListEditorPanel {
        public MacrosListPanel(Object[] objectArray) {
            super(objectArray);
            this.getDefaultButton().setVisible(false);
        }

        public Object addAction() {
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(ParserConfigurationPanel.getString("ADD_DIALOG_LABEL_TXT"), ParserConfigurationPanel.getString("EDIT_DIALOG_TITLE_TXT"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() != NotifyDescriptor.OK_OPTION) {
                return null;
            }
            String string = inputLine.getInputText();
            return string;
        }

        public String getListLabelText() {
            return ParserConfigurationPanel.getString("MACROS_LIST_TXT");
        }

        public char getListLabelMnemonic() {
            return ParserConfigurationPanel.getString("MACROS_LIST_MN").charAt(0);
        }

        public String getAddButtonText() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_TXT");
        }

        public char getAddButtonMnemonics() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_MN").charAt(0);
        }

        public String getRenameButtonText() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_TXT");
        }

        public char getRenameButtonMnemonics() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_MN").charAt(0);
        }

        public Object copyAction(Object object) {
            return new String((String)object);
        }

        public void editAction(Object object) {
            String string = (String)object;
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(ParserConfigurationPanel.getString("EDIT_DIALOG_LABEL_TXT"), ParserConfigurationPanel.getString("EDIT_DIALOG_TITLE_TXT"));
            inputLine.setInputText(string);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String string2 = inputLine.getInputText();
            Vector vector = this.getListData();
            Object[] objectArray = this.getListData().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != object) continue;
                vector.remove(i);
                vector.add(i, string2);
                break;
            }
        }
    }

    private class IncludesListPanel
    extends ListEditorPanel {
        public IncludesListPanel(Object[] objectArray) {
            super(objectArray);
            this.getDefaultButton().setVisible(false);
        }

        public Object addAction() {
            FileChooser fileChooser;
            int n;
            String string = null;
            if (FileChooser.getCurrectChooserFile() != null) {
                string = FileChooser.getCurrectChooserFile().getPath();
            }
            if (string == null) {
                string = System.getProperty("user.home");
            }
            if ((n = (fileChooser = new FileChooser(ParserConfigurationPanel.getString("INCLUDE_DIR_DIALOG_TITLE_TXT"), ParserConfigurationPanel.getString("INCLUDE_DIR_DIALOG_BUTTON_TXT"), 1, null, string, true)).showOpenDialog((Component)this)) == 1) {
                return null;
            }
            String string2 = fileChooser.getSelectedFile().getPath();
            string2 = FilePathAdaptor.normalize(string2);
            return string2;
        }

        public String getListLabelText() {
            return ParserConfigurationPanel.getString("DIR_LIST_TXT");
        }

        public char getListLabelMnemonic() {
            return ParserConfigurationPanel.getString("DIR_LIST_MN").charAt(0);
        }

        public String getAddButtonText() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_TXT");
        }

        public char getAddButtonMnemonics() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_MN").charAt(0);
        }

        public String getRenameButtonText() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_TXT");
        }

        public char getRenameButtonMnemonics() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_MN").charAt(0);
        }

        public Object copyAction(Object object) {
            return new String((String)object);
        }

        public void editAction(Object object) {
            String string = (String)object;
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(ParserConfigurationPanel.getString("EDIT_DIALOG_LABEL_TXT"), ParserConfigurationPanel.getString("EDIT_DIALOG_TITLE_TXT"));
            inputLine.setInputText(string);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String string2 = inputLine.getInputText();
            Vector vector = this.getListData();
            Object[] objectArray = this.getListData().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != object) continue;
                vector.remove(i);
                vector.add(i, string2);
                break;
            }
        }
    }

    private class AdditionalLibrariesListPanel
    extends ListEditorPanel {
        public AdditionalLibrariesListPanel(Object[] objectArray) {
            super(objectArray);
            this.getDefaultButton().setVisible(false);
            this.getUpButton().setVisible(false);
            this.getDownButton().setVisible(false);
            this.getCopyButton().setVisible(false);
        }

        public Object addAction() {
            String string = null;
            if (FileChooser.getCurrectChooserFile() != null) {
                string = FileChooser.getCurrectChooserFile().getPath();
            }
            if (string == null) {
                string = System.getProperty("user.home");
            }
            FileFilter[] fileFilterArray = Utilities.isWindows() ? new FileFilter[]{PeExecutableFileFilter.getInstance(), ElfStaticLibraryFileFilter.getInstance(), PeDynamicLibraryFileFilter.getInstance()} : (Utilities.getOperatingSystem() == 4096 ? new FileFilter[]{MacOSXExecutableFileFilter.getInstance(), ElfStaticLibraryFileFilter.getInstance(), MacOSXDynamicLibraryFileFilter.getInstance()} : new FileFilter[]{ElfExecutableFileFilter.getInstance(), ElfStaticLibraryFileFilter.getInstance(), ElfDynamicLibraryFileFilter.getInstance()});
            FileChooser fileChooser = new FileChooser(ParserConfigurationPanel.getString("LIBRARY_CHOOSER_TITLE_TXT"), ParserConfigurationPanel.getString("LIBRARY_CHOOSER_BUTTON_TXT"), 0, fileFilterArray, string, false);
            int n = fileChooser.showOpenDialog((Component)this);
            if (n == 1) {
                return null;
            }
            String string2 = fileChooser.getSelectedFile().getPath();
            string2 = FilePathAdaptor.normalize(string2);
            return string2;
        }

        public String getListLabelText() {
            return ParserConfigurationPanel.getString("LIBRARY_LIST_TXT");
        }

        public char getListLabelMnemonic() {
            return ParserConfigurationPanel.getString("LIBRARY_LIST_MN").charAt(0);
        }

        public String getAddButtonText() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_TXT");
        }

        public char getAddButtonMnemonics() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_MN").charAt(0);
        }

        public String getRenameButtonText() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_TXT");
        }

        public char getRenameButtonMnemonics() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_MN").charAt(0);
        }

        public Object copyAction(Object object) {
            return new String((String)object);
        }

        public void editAction(Object object) {
            String string = (String)object;
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(ParserConfigurationPanel.getString("EDIT_DIALOG_LABEL_TXT"), ParserConfigurationPanel.getString("EDIT_DIALOG_TITLE_TXT"));
            inputLine.setInputText(string);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (inputLine.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String string2 = inputLine.getInputText();
            Vector vector = this.getListData();
            Object[] objectArray = this.getListData().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != object) continue;
                vector.remove(i);
                vector.add(i, string2);
                break;
            }
        }
    }
}

