/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.support.SimpleBpelModelVisitor;
import org.netbeans.modules.bpel.model.spi.BpelModelFactory;
import org.netbeans.modules.bpel.refactoring.BpelVisitor;
import org.netbeans.modules.bpel.refactoring.Element;
import org.netbeans.modules.bpel.refactoring.WsdlVisitor;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.xml.refactoring.ErrorItem;
import org.netbeans.modules.xml.refactoring.XMLRefactoringPlugin;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLVisitor;
import org.netbeans.modules.xml.wsdl.refactoring.WSDLRefactoringEngine;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Plugin
implements RefactoringPlugin,
XMLRefactoringPlugin {
    private static final String BPEL_MIME_TYPE = "x-bpel+xml";

    Plugin() {
    }

    protected final Set<Component> getRoots(Referenceable referenceable) {
        Set set = SharedUtils.getSearchFiles((Referenceable)referenceable);
        HashSet<Component> hashSet = new HashSet<Component>();
        for (FileObject fileObject : set) {
            try {
                Component component = this.getFileRoot(fileObject);
                hashSet.add(component);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(1, iOException.getMessage());
            }
        }
        return hashSet;
    }

    protected final List<Element> find(Referenceable referenceable, Component component) {
        Object object;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        if (component == null) {
            return arrayList2;
        }
        if (!(referenceable instanceof Referenceable)) {
            return arrayList2;
        }
        if (component instanceof Process) {
            object = new BpelVisitor(arrayList, referenceable);
            ((Process)component).accept((SimpleBpelModelVisitor)object);
        } else if (component instanceof Definitions) {
            object = new WsdlVisitor(arrayList, referenceable);
            ((Definitions)component).accept((WSDLVisitor)object);
        }
        for (Component component2 : arrayList) {
            arrayList2.add(new Element(component2));
        }
        return arrayList2;
    }

    private Component getFileRoot(FileObject fileObject) throws IOException {
        Definitions definitions = WSDLRefactoringEngine.getWSDLDefinitions((FileObject)fileObject);
        if (definitions != null) {
            return definitions;
        }
        if (!"text/x-bpel+xml".equals(FileUtil.getMIMEType((FileObject)fileObject))) {
            return null;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        BpelModel bpelModel = EditorUtil.getBpelModel((DataObject)dataObject);
        if (bpelModel == null) {
            return null;
        }
        return bpelModel.getProcess();
    }

    public Problem preCheck() {
        return null;
    }

    public void cancelRequest() {
    }

    protected List<Model> getModels(List<Element> list) {
        ArrayList<Model> arrayList = new ArrayList<Model>();
        for (Element element : list) {
            arrayList.add(((Component)element.getLookup().lookup(Component.class)).getModel());
        }
        return arrayList;
    }

    protected Problem processErrors(List<ErrorItem> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Problem problem = null;
        Problem problem2 = null;
        Problem problem3 = null;
        for (ErrorItem errorItem : list) {
            if (problem == null) {
                problem2 = problem = new Problem(this.isFatal(errorItem), errorItem.getMessage());
                problem3 = problem;
                continue;
            }
            problem2 = new Problem(this.isFatal(errorItem), errorItem.getMessage());
            problem.setNext(problem2);
            problem = problem2;
        }
        return problem3;
    }

    protected boolean isFatal(ErrorItem errorItem) {
        return errorItem.getLevel() == ErrorItem.Level.FATAL;
    }

    public String getModelReference(Component component) {
        if (component instanceof Import) {
            return ((Import)component).getLocation();
        }
        return null;
    }

    public void setModelReference(Component component, String string) {
        if (component instanceof Import) {
            try {
                ((Import)component).setLocation(string);
            }
            catch (VetoException vetoException) {
                return;
            }
        }
    }

    public Collection<Component> getExternalReferences(Model model) {
        return new ArrayList<Component>();
    }

    public Model getModel(ModelSource modelSource) {
        FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
        if (BPEL_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)fileObject))) {
            BpelModelFactory bpelModelFactory = (BpelModelFactory)Lookup.getDefault().lookup(BpelModelFactory.class);
            return bpelModelFactory.getModel(modelSource);
        }
        return null;
    }
}

